/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid;

import jprofilegrid.data.AnalysisOptions;
import jprofilegrid.data.GlobalData;
import jprofilegrid.data.calculations.GridData;
import jprofilegrid.data.calculations.MultipleSequenceAlignment;
import jprofilegrid.file.readers.CommandLineParser;
import jprofilegrid.gui.GlobalGUIData;
import jxl.format.Colour;

public class JProfileGrid {
    public static void main(String[] args) {
        if (args.length == 0) {
            GlobalGUIData globalGUIData = new GlobalGUIData();
            globalGUIData.displayWindow();
        } else {
            try {
                CommandLineParser parser = new CommandLineParser(args);
                GlobalData.gridData = new GridData(parser.getDataFile(), parser.getDataFile(), -2, (int)parser.getAlignmentType());
                AnalysisOptions analysisOptions = GlobalData.analysisOptions;
                MultipleSequenceAlignment msa = GlobalData.gridData.getMultipleSequenceAlignment();
                analysisOptions.setHighlightSequence(msa.getSequence((int)parser.getHighlightSequence()));
                analysisOptions.setTemplateSequence(msa.getSequence((int)parser.getTemplateSequence()));
                analysisOptions.setHighlightSequenceColour(Colour.OCEAN_BLUE);
                analysisOptions.setPositionRowStart((int)parser.getPositionRowStart());
                analysisOptions.setShowValuesAs((int)parser.getShowValuesAs());
                analysisOptions.setSkipGaps(parser.getSkipPositionGaps() == 1.0);
                analysisOptions.setSortAscending(parser.getAscending() == 1.0);
                analysisOptions.setSortType((int)parser.getSortType());
                GlobalData.gridData.setAnalysisParameters(String.valueOf(parser.getDataFile()) + ".xls", (int)parser.getWindowSize() == 0 ? 5 : (int)parser.getWindowSize(), (int)parser.getColumnsPerTier() == 0 ? 50 : (int)parser.getColumnsPerTier(), parser.getThreshold() == 0.0 ? 0.7 : parser.getThreshold(), true, true);
                GlobalData.gridData.analyze(false);
                GlobalData.gridData.setFirstColumn(1);
                GlobalData.gridData.setLastColumn(GlobalData.gridData.getMultipleSequenceAlignment().getMinSequenceLength());
                GlobalData.gridData.outputExcelFile();
                System.exit(0);
            }
            catch (NumberFormatException e) {
                System.out.println(e);
            }
        }
    }
}

