/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.data;

import java.util.Vector;
import jprofilegrid.data.GlobalData;
import jprofilegrid.data.calculations.AlignmentConstants;
import jprofilegrid.data.calculations.MultipleSequenceAnalysis;
import jprofilegrid.data.calculations.Sequence;
import jprofilegrid.data.calculations.SortedData;
import jprofilegrid.data.profilegrid.ConservationRange;
import jprofilegrid.data.profilegrid.Format;
import jprofilegrid.data.profilegrid.Numeric;
import jprofilegrid.data.profilegrid.ProfileGrid;
import jprofilegrid.data.profilegrid.Text;
import jprofilegrid.data.profilegrid.Tier;
import jprofilegrid.data.profilegrid.UnknownSymbol;

public class SortedDataToProfileGrid {
    private static int showValuesAs;
    private static int numberOfSequences;
    private static int windowSize;
    private static int numberOfAminoAcids;
    private static int alignmentLength;
    private static Text templateSequenceName;
    private static Text highlightSequenceName;
    private static Text[] positionInAlignmentRow;
    private static Text[] motiffNumberingRow;
    private static Text[] majorAminoAcidRow;
    private static Text[] templateSequenceRow;
    private static Text[] highlightSequenceRow;
    private static Text[] highlightSequenceArray;
    private static Numeric[][] aminoAcidCounts;
    private static String weightedString;
    private static String templateSequenceNameString;
    private static String highlightSequenceNameString;
    private static String sortType;
    private static Tier entireAlignment;
    private static int[] motiffEndpointIndices;
    private static int[] variableRegionEnpointIndices;
    private static int[] numberOfMotiffAndVariableRegions;
    private static Vector<Double> plotSimValues;

    public static void updateProfileGrid() {
        SortedData sortedData = GlobalData.gridData.getSortedData();
        ConservationRange conservationRange = GlobalData.gridData.getConservationRanges();
        AlignmentConstants alignmentConstraints = GlobalData.gridData.getAlignmentConstants();
        double threshold = GlobalData.gridData.getThreshold();
        boolean frequencyColorsEnabled = GlobalData.gridData.getFrequencyColorsEnabled();
        SortedDataToProfileGrid.computeProfileGrid(sortedData, conservationRange, threshold, frequencyColorsEnabled, alignmentConstraints);
    }

    public static void computeProfileGrid(SortedData sortedData, ConservationRange conservationRanges, double threshold, boolean frequencyColorsEnabled, AlignmentConstants constants) {
        GlobalData.gridData.setProfileGrid(null);
        Runtime r = Runtime.getRuntime();
        r.gc();
        MultipleSequenceAnalysis msa = GlobalData.gridData.getMSA();
        weightedString = msa != null ? msa.getWeightedString() : null;
        plotSimValues = msa != null ? msa.getCorrected().get(msa.getWindowLength()) : null;
        windowSize = msa != null ? msa.getWindowLength() : 0;
        numberOfAminoAcids = sortedData.getSortedAminoAcidNames().length;
        alignmentLength = GlobalData.gridData.getMultipleSequenceAlignment().getMinSequenceLength();
        positionInAlignmentRow = new Text[alignmentLength];
        highlightSequenceArray = new Text[alignmentLength];
        int[] positionInAlignmentRowWithoutSkippingGaps = new int[alignmentLength];
        motiffNumberingRow = new Text[alignmentLength];
        majorAminoAcidRow = new Text[alignmentLength];
        templateSequenceRow = new Text[alignmentLength];
        highlightSequenceRow = new Text[alignmentLength];
        aminoAcidCounts = new Numeric[alignmentLength][numberOfAminoAcids];
        templateSequenceNameString = GlobalData.analysisOptions.getTemplateSequence().getSpecies();
        highlightSequenceNameString = GlobalData.analysisOptions.getHighlightSequence().getSpecies();
        templateSequenceName = new Text(new Format(Format.RIGHT_ALIGNED, true), templateSequenceNameString);
        highlightSequenceName = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), highlightSequenceNameString.equalsIgnoreCase(templateSequenceNameString) ? "" : highlightSequenceNameString);
        sortType = sortedData.getSortType();
        if (!highlightSequenceName.getValue().equalsIgnoreCase("")) {
            highlightSequenceName.getFormat().setBorderColor(GlobalData.analysisOptions.getHighlightSequenceColour());
        }
        motiffEndpointIndices = msa != null ? msa.getMotiffEndpointIndices() : null;
        variableRegionEnpointIndices = msa != null ? msa.getVariableEndpointIndices() : null;
        showValuesAs = GlobalData.analysisOptions.getShowValuesAs();
        numberOfSequences = GlobalData.gridData.getMultipleSequenceAlignment().getNumberOfSequences();
        int i = 0;
        while (i < alignmentLength) {
            SortedDataToProfileGrid.positionInAlignmentRow[i] = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "");
            SortedDataToProfileGrid.highlightSequenceArray[i] = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "");
            SortedDataToProfileGrid.motiffNumberingRow[i] = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "");
            SortedDataToProfileGrid.majorAminoAcidRow[i] = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "");
            SortedDataToProfileGrid.templateSequenceRow[i] = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "");
            SortedDataToProfileGrid.highlightSequenceRow[i] = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), highlightSequenceNameString.equalsIgnoreCase(templateSequenceNameString) ? "" : GlobalData.analysisOptions.getHighlightSequence().getAminoAcid(i));
            int j = 0;
            while (j < numberOfAminoAcids) {
                double curData = 0.0;
                if (showValuesAs != 2) {
                    curData = (double)sortedData.getAminoAcidCounts()[i][j] / (showValuesAs == 0 ? 1.0 : (double)numberOfSequences);
                }
                SortedDataToProfileGrid.aminoAcidCounts[i][j] = new Numeric(new Format(Format.CENTER_ALIGNED, Format.NOT_BOLD), curData);
                ++j;
            }
            ++i;
        }
        entireAlignment = new Tier(positionInAlignmentRow, motiffNumberingRow, majorAminoAcidRow, templateSequenceRow, aminoAcidCounts, constants, sortedData.getAminoAcidCounts(), positionInAlignmentRowWithoutSkippingGaps, highlightSequenceArray);
        entireAlignment.setHighlightSequenceRow(highlightSequenceRow);
        if (msa != null && GlobalData.analysisOptions.getSimilarityParametersEnabled()) {
            numberOfMotiffAndVariableRegions = SortedDataToProfileGrid.calculateNumberOfMotiffAndVariableRegions();
            SortedDataToProfileGrid.calculateMotiffBorderings();
        }
        if (frequencyColorsEnabled) {
            SortedDataToProfileGrid.calculateConservedCellColors(entireAlignment.getAminoAcidCounts(), conservationRanges, GlobalData.gridData.getMultipleSequenceAlignment().getNumberOfSequences(), sortedData);
        }
        SortedDataToProfileGrid.calculateMajorRow(entireAlignment, sortedData.getSortedAminoAcidSymbols(), threshold * (double)GlobalData.gridData.getMultipleSequenceAlignment().getNumberOfSequences(), sortedData);
        SortedDataToProfileGrid.calculatePositionRow(entireAlignment.getPositionInAlignmentRow(), positionInAlignmentRowWithoutSkippingGaps);
        if (!highlightSequenceNameString.equals(templateSequenceNameString)) {
            SortedDataToProfileGrid.calculatePositionRowForHighlightSequence(entireAlignment.getHighlightSequenceArray(), positionInAlignmentRowWithoutSkippingGaps);
        }
        if (msa != null && GlobalData.analysisOptions.getSimilarityParametersEnabled()) {
            SortedDataToProfileGrid.calculateMotiffAndVarRegions();
        }
        SortedDataToProfileGrid.calculateTemplateSequenceRow(entireAlignment.getTemplateSequenceRow());
        SortedDataToProfileGrid.calculateHighlightSequenceCells(entireAlignment.getAminoAcidCounts());
        Vector<UnknownSymbol> unknownSymbols = msa != null ? msa.getUnknownSymbols() : null;
        GlobalData.gridData.setProfileGrid(new ProfileGrid(entireAlignment, sortedData.getSortedAminoAcidNames(), sortedData.getSortedAminoAcidSymbols(), templateSequenceName, sortType, highlightSequenceName, motiffEndpointIndices, variableRegionEnpointIndices, numberOfMotiffAndVariableRegions, unknownSymbols, conservationRanges, plotSimValues, windowSize, weightedString, GlobalData.gridData.getMultipleSequenceAlignment().getNumberOfSequences(), constants));
    }

    private static int[] calculateNumberOfMotiffAndVariableRegions() {
        int numberOfMotifRegions = motiffEndpointIndices.length / 2;
        int numberOfVariableRegions = variableRegionEnpointIndices.length / 2;
        return new int[]{numberOfMotifRegions, numberOfVariableRegions};
    }

    private static void calculateMotiffBorderings() {
        Text[] majorAminoAcidRow = entireAlignment.getMajorAminoAcidRow();
        Text[] comparisonSequenceRow = entireAlignment.getTemplateSequenceRow();
        Text[] highlightSequenceRow = entireAlignment.getHighlightSequenceRow();
        Numeric[][] aminoAcidCounts = entireAlignment.getAminoAcidCounts();
        Format[] majorAminoAcidRowFormats = new Format[majorAminoAcidRow.length];
        Format[] comparisonSequenceRowFormats = new Format[comparisonSequenceRow.length];
        Format[] highlightSequenceRowFormats = new Format[highlightSequenceRow.length];
        Format[][] aminoAcidCountsFormats = new Format[aminoAcidCounts.length][];
        int i = 0;
        while (i < entireAlignment.getMajorAminoAcidRow().length) {
            majorAminoAcidRowFormats[i] = entireAlignment.getMajorAminoAcidRow()[i].getFormat();
            ++i;
        }
        i = 0;
        while (i < entireAlignment.getTemplateSequenceRow().length) {
            comparisonSequenceRowFormats[i] = entireAlignment.getTemplateSequenceRow()[i].getFormat();
            ++i;
        }
        i = 0;
        while (i < entireAlignment.getHighlightSequenceRow().length) {
            highlightSequenceRowFormats[i] = entireAlignment.getHighlightSequenceRow()[i].getFormat();
            ++i;
        }
        i = 0;
        while (i < entireAlignment.getAminoAcidCounts().length) {
            aminoAcidCountsFormats[i] = new Format[aminoAcidCounts[i].length];
            int j = 0;
            while (j < entireAlignment.getAminoAcidCounts()[i].length) {
                aminoAcidCountsFormats[i][j] = entireAlignment.getAminoAcidCounts()[i][j].getFormat();
                ++j;
            }
            ++i;
        }
        boolean leftEndpoint = true;
        boolean inMotiff = false;
        int indexIntoMotiffEndpoints = 0;
        int i2 = 0;
        while (i2 < aminoAcidCountsFormats.length && indexIntoMotiffEndpoints < motiffEndpointIndices.length) {
            if (i2 == motiffEndpointIndices[indexIntoMotiffEndpoints]) {
                int j;
                ++indexIntoMotiffEndpoints;
                majorAminoAcidRowFormats[i2].setTopBorderEnabled(true);
                aminoAcidCountsFormats[i2][aminoAcidCountsFormats[i2].length - 1].setBottomBorderEnabled(true);
                if (leftEndpoint) {
                    inMotiff = true;
                    majorAminoAcidRowFormats[i2].setLeftBorderEnabled(true);
                    comparisonSequenceRowFormats[i2].setLeftBorderEnabled(true);
                    highlightSequenceRowFormats[i2].setLeftBorderEnabled(true);
                    j = 0;
                    while (j < aminoAcidCountsFormats[i2].length) {
                        aminoAcidCountsFormats[i2][j].setLeftBorderEnabled(true);
                        ++j;
                    }
                } else {
                    inMotiff = false;
                    majorAminoAcidRowFormats[i2].setRightBorderEnabled(true);
                    comparisonSequenceRowFormats[i2].setRightBorderEnabled(true);
                    highlightSequenceRowFormats[i2].setRightBorderEnabled(true);
                    j = 0;
                    while (j < aminoAcidCountsFormats[i2].length) {
                        aminoAcidCountsFormats[i2][j].setRightBorderEnabled(true);
                        ++j;
                    }
                }
                boolean bl = leftEndpoint = !leftEndpoint;
            }
            if (inMotiff) {
                majorAminoAcidRowFormats[i2].setTopBorderEnabled(true);
                aminoAcidCountsFormats[i2][aminoAcidCountsFormats[i2].length - 1].setBottomBorderEnabled(true);
            }
            ++i2;
        }
    }

    private static void calculateMotiffAndVarRegions() {
        int j;
        int currentNum = 0;
        Text[] motifNumberingRow = entireAlignment.getMorphNumberingRow();
        int i = 0;
        while (i < motiffEndpointIndices.length) {
            j = motiffEndpointIndices[i];
            while (j <= motiffEndpointIndices[i + 1]) {
                motifNumberingRow[j].setValue("Mot " + currentNum);
                ++j;
            }
            ++currentNum;
            i += 2;
        }
        currentNum = 0;
        i = 0;
        while (i < variableRegionEnpointIndices.length) {
            j = variableRegionEnpointIndices[i];
            while (j <= variableRegionEnpointIndices[i + 1]) {
                motifNumberingRow[j].setValue("Var " + currentNum);
                ++j;
            }
            ++currentNum;
            i += 2;
        }
    }

    private static void calculateConservedCellColors(Numeric[][] aminoAcidCounts, ConservationRange conservationRanges, double numberOfSequences, SortedData sortedData) {
        int i = 0;
        while (i < aminoAcidCounts.length) {
            int j = 0;
            while (j < aminoAcidCounts[i].length) {
                double maxValSet = 0.0;
                int k = 0;
                while (k < conservationRanges.getNumberOfRanges()) {
                    if ((double)sortedData.getAminoAcidCounts()[i][j] / numberOfSequences >= conservationRanges.getThreshold(k) && maxValSet <= conservationRanges.getThreshold(k)) {
                        aminoAcidCounts[i][j].getFormat().setBackgroundColor(conservationRanges.getColour(k));
                        maxValSet = conservationRanges.getThreshold(k);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private static void calculateMajorRow(Tier entireAlignment, String[] sortedAminoAcidSymbols, double threshold, SortedData sortedData) {
        int i = 0;
        while (i < entireAlignment.getMajorAminoAcidRow().length) {
            int indexOfMaxiumumOccuringAminoAcid;
            int[] currentColumn = sortedData.getAminoAcidCounts()[i];
            if ((double)currentColumn[indexOfMaxiumumOccuringAminoAcid = SortedDataToProfileGrid.getIndexOfMaximumOccuringAminoAcidIn(currentColumn)] > threshold && !sortedAminoAcidSymbols[indexOfMaxiumumOccuringAminoAcid].equalsIgnoreCase("*") && !sortedAminoAcidSymbols[indexOfMaxiumumOccuringAminoAcid].equalsIgnoreCase("-") && !sortedAminoAcidSymbols[indexOfMaxiumumOccuringAminoAcid].equalsIgnoreCase(".")) {
                entireAlignment.getMajorAminoAcidRow()[i].setValue(sortedAminoAcidSymbols[indexOfMaxiumumOccuringAminoAcid]);
            }
            ++i;
        }
    }

    private static int getIndexOfMaximumOccuringAminoAcidIn(int[] aminoAcidCountsColumn) {
        int index = 0;
        double maxCounts = 0.0;
        int i = 0;
        while (i < aminoAcidCountsColumn.length) {
            if ((double)aminoAcidCountsColumn[i] > maxCounts) {
                index = i;
                maxCounts = aminoAcidCountsColumn[i];
            }
            ++i;
        }
        return index;
    }

    private static void calculatePositionRow(Text[] positionInAlignmentRow, int[] positionInAlignmentRowWithoutSkippingGaps) {
        int currentPosition = GlobalData.analysisOptions.getPositionRowStart();
        Sequence templateSequence = GlobalData.analysisOptions.getTemplateSequence();
        int i = 0;
        while (i < positionInAlignmentRow.length) {
            positionInAlignmentRowWithoutSkippingGaps[i] = currentPosition;
            if (GlobalData.analysisOptions.getSkipGaps()) {
                if (!(templateSequence.getAminoAcid(i).equalsIgnoreCase("*") || templateSequence.getAminoAcid(i).equalsIgnoreCase("-") || templateSequence.getAminoAcid(i).equalsIgnoreCase("."))) {
                    positionInAlignmentRow[i].setValue(String.valueOf(currentPosition));
                    ++currentPosition;
                }
            } else {
                positionInAlignmentRow[i].setValue(String.valueOf(currentPosition));
                ++currentPosition;
            }
            ++i;
        }
    }

    private static void calculatePositionRowForHighlightSequence(Text[] highlightSequenceArray, int[] positionInAlignmentRowWithoutSkippingGaps) {
        int currentPosition = GlobalData.analysisOptions.getPositionRowStart();
        Sequence highlightSequence = GlobalData.analysisOptions.getHighlightSequence();
        int i = 0;
        while (i < highlightSequenceArray.length) {
            positionInAlignmentRowWithoutSkippingGaps[i] = currentPosition;
            if (GlobalData.analysisOptions.getSkipGaps()) {
                if (!(highlightSequence.getAminoAcid(i).equalsIgnoreCase("*") || highlightSequence.getAminoAcid(i).equalsIgnoreCase("-") || highlightSequence.getAminoAcid(i).equalsIgnoreCase("."))) {
                    highlightSequenceArray[i].setValue(String.valueOf(currentPosition));
                    ++currentPosition;
                }
            } else {
                highlightSequenceArray[i].setValue(String.valueOf(currentPosition));
                ++currentPosition;
            }
            ++i;
        }
    }

    private static void calculateTemplateSequenceRow(Text[] comparisonSequenceRow) {
        Sequence templateSequence = GlobalData.analysisOptions.getTemplateSequence();
        int i = 0;
        while (i < comparisonSequenceRow.length) {
            comparisonSequenceRow[i].setValue(templateSequence.getAminoAcid(i));
            ++i;
        }
    }

    private static void calculateHighlightSequenceCells(Numeric[][] aminoAcidCounts) {
        String[] aminoAcidSymbols = GlobalData.gridData.getSortedData().getSortedAminoAcidSymbols();
        Sequence templateSequence = GlobalData.analysisOptions.getTemplateSequence();
        Sequence highlightSequence = GlobalData.analysisOptions.getHighlightSequence();
        int i = 0;
        while (i < aminoAcidCounts.length) {
            int j = 0;
            while (j < aminoAcidCounts[i].length) {
                if (!highlightSequence.getAminoAcid(i).equalsIgnoreCase(templateSequence.getAminoAcid(i)) && highlightSequence.getAminoAcid(i).equalsIgnoreCase(aminoAcidSymbols[j])) {
                    aminoAcidCounts[i][j].getFormat().setBorderColor(GlobalData.analysisOptions.getHighlightSequenceColour());
                    aminoAcidCounts[i][j].getFormat().setLeftBorderEnabled(true);
                    aminoAcidCounts[i][j].getFormat().setRightBorderEnabled(true);
                    aminoAcidCounts[i][j].getFormat().setTopBorderEnabled(true);
                    aminoAcidCounts[i][j].getFormat().setBottomBorderEnabled(true);
                }
                ++j;
            }
            ++i;
        }
    }
}

