/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.data.calculations;

import java.util.Hashtable;
import jprofilegrid.data.calculations.AlignmentConstants;

public class AminoAcidConstants
extends AlignmentConstants {
    private static String[] AMINO_ACID_NAMES = new String[]{"ala", "cys", "asp", "glu", "phe", "gly", "his", "ile", "lys", "leu", "met", "asn", "pro", "gln", "arg", "ser", "thr", "val", "trp", "tyr", "gap"};
    private static String[] AMINO_ACID_SYMBOLS = new String[]{"A", "C", "D", "E", "F", "G", "H", "I", "K", "L", "M", "N", "P", "Q", "R", "S", "T", "V", "W", "Y", "*"};
    public static String[] COUNTS_AND_FREQ = new String[]{"Count", "FreqM"};
    public static String[] CONSTANT_NAMES = new String[]{"Age", "Flex", "FreqK", "Hpathy", "Hphob", "Helix", "Mutab", "Grnthm", "ASA", "Volume"};
    private static String[] SORT_TYPES = new String[]{"Alphabetical-Code", "Alphabetical-Name", "Age", "Flexibility", "Frequency-EcoliK12", "Hydropathy", "Hydrophobicity", "Helix-Propensity", "Mutability-Dayhoff", "Mutability-Grantham", "Surface-Area", "Volume"};
    public static double[] FREQK = new double[]{9.5, 1.2, 5.1, 5.8, 3.9, 7.3, 2.3, 6.0, 4.4, 10.7, 2.8, 3.9, 4.4, 4.4, 5.5, 5.8, 5.4, 7.1, 1.5, 2.9};
    public static double[] AGE = new double[]{2.0, 13.0, 3.0, 7.0, 14.0, 1.0, 11.0, 10.0, 12.0, 8.0, 16.0, 10.0, 5.0, 10.0, 9.0, 6.0, 8.0, 4.0, 17.0, 15.0};
    public static double[] VOLUME = new double[]{67.0, 86.0, 91.0, 114.0, 135.0, 48.0, 118.0, 124.0, 135.0, 124.0, 124.0, 96.0, 90.0, 109.0, 148.0, 73.0, 93.0, 105.0, 163.0, 141.0};
    public static double[] ASA = new double[]{115.0, 135.0, 150.0, 190.0, 210.0, 75.0, 195.0, 175.0, 200.0, 170.0, 185.0, 160.0, 145.0, 180.0, 225.0, 115.0, 140.0, 155.0, 255.0, 230.0};
    public static double[] FLEX = new double[]{6.0, 9.5, 8.0, 13.0, 6.4, 20.0, 7.1, 8.7, 14.7, 19.6, 17.7, 8.7, 6.0, 10.7, 13.9, 16.1, 9.3, 10.0, 6.7, 6.2};
    public static double[] HPATHY = new double[]{1.8, 2.5, -3.5, -3.5, 2.8, -0.4, -3.2, 4.5, -3.9, 3.8, 1.9, -3.5, -1.6, -3.5, -4.5, -0.8, -0.7, 4.2, -0.9, -1.3};
    public static double[] HPHOB = new double[]{-0.4, 0.17, -1.31, -0.91, 1.92, -0.67, -0.64, 1.25, -0.67, 1.22, 1.02, -0.92, -0.49, -1.22, -0.59, -0.55, -0.28, 0.91, 0.5, 1.67};
    public static double[] MUTAB = new double[]{100.0, 20.0, 106.0, 93.0, 41.0, 49.0, 66.0, 96.0, 56.0, 40.0, 94.0, 134.0, 56.0, 102.0, 65.0, 120.0, 97.0, 74.0, 18.0, 41.0};
    public static double[] GRNTHM = new double[]{0.75, 0.31, 0.93, 0.82, 0.83, 0.66, 0.53, 0.89, 0.76, 0.92, 0.58, 0.87, 0.67, 0.79, 0.68, 0.76, 0.63, 0.86, 0.58, 0.64};
    public static double[] HELIX = new double[]{-0.27, 0.64, 0.52, 0.21, 0.73, 1.7, 0.57, 0.44, 0.019, 0.095, 0.25, 0.69, 3.8, 0.28, -0.052, 0.52, 0.95, 0.77, 0.69, 0.42};
    public static double[][] ALL_CONSTANTS = new double[][]{AGE, FLEX, FREQK, HPATHY, HPHOB, HELIX, MUTAB, GRNTHM, ASA, VOLUME};
    public static String[] AMINO_ACID_MATRIX_NAMES = new String[]{"A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V", "B", "Z", "X", "*"};
    public static Hashtable<String, Integer> AMINO_ACID_MATRIX_SYMBOLS_TO_INDICES = new Hashtable();
    public static double[][] AMINO_ACID_MATRIX;

    static {
        int i = 0;
        while (i < AMINO_ACID_MATRIX_NAMES.length) {
            AMINO_ACID_MATRIX_SYMBOLS_TO_INDICES.put(AMINO_ACID_MATRIX_NAMES[i], i);
            ++i;
        }
        AMINO_ACID_MATRIX = new double[][]{{4.0, -1.0, -2.0, -2.0, 0.0, -1.0, -1.0, 0.0, -2.0, -1.0, -1.0, -1.0, -1.0, -2.0, -1.0, 1.0, 0.0, -3.0, -2.0, 0.0, -2.0, -1.0, 0.0, -4.0}, {-1.0, 5.0, 0.0, -2.0, -3.0, 1.0, 0.0, -2.0, 0.0, -3.0, -2.0, 2.0, -1.0, -3.0, -2.0, -1.0, -1.0, -3.0, -2.0, -3.0, -1.0, 0.0, -1.0, -4.0}, {-2.0, 0.0, 6.0, 1.0, -3.0, 0.0, 0.0, 0.0, 1.0, -3.0, -3.0, 0.0, -2.0, -3.0, -2.0, 1.0, 0.0, -4.0, -2.0, -3.0, 3.0, 0.0, -1.0, -4.0}, {-2.0, -2.0, 1.0, 6.0, -3.0, 0.0, 2.0, -1.0, -1.0, -3.0, -4.0, -1.0, -3.0, -3.0, -1.0, 0.0, -1.0, -4.0, -3.0, -3.0, 4.0, 1.0, -1.0, -4.0}, {0.0, -3.0, -3.0, -3.0, 9.0, -3.0, -4.0, -3.0, -3.0, -1.0, -1.0, -3.0, -1.0, -2.0, -3.0, -1.0, -1.0, -2.0, -2.0, -1.0, -3.0, -3.0, -2.0, -4.0}, {-1.0, 1.0, 0.0, 0.0, -3.0, 5.0, 2.0, -2.0, 0.0, -3.0, -2.0, 1.0, 0.0, -3.0, -1.0, 0.0, -1.0, -2.0, -1.0, -2.0, 0.0, 3.0, -1.0, -4.0}, {-1.0, 0.0, 0.0, 2.0, -4.0, 2.0, 5.0, -2.0, 0.0, -3.0, -3.0, 1.0, -2.0, -3.0, -1.0, 0.0, -1.0, -3.0, -2.0, -2.0, 1.0, 4.0, -1.0, -4.0}, {0.0, -2.0, 0.0, -1.0, -3.0, -2.0, -2.0, 6.0, -2.0, -4.0, -4.0, -2.0, -3.0, -3.0, -2.0, 0.0, -2.0, -2.0, -3.0, -3.0, -1.0, -2.0, -1.0, -4.0}, {-2.0, 0.0, 1.0, -1.0, -3.0, 0.0, 0.0, -2.0, 8.0, -3.0, -3.0, -1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -2.0, 2.0, -3.0, 0.0, 0.0, -1.0, -4.0}, {-1.0, -3.0, -3.0, -3.0, -1.0, -3.0, -3.0, -4.0, -3.0, 4.0, 2.0, -3.0, 1.0, 0.0, -3.0, -2.0, -1.0, -3.0, -1.0, 3.0, -3.0, -3.0, -1.0, -4.0}, {-1.0, -2.0, -3.0, -4.0, -1.0, -2.0, -3.0, -4.0, -3.0, 2.0, 4.0, -2.0, 2.0, 0.0, -3.0, -2.0, -1.0, -2.0, -1.0, 1.0, -4.0, -3.0, -1.0, -4.0}, {-1.0, 2.0, 0.0, -1.0, -3.0, 1.0, 1.0, -2.0, -1.0, -3.0, -2.0, 5.0, -1.0, -3.0, -1.0, 0.0, -1.0, -3.0, -2.0, -2.0, 0.0, 1.0, -1.0, -4.0}, {-1.0, -1.0, -2.0, -3.0, -1.0, 0.0, -2.0, -3.0, -2.0, 1.0, 2.0, -1.0, 5.0, 0.0, -2.0, -1.0, -1.0, -1.0, -1.0, 1.0, -3.0, -1.0, -1.0, -4.0}, {-2.0, -3.0, -3.0, -3.0, -2.0, -3.0, -3.0, -3.0, -1.0, 0.0, 0.0, -3.0, 0.0, 6.0, -4.0, -2.0, -2.0, 1.0, 3.0, -1.0, -3.0, -3.0, -1.0, -4.0}, {-1.0, -2.0, -2.0, -1.0, -3.0, -1.0, -1.0, -2.0, -2.0, -3.0, -3.0, -1.0, -2.0, -4.0, 7.0, -1.0, -1.0, -4.0, -3.0, -2.0, -2.0, -1.0, -2.0, -4.0}, {1.0, -1.0, 1.0, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0, -2.0, -2.0, 0.0, -1.0, -2.0, -1.0, 4.0, 1.0, -3.0, -2.0, -2.0, 0.0, 0.0, 0.0, -4.0}, {0.0, -1.0, 0.0, -1.0, -1.0, -1.0, -1.0, -2.0, -2.0, -1.0, -1.0, -1.0, -1.0, -2.0, -1.0, 1.0, 5.0, -2.0, -2.0, 0.0, -1.0, -1.0, 0.0, -4.0}, {-3.0, -3.0, -4.0, -4.0, -2.0, -2.0, -3.0, -2.0, -2.0, -3.0, -2.0, -3.0, -1.0, 1.0, -4.0, -3.0, -2.0, 11.0, 2.0, -3.0, -4.0, -3.0, -2.0, -4.0}, {-2.0, -2.0, -2.0, -3.0, -2.0, -1.0, -2.0, -3.0, 2.0, -1.0, -1.0, -2.0, -1.0, 3.0, -3.0, -2.0, -2.0, 2.0, 7.0, -1.0, -3.0, -2.0, -1.0, -4.0}, {0.0, -3.0, -3.0, -3.0, -1.0, -2.0, -2.0, -3.0, -3.0, 3.0, 1.0, -2.0, 1.0, -1.0, -2.0, -2.0, 0.0, -3.0, -1.0, 4.0, -3.0, -2.0, -1.0, -4.0}, {-2.0, -1.0, 3.0, 4.0, -3.0, 0.0, 1.0, -1.0, 0.0, -3.0, -4.0, 0.0, -3.0, -3.0, -2.0, 0.0, -1.0, -4.0, -3.0, -3.0, 4.0, 1.0, -1.0, -4.0}, {-1.0, 0.0, 0.0, 1.0, -3.0, 3.0, 4.0, -2.0, 0.0, -3.0, -3.0, 1.0, -1.0, -3.0, -1.0, 0.0, -1.0, -3.0, -2.0, -2.0, 1.0, 4.0, -1.0, -4.0}, {0.0, -1.0, -1.0, -1.0, -2.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -2.0, 0.0, 0.0, -2.0, -1.0, -1.0, -1.0, -1.0, -1.0, -4.0}, {-4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, -4.0, 1.0}};
    }

    public boolean isSymbolDefined(String symbol) {
        if (symbol.equalsIgnoreCase("*") || symbol.equalsIgnoreCase(".") || symbol.equalsIgnoreCase("-") || symbol.equalsIgnoreCase("_")) {
            return true;
        }
        if (symbol.equalsIgnoreCase("B") || symbol.equalsIgnoreCase("J") || symbol.equalsIgnoreCase("O") || symbol.equalsIgnoreCase("U") || symbol.equalsIgnoreCase("X") || symbol.equalsIgnoreCase("Z")) {
            return false;
        }
        return AMINO_ACID_MATRIX_SYMBOLS_TO_INDICES.get(symbol) != null;
    }

    public static double getMatrixValue(String aa1, String aa2) {
        Integer loc1 = AMINO_ACID_MATRIX_SYMBOLS_TO_INDICES.get(aa1);
        Integer loc2 = AMINO_ACID_MATRIX_SYMBOLS_TO_INDICES.get(aa2);
        if (loc1 == null) {
            loc1 = AMINO_ACID_MATRIX.length - 1;
        }
        if (loc2 == null) {
            loc2 = AMINO_ACID_MATRIX.length - 1;
        }
        return AMINO_ACID_MATRIX[loc1][loc2];
    }

    public double[] getConstantsForSymbol(int index) {
        double[] constants = new double[ALL_CONSTANTS.length];
        int i = 0;
        while (i < ALL_CONSTANTS.length) {
            constants[i] = ALL_CONSTANTS[i][index];
            ++i;
        }
        return constants;
    }

    public double[] getConstantsForSymbol(String aminoAcidSymbol) {
        int i = 0;
        while (i < AMINO_ACID_SYMBOLS.length) {
            if (AMINO_ACID_SYMBOLS[i].equalsIgnoreCase(aminoAcidSymbol)) {
                return this.getConstantsForSymbol(i);
            }
            ++i;
        }
        return null;
    }

    public String[] getNames() {
        return AMINO_ACID_NAMES;
    }

    public String[] getSymbols() {
        return AMINO_ACID_SYMBOLS;
    }

    public String[] getSortTypes() {
        return SORT_TYPES;
    }
}

