/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.data.calculations;

import java.util.Hashtable;
import jprofilegrid.data.calculations.AlignmentConstants;

public class DNAConstants
extends AlignmentConstants {
    public static String[] NUCLEIC_ACID_NAMES = new String[]{"ade", "cyt", "gua", "thy", "gap"};
    public static String[] NUCLEIC_ACID_SYMBOLS = new String[]{"A", "C", "G", "T", "."};
    public static String[] SORT_TYPES = new String[]{"Alphabetical-Code", "Alphabetical-Name"};
    public static String[] NUCLEIC_ACID_MATRIX_NAMES = new String[]{"A", "T", "G", "C"};
    public static Hashtable<String, Integer> NUCLEIC_ACID_MATRIX_SYMBOLS_TO_INDICES = new Hashtable();
    public static double[][] NUCLEIC_ACID_MATRIX;

    static {
        int i = 0;
        while (i < NUCLEIC_ACID_MATRIX_NAMES.length) {
            NUCLEIC_ACID_MATRIX_SYMBOLS_TO_INDICES.put(NUCLEIC_ACID_MATRIX_NAMES[i], i);
            ++i;
        }
        NUCLEIC_ACID_MATRIX = new double[][]{{5.0, -4.0, -4.0, -4.0, -4.0, 1.0, 1.0, -4.0, -4.0, 1.0, -4.0, -1.0, -1.0, -1.0, -2.0}, {-4.0, 5.0, -4.0, -4.0, -4.0, 1.0, -4.0, 1.0, 1.0, -4.0, -1.0, -4.0, -1.0, -1.0, -2.0}, {-4.0, -4.0, 5.0, -4.0, 1.0, -4.0, 1.0, -4.0, 1.0, -4.0, -1.0, -1.0, -4.0, -1.0, -2.0}, {-4.0, -4.0, -4.0, 5.0, 1.0, -4.0, -4.0, 1.0, -4.0, 1.0, -1.0, -1.0, -1.0, -4.0, -2.0}, {-4.0, -4.0, 1.0, 1.0, -1.0, -4.0, -2.0, -2.0, -2.0, -2.0, -1.0, -1.0, -3.0, -3.0, -1.0}, {1.0, 1.0, -4.0, -4.0, -4.0, -1.0, -2.0, -2.0, -2.0, -2.0, -3.0, -3.0, -1.0, -1.0, -1.0}, {1.0, -4.0, 1.0, -4.0, -2.0, -2.0, -1.0, -4.0, -2.0, -2.0, -3.0, -1.0, -3.0, -1.0, -1.0}, {-4.0, 1.0, -4.0, 1.0, -2.0, -2.0, -4.0, -1.0, -2.0, -2.0, -1.0, -3.0, -1.0, -3.0, -1.0}, {-4.0, 1.0, 1.0, -4.0, -2.0, -2.0, -2.0, -2.0, -1.0, -4.0, -1.0, -3.0, -3.0, -1.0, -1.0}, {1.0, -4.0, -4.0, 1.0, -2.0, -2.0, -2.0, -2.0, -4.0, -1.0, -3.0, -1.0, -1.0, -3.0, -1.0}, {-4.0, -1.0, -1.0, -1.0, -1.0, -3.0, -3.0, -1.0, -1.0, -3.0, -1.0, -2.0, -2.0, -2.0, -1.0}, {-1.0, -4.0, -1.0, -1.0, -1.0, -3.0, -1.0, -3.0, -3.0, -1.0, -2.0, -1.0, -2.0, -2.0, -1.0}, {-1.0, -1.0, -4.0, -1.0, -3.0, -1.0, -3.0, -1.0, -3.0, -1.0, -2.0, -2.0, -1.0, -2.0, -1.0}, {-1.0, -1.0, -1.0, -4.0, -3.0, -1.0, -1.0, -3.0, -1.0, -3.0, -2.0, -2.0, -2.0, -1.0, -1.0}, {-2.0, -2.0, -2.0, -2.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0}};
    }

    public boolean isSymbolDefined(String symbol) {
        if (symbol.equalsIgnoreCase("*") || symbol.equalsIgnoreCase(".") || symbol.equalsIgnoreCase("-") || symbol.equalsIgnoreCase("_")) {
            return true;
        }
        return NUCLEIC_ACID_MATRIX_SYMBOLS_TO_INDICES.get(symbol) != null;
    }

    public static double getMatrixValue(String aa1, String aa2) {
        Integer loc1 = NUCLEIC_ACID_MATRIX_SYMBOLS_TO_INDICES.get(aa1);
        Integer loc2 = NUCLEIC_ACID_MATRIX_SYMBOLS_TO_INDICES.get(aa2);
        if (loc1 == null) {
            loc1 = NUCLEIC_ACID_MATRIX.length - 1;
        }
        if (loc2 == null) {
            loc2 = NUCLEIC_ACID_MATRIX.length - 1;
        }
        return NUCLEIC_ACID_MATRIX[loc1][loc2];
    }

    public double[] getConstantsForSymbol(int index) {
        return new double[0];
    }

    public double[] getConstantsForSymbol(String nucleicAcidSymbol) {
        int i = 0;
        while (i < NUCLEIC_ACID_SYMBOLS.length) {
            if (NUCLEIC_ACID_SYMBOLS[i].equalsIgnoreCase(nucleicAcidSymbol)) {
                return this.getConstantsForSymbol(i);
            }
            ++i;
        }
        return null;
    }

    public String[] getNames() {
        return NUCLEIC_ACID_NAMES;
    }

    public String[] getSymbols() {
        return NUCLEIC_ACID_SYMBOLS;
    }

    public String[] getSortTypes() {
        return SORT_TYPES;
    }
}

