/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.data.calculations;

import java.io.File;
import java.io.IOException;
import jprofilegrid.data.SortedDataToProfileGrid;
import jprofilegrid.data.calculations.AlignmentConstants;
import jprofilegrid.data.calculations.AminoAcidConstants;
import jprofilegrid.data.calculations.DNAConstants;
import jprofilegrid.data.calculations.MultipleSequenceAlignment;
import jprofilegrid.data.calculations.MultipleSequenceAnalysis;
import jprofilegrid.data.calculations.SortedData;
import jprofilegrid.data.calculations.SwingWorker;
import jprofilegrid.data.profilegrid.ConservationRange;
import jprofilegrid.data.profilegrid.ProfileGrid;
import jprofilegrid.file.readers.FASTAFileReader;
import jprofilegrid.file.readers.MSFFileReader;
import jprofilegrid.file.writers.excel.ExcelFileWriter;
import jprofilegrid.file.writers.pymol.PyMOLScriptWriter;
import jprofilegrid.gui.GlobalGUIData;
import jxl.Workbook;

public class GridData {
    private String inputFileWithoutPath;
    private String inputFile;
    private String outputFile;
    private MultipleSequenceAlignment multipleSequenceAlignment;
    private MultipleSequenceAnalysis msa;
    private SortedData sData;
    private int windowSize;
    private int columnsPerTier;
    private int firstColumn;
    private int lastColumn;
    private double threshold;
    private ProfileGrid profileGrid;
    private boolean frequencyColorsEnabled = true;
    private boolean gridReadCorrectly = false;
    private boolean simParamEnabled = false;
    private int msaType;
    private ConservationRange cRange = ConservationRange.DEFAULT_CONSERVATION_RANGE;
    private String weightedString;
    private AlignmentConstants constants;

    public GridData(String nInputFileWithoutPath, String nInputFile, int typeOfMSA, int alignmentType) {
        this.inputFileWithoutPath = nInputFileWithoutPath;
        this.inputFile = nInputFile;
        this.msaType = typeOfMSA;
        this.gridReadCorrectly = this.readInputFile();
        if (alignmentType == 0) {
            this.constants = new AminoAcidConstants();
        }
        if (alignmentType == 1) {
            this.constants = new DNAConstants();
        }
    }

    public void setAnalysisParameters(String nOutputFile, int nWindowSize, int nColumnsPerTier, double nThreshold, boolean nFrequencyColorsEnabled, boolean similarityParametersEnabled) {
        this.outputFile = nOutputFile;
        this.windowSize = nWindowSize;
        this.columnsPerTier = nColumnsPerTier;
        this.threshold = nThreshold;
        this.frequencyColorsEnabled = nFrequencyColorsEnabled;
        this.msa = null;
        this.simParamEnabled = similarityParametersEnabled;
    }

    private boolean readInputFile() {
        if (this.msaType == 1) {
            this.multipleSequenceAlignment = FASTAFileReader.readAlignedFasta(new File(this.inputFile));
            this.weightedString = "Unweighted";
        } else if (this.msaType == 0) {
            this.multipleSequenceAlignment = MSFFileReader.readInMultipleSequenceAlignment(new File(this.inputFile));
            this.weightedString = "Weighted";
        } else if (this.inputFile.contains(".afa")) {
            this.multipleSequenceAlignment = FASTAFileReader.readAlignedFasta(new File(this.inputFile));
            this.weightedString = "Unweighted";
        } else if (this.inputFile.contains(".msf")) {
            this.multipleSequenceAlignment = MSFFileReader.readInMultipleSequenceAlignment(new File(this.inputFile));
            this.weightedString = "Weighted";
        } else {
            return false;
        }
        return true;
    }

    public void convertSortedDataToProfileGrid() {
        this.sData = SortedData.analyze(this.multipleSequenceAlignment, this.msa, this.constants);
        SortedDataToProfileGrid.computeProfileGrid(this.sData, this.cRange, this.threshold, this.frequencyColorsEnabled, this.constants);
    }

    public void updateProfileGrid() {
        SortedDataToProfileGrid.updateProfileGrid();
    }

    public void outputExcelFile() {
        try {
            ExcelFileWriter writer = new ExcelFileWriter(Workbook.createWorkbook(new File(this.outputFile)), this.profileGrid);
            writer.writeExcelFile(this.columnsPerTier, this.firstColumn - 1, this.lastColumn - 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void outputPyMOLScript() {
        PyMOLScriptWriter.outputPyMOLScript(this.inputFileWithoutPath, this.outputFile, this.firstColumn, this.lastColumn);
    }

    public MultipleSequenceAnalysis getMSA() {
        return this.msa;
    }

    public ProfileGrid getProfileGrid() {
        return this.profileGrid;
    }

    public void updateOutputFile(String nOutputFile) {
        this.outputFile = nOutputFile;
    }

    public void disableFrequencyColors() {
        this.frequencyColorsEnabled = false;
    }

    public void enableFrequencyColors() {
        this.frequencyColorsEnabled = true;
    }

    public boolean getFrequencyColorsEnabled() {
        return this.frequencyColorsEnabled;
    }

    public boolean gridReadSuccessfuly() {
        return this.gridReadCorrectly;
    }

    public void setColumnsPerTier(int nColumnsPerTier) {
        this.columnsPerTier = nColumnsPerTier;
    }

    public void setFirstColumn(int nFirstColumn) {
        this.firstColumn = nFirstColumn;
    }

    public void setLastColumn(int nLastColumn) {
        this.lastColumn = nLastColumn;
    }

    public void setConservationRange(ConservationRange nCRange) {
        this.cRange = nCRange;
    }

    public ConservationRange getConservationRanges() {
        return this.cRange;
    }

    public void setWeightedString(String nWeightedString) {
        this.weightedString = nWeightedString;
    }

    public MultipleSequenceAlignment getMultipleSequenceAlignment() {
        return this.multipleSequenceAlignment;
    }

    public AlignmentConstants getAlignmentConstants() {
        return this.constants;
    }

    public SortedData getSortedData() {
        return this.sData;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setProfileGrid(ProfileGrid nProfileGrid) {
        this.profileGrid = nProfileGrid;
    }

    public void analyze(boolean isGraphical) {
        if (this.simParamEnabled && isGraphical) {
            GUIComputationWorker guiCW = new GUIComputationWorker();
            guiCW.start();
            this.simParamEnabled = false;
        } else if (isGraphical) {
            this.convertSortedDataToProfileGrid();
            this.updateProfileGrid();
        } else {
            this.msa = MultipleSequenceAnalysis.analyze(this.multipleSequenceAlignment, this.windowSize, this.threshold, this.weightedString, this.constants);
            this.convertSortedDataToProfileGrid();
            this.updateProfileGrid();
        }
    }

    public void finished() {
        this.convertSortedDataToProfileGrid();
    }

    private class GUIComputationWorker
    extends SwingWorker {
        private GUIComputationWorker() {
        }

        public Object construct() {
            GlobalGUIData.globalGUIData.setSimilarityPlotComputeButtonRed();
            GridData.this.msa = MultipleSequenceAnalysis.analyze(GridData.this.multipleSequenceAlignment, GridData.this.windowSize, GridData.this.threshold, GridData.this.weightedString, GridData.this.constants);
            GlobalGUIData.globalGUIData.setSimilarityPlotComputeButtonDone();
            return GridData.this.msa;
        }

        public void finished() {
            GridData.this.convertSortedDataToProfileGrid();
            GlobalGUIData.globalGUIData.resetDisplay();
            GlobalGUIData.globalGUIData.updateProfileGridFrame();
        }
    }
}

