/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.data.calculations;

import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import jprofilegrid.data.calculations.Sequence;
import jprofilegrid.data.calculations.SequenceIdentification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleSequenceAlignment {
    private LinkedList<String> header;
    private SequenceIdentification sequenceInfo;
    int minSequenceLength;
    private String alignmentName;

    public MultipleSequenceAlignment(LinkedList<String> nHeader, SequenceIdentification nSequenceInfo, String nAlignmentName) {
        this.header = nHeader;
        this.sequenceInfo = nSequenceInfo;
        this.minSequenceLength = this.findMinSequenceLength();
        this.alignmentName = nAlignmentName;
    }

    public LinkedList<String> getHeader() {
        return this.header;
    }

    public Sequence getSequence(int index) {
        return this.sequenceInfo.getSequences().get(index);
    }

    private int findMinSequenceLength() {
        int minLength = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.getNumberOfSequences()) {
            if (this.sequenceInfo.getSequences().get(i).getActualLength() < minLength) {
                minLength = this.sequenceInfo.getSequences().get(i).getActualLength();
            }
            ++i;
        }
        return minLength;
    }

    public int getMinSequenceLength() {
        return this.minSequenceLength;
    }

    public int getNumberOfSequences() {
        return this.sequenceInfo.getSequences().size();
    }

    public void writeSequenceInformation(String filename) {
        String currentString = new String();
        if (filename != null) {
            try {
                FileWriter filewriter = new FileWriter(filename);
                filewriter.write(currentString);
                filewriter.close();
            }
            catch (IOException e) {
                System.out.println("Error while writing output file.");
            }
        }
    }

    public String getAlignmentName() {
        return this.alignmentName;
    }
}

