/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.data.calculations;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import jprofilegrid.data.calculations.AlignmentConstants;
import jprofilegrid.data.calculations.AminoAcidConstants;
import jprofilegrid.data.calculations.MultipleSequenceAlignment;
import jprofilegrid.data.profilegrid.UnknownSymbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleSequenceAnalysis {
    private Vector<Vector<Double>> correctedWindowSizes;
    private int[] motiffEndpointIndices;
    private int[] variableEndpointIndices;
    private int windowLength;
    private Vector<UnknownSymbol> unkSymbolInSeq;
    private String weightedString;

    private MultipleSequenceAnalysis(Vector<Vector<Double>> nUncorrectedWindowSizes, int nWindowLength, Vector<Vector<Double>> nCorrectedWindowSizes, int[] motiffEndpoints, int[] nVariableEndpointIndices, Vector<UnknownSymbol> nUnknownSymbolsInSequences, String nWeightedString) {
        this.windowLength = nWindowLength;
        this.correctedWindowSizes = nCorrectedWindowSizes;
        this.motiffEndpointIndices = motiffEndpoints;
        this.variableEndpointIndices = nVariableEndpointIndices;
        this.unkSymbolInSeq = nUnknownSymbolsInSequences;
        this.weightedString = nWeightedString;
    }

    public Vector<Vector<Double>> getWindowSizes() {
        return this.correctedWindowSizes;
    }

    public int getWindowLength() {
        return this.windowLength;
    }

    public Vector<Vector<Double>> getCorrected() {
        return this.correctedWindowSizes;
    }

    public int[] getMotiffEndpointIndices() {
        return this.motiffEndpointIndices;
    }

    public int[] getVariableEndpointIndices() {
        return this.variableEndpointIndices;
    }

    public static MultipleSequenceAnalysis analyze(MultipleSequenceAlignment alignment, int windowLength, double threshold, String weightedString, AlignmentConstants constants) {
        Vector<Double> columnValues = new Vector<Double>();
        Vector<Integer> gapsPerColumn = new Vector<Integer>();
        int minimumLength = alignment.getMinSequenceLength();
        int numberOfSpecies = alignment.getNumberOfSequences();
        Hashtable<String, UnknownSymbol> unknownSymbols = new Hashtable<String, UnknownSymbol>();
        int columnNumber = 0;
        while (columnNumber < minimumLength) {
            int gapsInCurrentColumn = 0;
            double columnSum = 0.0;
            int i = 0;
            while (i < numberOfSpecies) {
                String aa1 = alignment.getSequence(i).getAminoAcid(columnNumber);
                double aa1w = alignment.getSequence(i).getWeight();
                String currentSymbol = alignment.getSequence(i).getAminoAcid(columnNumber);
                if (!constants.isSymbolDefined(currentSymbol)) {
                    if (unknownSymbols.containsKey(currentSymbol)) {
                        ((UnknownSymbol)unknownSymbols.get(currentSymbol)).addUnknownSymbolSpeciesAndLocation(alignment.getSequence(i).getSpecies(), columnNumber + 1);
                    } else {
                        unknownSymbols.put(currentSymbol, new UnknownSymbol(currentSymbol, alignment.getSequence(i).getSpecies(), columnNumber + 1));
                    }
                }
                if (currentSymbol.equalsIgnoreCase(".") || currentSymbol.equalsIgnoreCase("*") || currentSymbol.equalsIgnoreCase("_") || currentSymbol.equalsIgnoreCase("-")) {
                    ++gapsInCurrentColumn;
                }
                int j = i + 1;
                while (j < numberOfSpecies) {
                    String aa2 = alignment.getSequence(j).getAminoAcid(columnNumber);
                    double aa2w = alignment.getSequence(j).getWeight();
                    columnSum += AminoAcidConstants.getMatrixValue(aa1, aa2) * aa2w;
                    columnSum += AminoAcidConstants.getMatrixValue(aa2, aa1) * aa1w;
                    ++j;
                }
                ++i;
            }
            gapsPerColumn.add(gapsInCurrentColumn);
            columnValues.add(columnSum);
            ++columnNumber;
        }
        Vector<Vector<Double>> ucWS = new Vector<Vector<Double>>();
        ucWS.add(null);
        int k = 1;
        while (k <= windowLength) {
            Vector<Double> uncorrectedSimilarities = new Vector<Double>();
            int leftColumn = -(k / 2);
            while (leftColumn < minimumLength - k / 2) {
                double plotcon = 0.0;
                if (leftColumn >= 0 && leftColumn + k <= minimumLength) {
                    int i = leftColumn;
                    while (i < leftColumn + k) {
                        plotcon += ((Double)columnValues.get(i)).doubleValue();
                        ++i;
                    }
                }
                double divisor = numberOfSpecies * k * (numberOfSpecies - 1) * k;
                double currentValue = plotcon / divisor;
                uncorrectedSimilarities.add(currentValue);
                ++leftColumn;
            }
            ucWS.add(uncorrectedSimilarities);
            ++k;
        }
        Vector<UnknownSymbol> allUnknownSymbols = new Vector<UnknownSymbol>();
        Iterator it = unknownSymbols.values().iterator();
        while (it.hasNext()) {
            allUnknownSymbols.add((UnknownSymbol)it.next());
        }
        return MultipleSequenceAnalysis.performCorrections(alignment, ucWS, gapsPerColumn, numberOfSpecies, windowLength, minimumLength, threshold, allUnknownSymbols, weightedString);
    }

    private static MultipleSequenceAnalysis performCorrections(MultipleSequenceAlignment alignment, Vector<Vector<Double>> ucWS, Vector<Integer> gapsPerColumn, int numberOfSpecies, int windowLength, int minimumLength, double threshold, Vector<UnknownSymbol> unknownSymbolsInSequences, String weightedString) {
        Vector<Vector<Double>> correctedWindowSizes = new Vector<Vector<Double>>();
        int i = 0;
        while (i < ucWS.size()) {
            correctedWindowSizes.add(new Vector());
            ++i;
        }
        int maximumOccuringAminoAcidInColumn = 0;
        int k = 1;
        while (k <= windowLength) {
            int i2 = 0;
            while (i2 < ucWS.get(k).size()) {
                correctedWindowSizes.get(k).add(ucWS.get(k).get(i2));
                ++i2;
            }
            double minValue = Double.MAX_VALUE;
            int i3 = 0;
            while (i3 < correctedWindowSizes.get(k).size()) {
                if (correctedWindowSizes.get(k).get(i3) < minValue) {
                    minValue = correctedWindowSizes.get(k).get(i3);
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < correctedWindowSizes.get(k).size()) {
                correctedWindowSizes.get(k).set(i3, correctedWindowSizes.get(k).get(i3) - minValue);
                ++i3;
            }
            i3 = 0;
            while (i3 < correctedWindowSizes.get(k).size()) {
                correctedWindowSizes.get(k).set(i3, correctedWindowSizes.get(k).get(i3) * (((double)numberOfSpecies - (double)gapsPerColumn.get(i3).intValue()) / (double)numberOfSpecies));
                ++i3;
            }
            double maxValue = Double.MIN_VALUE;
            int maxColumnIndex = 0;
            int i4 = 0;
            while (i4 < correctedWindowSizes.get(k).size()) {
                if (correctedWindowSizes.get(k).get(i4) > maxValue) {
                    maxValue = correctedWindowSizes.get(k).get(i4);
                    maxColumnIndex = i4;
                }
                ++i4;
            }
            Hashtable<String, Integer> aminoAcidLookupTable = new Hashtable<String, Integer>();
            Vector<Integer> aminoAcidCounts = new Vector<Integer>();
            Vector<String> aminoAcidNames = new Vector<String>();
            int i5 = 0;
            while (i5 < numberOfSpecies) {
                String currentAminoAcid = alignment.getSequence(i5).getAminoAcid(maxColumnIndex);
                if (!aminoAcidLookupTable.containsKey(currentAminoAcid)) {
                    aminoAcidLookupTable.put(currentAminoAcid, aminoAcidCounts.size());
                    aminoAcidCounts.add(1);
                    aminoAcidNames.add(currentAminoAcid);
                } else {
                    aminoAcidCounts.set((Integer)aminoAcidLookupTable.get(currentAminoAcid), (Integer)aminoAcidCounts.get((Integer)aminoAcidLookupTable.get(currentAminoAcid)) + 1);
                }
                ++i5;
            }
            int maximumOccurence = 0;
            int indexOfMaximalOccurence = 0;
            int i6 = 0;
            while (i6 < aminoAcidCounts.size()) {
                if ((Integer)aminoAcidCounts.get(i6) > maximumOccurence) {
                    maximumOccurence = (Integer)aminoAcidCounts.get(i6);
                    indexOfMaximalOccurence = i6;
                }
                ++i6;
            }
            maximumOccuringAminoAcidInColumn = (Integer)aminoAcidCounts.get(indexOfMaximalOccurence);
            double normalizationConstant = 1.0 / correctedWindowSizes.get(k).get(maxColumnIndex);
            int i7 = 0;
            while (i7 < correctedWindowSizes.get(k).size()) {
                correctedWindowSizes.get(k).set(i7, correctedWindowSizes.get(k).get(i7) * normalizationConstant);
                ++i7;
            }
            i7 = 0;
            while (i7 < correctedWindowSizes.get(k).size()) {
                correctedWindowSizes.get(k).set(i7, correctedWindowSizes.get(k).get(i7) * ((double)maximumOccuringAminoAcidInColumn / (double)numberOfSpecies));
                ++i7;
            }
            ++k;
        }
        return MultipleSequenceAnalysis.calculateMotiffEndpoints(ucWS, windowLength, correctedWindowSizes, threshold, unknownSymbolsInSequences, weightedString);
    }

    private static MultipleSequenceAnalysis calculateMotiffEndpoints(Vector<Vector<Double>> ucWS, int windowLength, Vector<Vector<Double>> cWS, double threshold, Vector<UnknownSymbol> unknownSymbolsInSequences, String weightedString) {
        Vector<Double> columnValuesInDefaultWindow = cWS.get(windowLength);
        Vector<Integer> motiffEndpoints = new Vector<Integer>();
        Vector<Integer> variableEndpoints = new Vector<Integer>();
        boolean leftEndpointSearch = true;
        int i = 0;
        while (i < columnValuesInDefaultWindow.size()) {
            if (leftEndpointSearch) {
                if (columnValuesInDefaultWindow.get(i) > threshold) {
                    motiffEndpoints.add(i);
                    leftEndpointSearch = false;
                }
            } else if (columnValuesInDefaultWindow.get(i) < threshold) {
                motiffEndpoints.add(i);
                leftEndpointSearch = true;
            }
            ++i;
        }
        if (motiffEndpoints.size() % 2 == 1) {
            motiffEndpoints.add(cWS.get(windowLength).size() - 1);
        }
        i = 0;
        while (i < motiffEndpoints.size()) {
            if (i == 0) {
                if ((Integer)motiffEndpoints.get(0) != 0) {
                    variableEndpoints.add(0);
                    variableEndpoints.add((Integer)motiffEndpoints.get(i) - 1);
                }
            } else if ((Integer)motiffEndpoints.get(i - 1) + 1 != (Integer)motiffEndpoints.get(i) && i % 2 == 0) {
                variableEndpoints.add((Integer)motiffEndpoints.get(i) - 1);
            } else if (i < motiffEndpoints.size() - 1) {
                if ((Integer)motiffEndpoints.get(i + 1) - 1 != (Integer)motiffEndpoints.get(i) && i % 2 == 1) {
                    variableEndpoints.add((Integer)motiffEndpoints.get(i) + 1);
                }
            } else if (i == motiffEndpoints.size() - 1 && (Integer)motiffEndpoints.get(i) != cWS.get(windowLength).size() - 1) {
                variableEndpoints.add((Integer)motiffEndpoints.get(i) + 1);
                variableEndpoints.add(cWS.get(windowLength).size() - 1);
            }
            ++i;
        }
        if (variableEndpoints.size() % 2 == 1) {
            variableEndpoints.add(cWS.get(windowLength).size() - 1);
        }
        int[] motiffEndpointsIntArray = new int[motiffEndpoints.size()];
        int i2 = 0;
        while (i2 < motiffEndpoints.size()) {
            motiffEndpointsIntArray[i2] = (Integer)motiffEndpoints.get(i2);
            ++i2;
        }
        int[] variableEndpointsIntArray = new int[variableEndpoints.size()];
        int i3 = 0;
        while (i3 < variableEndpoints.size()) {
            variableEndpointsIntArray[i3] = (Integer)variableEndpoints.get(i3);
            ++i3;
        }
        return new MultipleSequenceAnalysis(ucWS, windowLength, cWS, motiffEndpointsIntArray, variableEndpointsIntArray, unknownSymbolsInSequences, weightedString);
    }

    public Vector<UnknownSymbol> getUnknownSymbols() {
        return this.unkSymbolInSeq;
    }

    public String getWeightedString() {
        return this.weightedString;
    }
}

