/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.data.calculations;

public class Sequence {
    private String species;
    private String sequence;
    private int check;
    private int length;
    private double weight;

    public Sequence(String nSpecies, int nLength, int nCheck, double nWeight) {
        this.species = nSpecies;
        this.length = nLength;
        this.check = nCheck;
        this.weight = nWeight;
    }

    public Sequence(String nSpecies, String nSequence, int nLength, int nCheck, double nWeight) {
        this.species = nSpecies;
        this.length = nLength;
        this.check = nCheck;
        this.weight = nWeight;
        this.sequence = nSequence;
    }

    public String getSpecies() {
        return this.species;
    }

    public int getLength() {
        return this.length;
    }

    public int getCheck() {
        return this.check;
    }

    public double getWeight() {
        return this.weight;
    }

    public String getEntireSequence() {
        return this.sequence;
    }

    public String getAminoAcid(int index) {
        if (index < this.sequence.length()) {
            return this.sequence.substring(index, index + 1);
        }
        return null;
    }

    public String toString() {
        return new String("Name:\t" + this.species + "\tLength:\t" + this.length + "\tCheck:\t" + this.check + "\tWeight:\t" + this.weight);
    }

    public int getActualLength() {
        return this.sequence.length();
    }

    public void addToSequence(String nSequence) {
        this.sequence = this.sequence == null ? new String(nSequence) : String.valueOf(this.sequence) + nSequence;
    }

    public String getSequence() {
        return this.sequence;
    }
}

