/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.data.calculations;

import java.util.PriorityQueue;
import jprofilegrid.data.calculations.AlignmentConstants;
import jprofilegrid.data.calculations.AminoAcidConstants;
import jprofilegrid.data.calculations.Symbol;

public class SortedAminoAcidNamesAndSymbols {
    private String[] sortedAminoAcidNames;
    private String[] sortedAminoAcidSymbols;
    private String sortType;

    public SortedAminoAcidNamesAndSymbols(String[] nSortedAminoAcidNames, String[] nSortedAminoAcidSymbols, String nSortType) {
        this.sortedAminoAcidNames = nSortedAminoAcidNames;
        this.sortedAminoAcidSymbols = nSortedAminoAcidSymbols;
        this.sortType = nSortType;
    }

    public static SortedAminoAcidNamesAndSymbols sort(int nSortType, boolean ascending, AlignmentConstants constants) {
        String sortType = nSortType == 0 ? "Alpha-Code" : (nSortType == 1 ? "Alpha-Name" : AminoAcidConstants.CONSTANT_NAMES[nSortType - 2]);
        String[] sortedAminoAcidNames = new String[constants.getNames().length];
        String[] sortedAminoAcidSymbols = new String[constants.getSymbols().length];
        PriorityQueue<Symbol> sortedAAs = new PriorityQueue<Symbol>();
        int i = 0;
        while (i < constants.getNames().length - 1) {
            sortedAAs.add(new Symbol(constants.getNames()[i], constants.getSymbols()[i], constants.getConstantsForSymbol(i), nSortType, ascending));
            ++i;
        }
        i = 0;
        while (i < constants.getNames().length - 1) {
            Symbol currentAA = (Symbol)sortedAAs.poll();
            sortedAminoAcidNames[i] = currentAA.getName();
            sortedAminoAcidSymbols[i] = currentAA.getSymbol();
            ++i;
        }
        sortedAminoAcidNames[sortedAminoAcidNames.length - 1] = constants.getNames()[constants.getNames().length - 1];
        sortedAminoAcidSymbols[sortedAminoAcidSymbols.length - 1] = constants.getSymbols()[constants.getSymbols().length - 1];
        return new SortedAminoAcidNamesAndSymbols(sortedAminoAcidNames, sortedAminoAcidSymbols, sortType);
    }

    public String[] getSortedAminoAcidNames() {
        return this.sortedAminoAcidNames;
    }

    public String[] getSortedAminoAcidSymbols() {
        return this.sortedAminoAcidSymbols;
    }

    public String getSortType() {
        return this.sortType;
    }
}

