/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.data.calculations;

import jprofilegrid.data.GlobalData;
import jprofilegrid.data.calculations.AlignmentConstants;
import jprofilegrid.data.calculations.MultipleSequenceAlignment;
import jprofilegrid.data.calculations.MultipleSequenceAnalysis;
import jprofilegrid.data.calculations.Sequence;
import jprofilegrid.data.calculations.SortedAminoAcidNamesAndSymbols;

public class SortedData {
    private SortedAminoAcidNamesAndSymbols sortedAminoAcidNamesAndSymbols;
    public static int TOTAL_AA_PLUS_ONE = 21;
    private int[][] aminoAcidCounts;

    public SortedData(SortedAminoAcidNamesAndSymbols nSortedAminoAcidNamesAndSymbols, int[][] AACounts) {
        this.sortedAminoAcidNamesAndSymbols = nSortedAminoAcidNamesAndSymbols;
        this.aminoAcidCounts = AACounts;
    }

    public static int[] getAminoAcidCountsInColumn(SortedAminoAcidNamesAndSymbols sortedAminoAcidNamesAndSymbols, MultipleSequenceAlignment alignment, int columnIndex) {
        int numberOfAminoAcidNamesAndSymbols = sortedAminoAcidNamesAndSymbols.getSortedAminoAcidNames().length;
        int[] aminoAcidCounts = new int[numberOfAminoAcidNamesAndSymbols];
        int numberOfSequences = alignment.getNumberOfSequences();
        int i = 0;
        while (i < numberOfSequences) {
            Sequence currentSequence = alignment.getSequence(i);
            String currentAminoAcid = currentSequence.getAminoAcid(columnIndex);
            int j = 0;
            while (j < numberOfAminoAcidNamesAndSymbols) {
                if (currentAminoAcid.equalsIgnoreCase(sortedAminoAcidNamesAndSymbols.getSortedAminoAcidSymbols()[j])) {
                    int n = j;
                    aminoAcidCounts[n] = aminoAcidCounts[n] + 1;
                }
                ++j;
            }
            if (currentAminoAcid.equalsIgnoreCase(".") || currentAminoAcid.equalsIgnoreCase("-")) {
                int n = numberOfAminoAcidNamesAndSymbols - 1;
                aminoAcidCounts[n] = aminoAcidCounts[n] + 1;
            }
            ++i;
        }
        return aminoAcidCounts;
    }

    public static SortedData analyze(MultipleSequenceAlignment alignment, MultipleSequenceAnalysis msa, AlignmentConstants constants) {
        SortedAminoAcidNamesAndSymbols sortedAminoAcidNamesAndSymbols = SortedAminoAcidNamesAndSymbols.sort(GlobalData.analysisOptions.getSortType(), GlobalData.analysisOptions.getSortAscending(), constants);
        int seqLen = alignment.getMinSequenceLength();
        int[][] AACounts = new int[seqLen][TOTAL_AA_PLUS_ONE];
        int i = 0;
        while (i < seqLen) {
            AACounts[i] = SortedData.getAminoAcidCountsInColumn(sortedAminoAcidNamesAndSymbols, alignment, i);
            ++i;
        }
        return new SortedData(sortedAminoAcidNamesAndSymbols, AACounts);
    }

    public int[][] getAminoAcidCounts() {
        return this.aminoAcidCounts;
    }

    public String[] getSortedAminoAcidNames() {
        return this.sortedAminoAcidNamesAndSymbols.getSortedAminoAcidNames();
    }

    public String[] getSortedAminoAcidSymbols() {
        return this.sortedAminoAcidNamesAndSymbols.getSortedAminoAcidSymbols();
    }

    public String getSortType() {
        return this.sortedAminoAcidNamesAndSymbols.getSortType();
    }
}

