/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.data.profilegrid;

import java.util.Vector;
import jprofilegrid.data.calculations.AlignmentConstants;
import jprofilegrid.data.profilegrid.ConservationRange;
import jprofilegrid.data.profilegrid.Text;
import jprofilegrid.data.profilegrid.Tier;
import jprofilegrid.data.profilegrid.UnknownSymbol;
import jxl.format.Colour;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileGrid {
    private String[] sortedAminoAcidNames;
    private String[] sortedAminoAcidSymbols;
    private Tier entireAlignment;
    private int sequenceLength;
    private int numberOfAminoAcids;
    private int numberOfVariableRegions;
    private int numberOfMotifRegions;
    private int windowSize;
    private int numberOfSequences;
    private int integerOrPercentage;
    private Text comparisonSequenceName;
    private String sortType;
    private String weightedString;
    private Text highlightSequenceName;
    private int[] motifEndpointIndices;
    private int[] variableRegionEndpointIndices;
    private ConservationRange thresholdColoring;
    private Vector<Double> plotSimValues;
    private Vector<UnknownSymbol> unknownSymbols;
    private AlignmentConstants constants;

    public ProfileGrid(Tier nEntireAlignment, String[] nSortedAminoAcidNames, String[] nSortedAminoAcidSymbols, Text nComparisonSequenceName, String nSortType, Text nHighlightSequenceName, int[] nMotiffEndpointIndices, int[] nVariableRegionEndpointIndices, int[] numberOfMotiffAndVariableRegions, Vector<UnknownSymbol> nUnknownSymbols, ConservationRange nThresholdColoring, Vector<Double> nPlotSimValues, int nWindowSize, String nWeightedString, int nNumberOfSequences, AlignmentConstants nConstants) {
        this.entireAlignment = nEntireAlignment;
        this.sequenceLength = this.entireAlignment.getAminoAcidCounts().length;
        this.numberOfAminoAcids = this.entireAlignment.getAminoAcidCounts()[0].length;
        this.sortedAminoAcidNames = nSortedAminoAcidNames;
        this.sortedAminoAcidSymbols = nSortedAminoAcidSymbols;
        this.comparisonSequenceName = nComparisonSequenceName;
        this.sortType = nSortType;
        this.highlightSequenceName = nHighlightSequenceName;
        this.motifEndpointIndices = nMotiffEndpointIndices;
        this.variableRegionEndpointIndices = nVariableRegionEndpointIndices;
        if (numberOfMotiffAndVariableRegions != null) {
            this.numberOfMotifRegions = numberOfMotiffAndVariableRegions[0];
            this.numberOfVariableRegions = numberOfMotiffAndVariableRegions[1];
        } else {
            this.numberOfVariableRegions = 0;
            this.numberOfMotifRegions = 0;
        }
        this.unknownSymbols = nUnknownSymbols;
        this.thresholdColoring = nThresholdColoring;
        this.plotSimValues = nPlotSimValues;
        this.windowSize = nWindowSize;
        this.weightedString = nWeightedString;
        this.numberOfSequences = nNumberOfSequences;
        this.constants = nConstants;
    }

    public Tier getVariableRegion(int variableRegionNumber) {
        return this.entireAlignment.subTier(this.variableRegionEndpointIndices[2 * variableRegionNumber], this.variableRegionEndpointIndices[2 * variableRegionNumber + 1] + 1);
    }

    public Tier getMotifRegion(int motifRegionNumber) {
        return this.entireAlignment.subTier(this.motifEndpointIndices[2 * motifRegionNumber], this.motifEndpointIndices[2 * motifRegionNumber + 1] + 1);
    }

    public Tier getEntireAlignment() {
        return this.entireAlignment;
    }

    public Tier getTier(int startCol, int endCol) {
        return this.entireAlignment.subTier(startCol, endCol);
    }

    public int getSequenceLength() {
        return this.sequenceLength;
    }

    public int getNumberOfAminoAcids() {
        return this.numberOfAminoAcids;
    }

    public String[] getSortedAminoAcidNames() {
        return this.sortedAminoAcidNames;
    }

    public String[] getSortedAminoAcidSymbols() {
        return this.sortedAminoAcidSymbols;
    }

    public Text getTemplateSequenceName() {
        return this.comparisonSequenceName;
    }

    public String getSortType() {
        return this.sortType;
    }

    public Text getHighlightSequenceName() {
        return this.highlightSequenceName;
    }

    public int[] getMotifEndpointIndices() {
        return this.motifEndpointIndices;
    }

    public int getNumberOfMotifRegions() {
        return this.numberOfMotifRegions;
    }

    public int getNumberOfVariableRegions() {
        return this.numberOfVariableRegions;
    }

    public Vector<UnknownSymbol> getUnknownSymbolsInSequence() {
        return this.unknownSymbols;
    }

    public double getThreshold(int index) {
        return this.thresholdColoring.getThreshold(index);
    }

    public Colour getColour(int index) {
        return this.thresholdColoring.getColour(index);
    }

    public int getNumberOfThresholds() {
        return this.thresholdColoring.getNumberOfRanges();
    }

    public Vector<Double> getPlotSimValues() {
        return this.plotSimValues;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public String getWeightedString() {
        return this.weightedString;
    }

    public int getNumberOfSequences() {
        return this.numberOfSequences;
    }

    public int getIntegerOrPercetnage() {
        return this.integerOrPercentage;
    }

    public AlignmentConstants getAlignmentConstants() {
        return this.constants;
    }

    public Colour getHighlightSequenceColour() {
        return this.highlightSequenceName.getFormat().getBorderColor();
    }
}

