/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.data.profilegrid;

import jprofilegrid.data.calculations.AlignmentConstants;
import jprofilegrid.data.profilegrid.Format;
import jprofilegrid.data.profilegrid.Numeric;
import jprofilegrid.data.profilegrid.Text;

public class Tier {
    private Text[] majorAminoAcidRow;
    private Text[] templateSequenceRow;
    private Text[] positionInAlignmentRow;
    private Text[] motiffNumberingRow;
    private Text[] highlightSequenceRow;
    private Text[] highlightSequenceArray;
    private Numeric[][] aminoAcidCounts;
    private static Text totalCountsString = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "Counts");
    private static Text totalFrequenciesString = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "Freq.");
    private Numeric[] totalAminoAcidCounts;
    private Numeric[] totalAminoAcidFrequencies;
    private AlignmentConstants constants;
    private int[][] integerAminoAcidCounts;
    private int[] positionInAlignmentRowWithoutSkippingGaps;

    public Tier(Text[] nPositionInAlignmentRow, Text[] nMotiffNumberingRow, Text[] nMajorAminoAcidRow, Text[] nComparisonSequenceRow, Numeric[][] nAminoAcidCounts, AlignmentConstants nConstants, int[][] nIntegerAminoAcidCounts, int[] nPositonInAlignmentRowWithoutSkippingGaps, Text[] nHighlightSequenceArray) {
        this.positionInAlignmentRow = nPositionInAlignmentRow;
        this.motiffNumberingRow = nMotiffNumberingRow;
        this.majorAminoAcidRow = nMajorAminoAcidRow;
        this.templateSequenceRow = nComparisonSequenceRow;
        this.aminoAcidCounts = nAminoAcidCounts;
        this.constants = nConstants;
        this.calculateTierStatistics();
        this.integerAminoAcidCounts = nIntegerAminoAcidCounts;
        this.positionInAlignmentRowWithoutSkippingGaps = nPositonInAlignmentRowWithoutSkippingGaps;
        this.highlightSequenceArray = nHighlightSequenceArray;
    }

    public int[][] getIntegerAminoAcidCounts() {
        return this.integerAminoAcidCounts;
    }

    public int[] getPositonInAlignmentRowWithoutSkippingGaps() {
        return this.positionInAlignmentRowWithoutSkippingGaps;
    }

    private void calculateTierStatistics() {
        this.totalAminoAcidCounts = new Numeric[this.constants.getSymbols().length];
        this.totalAminoAcidFrequencies = new Numeric[this.constants.getSymbols().length];
        int i = 0;
        while (i < this.constants.getSymbols().length) {
            this.totalAminoAcidCounts[i] = new Numeric(new Format(Format.RIGHT_ALIGNED, Format.NOT_BOLD), 0.0);
            this.totalAminoAcidFrequencies[i] = new Numeric(new Format(Format.RIGHT_ALIGNED, Format.NOT_BOLD), 0.0);
            ++i;
        }
        int totalCounts = 0;
        int i2 = 0;
        while (i2 < this.aminoAcidCounts.length) {
            int j = 0;
            while (j < this.aminoAcidCounts[i2].length) {
                this.totalAminoAcidCounts[j].setValue(this.totalAminoAcidCounts[j].getValue() + this.aminoAcidCounts[i2][j].getValue());
                totalCounts = (int)((double)totalCounts + this.aminoAcidCounts[i2][j].getValue());
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.totalAminoAcidFrequencies.length) {
            this.totalAminoAcidFrequencies[i2].setValue(this.totalAminoAcidCounts[i2].getValue() / (double)totalCounts);
            ++i2;
        }
    }

    public void setHighlightSequenceRow(Text[] nHighlightSequenceRow) {
        this.highlightSequenceRow = nHighlightSequenceRow;
    }

    public Numeric[] getTotalAminoAcidCounts() {
        return this.totalAminoAcidCounts;
    }

    public Numeric[] getTotalAminoAcidFrequencies() {
        return this.totalAminoAcidFrequencies;
    }

    public Text[] getMajorAminoAcidRow() {
        return this.majorAminoAcidRow;
    }

    public Text[] getTemplateSequenceRow() {
        return this.templateSequenceRow;
    }

    public Text[] getPositionInAlignmentRow() {
        return this.positionInAlignmentRow;
    }

    public Text[] getMorphNumberingRow() {
        return this.motiffNumberingRow;
    }

    public Text[] getHighlightSequenceRow() {
        return this.highlightSequenceRow;
    }

    public Text[] getHighlightSequenceArray() {
        return this.highlightSequenceArray;
    }

    public Numeric[][] getAminoAcidCounts() {
        return this.aminoAcidCounts;
    }

    public Text getTotalCountsString() {
        return totalCountsString;
    }

    public Text getTotalFequenciesString() {
        return totalFrequenciesString;
    }

    public Tier subTier(int startCol, int endCol) {
        int lengthOfTier = endCol - startCol;
        Text[] nMajorAminoAcidRow = new Text[lengthOfTier];
        Text[] nComparisonSequenceRow = new Text[lengthOfTier];
        Text[] nPositionInAlignmentRow = new Text[lengthOfTier];
        Text[] nMotiffNumberingRow = new Text[lengthOfTier];
        Text[] nHighlightSequenceRow = new Text[lengthOfTier];
        Text[] nHighlightSequenceArray = new Text[lengthOfTier];
        Numeric[][] nAminoAcidCounts = new Numeric[lengthOfTier][this.aminoAcidCounts.length];
        int[][] nIntegerAminoAcidCounts = new int[lengthOfTier][this.aminoAcidCounts.length];
        int[] nPositionInAlignmentRowWithoutSkippingGaps = new int[lengthOfTier];
        int i = startCol;
        while (i < endCol) {
            nMajorAminoAcidRow[i - startCol] = this.majorAminoAcidRow[i];
            nComparisonSequenceRow[i - startCol] = this.templateSequenceRow[i];
            nPositionInAlignmentRow[i - startCol] = this.positionInAlignmentRow[i];
            nMotiffNumberingRow[i - startCol] = this.motiffNumberingRow[i];
            nAminoAcidCounts[i - startCol] = this.aminoAcidCounts[i];
            nIntegerAminoAcidCounts[i - startCol] = this.integerAminoAcidCounts[i];
            nHighlightSequenceRow[i - startCol] = this.highlightSequenceRow[i];
            nPositionInAlignmentRowWithoutSkippingGaps[i - startCol] = this.positionInAlignmentRowWithoutSkippingGaps[i];
            nHighlightSequenceArray[i - startCol] = this.highlightSequenceArray[i];
            ++i;
        }
        Tier nTier = new Tier(nPositionInAlignmentRow, nMotiffNumberingRow, nMajorAminoAcidRow, nComparisonSequenceRow, nAminoAcidCounts, this.constants, nIntegerAminoAcidCounts, nPositionInAlignmentRowWithoutSkippingGaps, nHighlightSequenceArray);
        nTier.setHighlightSequenceRow(nHighlightSequenceRow);
        return nTier;
    }
}

