/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.file.readers;

import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineParser {
    private static String[] COMMAND_LINE_OPTIONS = new String[]{"w", "t", "c", "h", "s", "a", "p", "ps", "g", "d", "v"};
    private double[] COMMAND_LINE_OPTION_VALUES = new double[COMMAND_LINE_OPTIONS.length];
    private String dataFile;

    public CommandLineParser(String[] arguments) {
        if (arguments.length > 0) {
            if (arguments[0].contains("-") && arguments[0].contains("help")) {
                CommandLineParser.printDetailedUsageMessage();
            }
            this.dataFile = arguments[0];
            Vector<String> options = new Vector<String>();
            Vector<String> parameters = new Vector<String>();
            boolean option = true;
            int i = 1;
            while (i < arguments.length) {
                if (option) {
                    if (!arguments[i].substring(0, 1).equals("-") && arguments[i].length() > 1) {
                        CommandLineParser.printUsageMessage();
                    } else if (arguments[i].substring(1, arguments[i].length()).equalsIgnoreCase("help")) {
                        CommandLineParser.printDetailedUsageMessage();
                    } else {
                        options.add(arguments[i].substring(1, arguments[i].length()));
                    }
                    if (options.get(options.size() - 1).equalsIgnoreCase("a")) {
                        parameters.insertElementAt("1", options.size() - 1);
                    } else if (options.get(options.size() - 1).equalsIgnoreCase("g")) {
                        parameters.insertElementAt("1", options.size() - 1);
                    } else {
                        option = false;
                    }
                } else {
                    parameters.add(arguments[i]);
                    option = true;
                }
                ++i;
            }
            this.sort(options, parameters);
        } else {
            CommandLineParser.printUsageMessage();
        }
    }

    private void sort(Vector<String> options, Vector<String> parameters) {
        int i = 0;
        while (i < options.size()) {
            boolean optionIdentified = false;
            int j = 0;
            while (j < COMMAND_LINE_OPTIONS.length) {
                if (options.get(i).equalsIgnoreCase(COMMAND_LINE_OPTIONS[j])) {
                    optionIdentified = true;
                    try {
                        this.COMMAND_LINE_OPTION_VALUES[j] = Double.parseDouble(parameters.get(i));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Parameter " + parameters.get(j) + " is not an integer.");
                        CommandLineParser.printUsageMessage();
                    }
                }
                ++j;
            }
            if (!optionIdentified) {
                CommandLineParser.printUnidentifiedOptionMessage(options.get(i));
            }
            ++i;
        }
    }

    private static void printUnidentifiedOptionMessage(String option) {
        System.out.println("Unknown option: " + option);
        CommandLineParser.printUsageMessage();
    }

    private static void printUsageMessage() {
        CommandLineParser.printStandardUsageOutput();
        System.exit(0);
    }

    private static void printDetailedUsageMessage() {
        CommandLineParser.printStandardUsageOutput();
        CommandLineParser.printExtendedUsageOutput();
        System.exit(0);
    }

    private static void printStandardUsageOutput() {
        System.out.println("\nJProfileGrid v1.2.2, August 19th, 2009");
        System.out.println("http://www.profilegrid.org");
        System.out.println("Cite publication: Alberto I Roca, Albert E Almada, Aaron C Abajian\nProfileGrids as a new visual representation of large multiple sequence\nalignments: a case study of the RecA protein family\nBMC Bioinformatics 9: 554 (2008)\n(c) 2007 The Regents of the University of California. All Rights Reserved.\nSee documentation for full license.\n");
        System.out.println("Graphical Frontend: java -jar jprofileGrid.jar");
        System.out.println("Console: java -jar jprofilegrid.jar MSAFile [-w windowSize] [-c ColumnsPerTier] [-t Threshold] [-h HighlightSequence] [-s SortType] [-a ---AscendingSort---] [-p TemplateSequence] [-d ProteinOrDNA] [-v ShowValues][-g ---SkipPositionGaps---]");
    }

    private static void printExtendedUsageOutput() {
        System.out.println("\nSortType Options:");
        System.out.println("0: Alphabetical-Code (Default)");
        System.out.println("1: Alphabetical-Name");
        System.out.println("2: Age");
        System.out.println("3: Flexibility");
        System.out.println("4: Frequency-EcoliK12");
        System.out.println("5: Hydropathy");
        System.out.println("6: Hydrophobicity");
        System.out.println("7: Helix-Propensity");
        System.out.println("8: Mutability-Dayhoff");
        System.out.println("9: Mutability-Grantham");
        System.out.println("10: Surface-Area");
        System.out.println("11: Volume");
        System.out.println("\nProteinOrDNA Options: 0: Protein, 1: DNA");
        System.out.println("\nShowValues Options: 0: Integer, 1: Frequency, 2: None");
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public double getWindowSize() {
        return this.COMMAND_LINE_OPTION_VALUES[0];
    }

    public double getThreshold() {
        return this.COMMAND_LINE_OPTION_VALUES[1];
    }

    public double getColumnsPerTier() {
        return this.COMMAND_LINE_OPTION_VALUES[2];
    }

    public double getHighlightSequence() {
        return this.COMMAND_LINE_OPTION_VALUES[3];
    }

    public double getSortType() {
        return this.COMMAND_LINE_OPTION_VALUES[4];
    }

    public double getAscending() {
        return this.COMMAND_LINE_OPTION_VALUES[5];
    }

    public double getTemplateSequence() {
        return this.COMMAND_LINE_OPTION_VALUES[6];
    }

    public double getPositionRowStart() {
        return this.COMMAND_LINE_OPTION_VALUES[7];
    }

    public double getSkipPositionGaps() {
        return this.COMMAND_LINE_OPTION_VALUES[8];
    }

    public double getAlignmentType() {
        return this.COMMAND_LINE_OPTION_VALUES[9];
    }

    public double getShowValuesAs() {
        return this.COMMAND_LINE_OPTION_VALUES[10];
    }
}

