/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.file.readers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import jprofilegrid.data.calculations.MultipleSequenceAlignment;
import jprofilegrid.data.calculations.Sequence;
import jprofilegrid.data.calculations.SequenceIdentification;

public class FASTAFileReader {
    public static MultipleSequenceAlignment readAlignedFasta(File filename) {
        Hashtable<String, Integer> sequenceIndicesByName = new Hashtable<String, Integer>();
        Vector<Sequence> sequences = new Vector<Sequence>();
        try {
            char charValue;
            int i;
            String actualName;
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            String currentName = "";
            String currentSequence = "";
            String currentLine = reader.readLine();
            while (currentLine != null && !currentLine.contains(">")) {
                currentLine = reader.readLine();
            }
            while (currentLine != null) {
                if (currentLine.contains(">")) {
                    if (!currentSequence.equalsIgnoreCase("")) {
                        actualName = "";
                        i = 0;
                        while (i < currentName.length()) {
                            charValue = currentName.charAt(i);
                            if (charValue >= '0' && charValue <= '9' || charValue >= 'A' && charValue <= 'Z' || charValue >= 'a' && charValue <= 'z' || charValue == '_') {
                                actualName = String.valueOf(actualName) + currentName.substring(i, i + 1);
                            } else {
                                i = currentName.length();
                            }
                            ++i;
                        }
                        sequences.add(new Sequence(actualName, currentSequence, currentSequence.length(), 0, 1.0));
                        sequenceIndicesByName.put(actualName, sequences.size() - 1);
                    }
                    currentName = currentLine.replaceFirst(">", "");
                    currentSequence = "";
                } else {
                    currentSequence = String.valueOf(currentSequence) + currentLine;
                }
                currentLine = reader.readLine();
            }
            actualName = "";
            i = 0;
            while (i < currentName.length()) {
                charValue = currentName.charAt(i);
                if (charValue >= '0' && charValue <= '9' || charValue >= 'A' && charValue <= 'Z' || charValue >= 'a' && charValue <= 'z' || charValue == '_') {
                    actualName = String.valueOf(actualName) + currentName.substring(i, i + 1);
                } else {
                    i = currentName.length();
                }
                ++i;
            }
            sequences.add(new Sequence(actualName, currentSequence, currentSequence.length(), 0, 1.0));
            sequenceIndicesByName.put(actualName, sequences.size() - 1);
            SequenceIdentification sequenceInfo = new SequenceIdentification(sequenceIndicesByName, sequences);
            return new MultipleSequenceAlignment(null, sequenceInfo, filename.getName());
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

