/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.file.readers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import jprofilegrid.data.calculations.MultipleSequenceAlignment;
import jprofilegrid.data.calculations.Sequence;
import jprofilegrid.data.calculations.SequenceIdentification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSFFileReader {
    public static MultipleSequenceAlignment readInMultipleSequenceAlignment(File inputFile) {
        try {
            LinkedList<String> allData = new LinkedList<String>();
            FileReader filereader = new FileReader(inputFile);
            BufferedReader bufferedReader = new BufferedReader(filereader);
            String currentLine = bufferedReader.readLine();
            boolean finishedHeaderSection = false;
            boolean finishedNamesSection = false;
            while (currentLine != null) {
                if (!currentLine.contains("#")) {
                    // empty if block
                }
                if (currentLine.contains("//")) {
                    finishedNamesSection = true;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(currentLine);
                String previousString = "";
                String currentString = "";
                while (stringTokenizer.hasMoreTokens()) {
                    currentString = stringTokenizer.nextToken();
                    if (!finishedHeaderSection) {
                        allData.add(currentString);
                    } else if (!finishedNamesSection) {
                        if (currentString.compareTo("Name:") != 0 && currentString.compareTo("Len:") != 0 && currentString.compareTo("Check:") != 0 && currentString.compareTo("Weight:") != 0 && (previousString.compareTo("Name:") == 0 || previousString.compareTo("Len:") == 0 || previousString.compareTo("Check:") == 0 || previousString.compareTo("Weight:") == 0)) {
                            allData.add(currentString);
                        }
                    } else {
                        allData.add(currentString);
                    }
                    previousString = currentString;
                }
                if (currentLine.contains("MSF:")) {
                    finishedHeaderSection = true;
                }
                currentLine = bufferedReader.readLine();
            }
            return new MultipleSequenceAlignment(MSFFileReader.computeHeaderInformation(allData), MSFFileReader.computeSequenceInformation(allData), inputFile.getName());
        }
        catch (FileNotFoundException e) {
            System.out.println("Cannot find file: " + inputFile);
        }
        catch (IOException e) {
            System.out.println("An I/O error occurred.");
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
        return null;
    }

    private static LinkedList<String> computeHeaderInformation(LinkedList<String> allData) {
        LinkedList<String> header = new LinkedList<String>();
        boolean done = false;
        int i = 0;
        while (i < allData.size() && !done) {
            String currentString = allData.remove(0);
            if (currentString.compareTo("..") != 0) {
                header.add(currentString);
            } else {
                done = true;
            }
            ++i;
        }
        return header;
    }

    private static SequenceIdentification computeSequenceInformation(LinkedList<String> allData) {
        Hashtable<String, Integer> sequenceIndices = new Hashtable<String, Integer>();
        Vector<Sequence> sequences = new Vector<Sequence>();
        boolean identifedAllSpecies = false;
        int speciesCounter = 0;
        while (!identifedAllSpecies) {
            String currentString = allData.remove(0);
            if (currentString.compareTo("//") != 0) {
                String species = currentString;
                int length = Integer.parseInt(allData.remove(0));
                int check = Integer.parseInt(allData.remove(0));
                double weight = Double.parseDouble(allData.remove(0));
                sequences.add(new Sequence(species, length, check, weight));
                sequenceIndices.put(species, speciesCounter);
                ++speciesCounter;
                continue;
            }
            identifedAllSpecies = true;
        }
        Sequence currentSequence = null;
        while (allData.size() != 0) {
            String currentEntry = allData.remove(0);
            if (sequenceIndices.containsKey(currentEntry)) {
                currentSequence = sequences.get((Integer)sequenceIndices.get(currentEntry));
                continue;
            }
            try {
                Integer.parseInt(currentEntry);
            }
            catch (NumberFormatException e) {
                currentSequence.addToSequence(currentEntry);
            }
        }
        boolean error = false;
        int i = 0;
        while (i < sequences.size()) {
            if (((Sequence)sequences.get(i)).getSequence() == null) {
                error = true;
                System.out.println("Species " + sequences.get(i).getSpecies() + " listed in header does not have an associated sequence.");
            }
            ++i;
        }
        if (error) {
            System.out.println("Error in alignment file, exiting.");
            System.exit(0);
        }
        return new SequenceIdentification(sequenceIndices, sequences);
    }
}

