/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.file.writers.excel;

import jprofilegrid.file.writers.excel.ExcelNumericCell;
import jprofilegrid.file.writers.excel.ExcelTextCell;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Pattern;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class ExcelDataBlockWriter {
    private WritableSheet sheet;

    public ExcelDataBlockWriter(WritableSheet nSheet) {
        this.sheet = nSheet;
    }

    public void writeString(ExcelTextCell textCell, int col, int row) {
        this.addTextCell(col, row, textCell);
    }

    public void writeDouble(ExcelNumericCell numericCell, int col, int row) {
        this.addNumericCell(col, row, numericCell);
    }

    public void writeRow(ExcelTextCell[] textCells, int startCol, int startRow) {
        int i = 0;
        int col = startCol;
        while (i < textCells.length) {
            this.addTextCell(col, startRow, textCells[i]);
            ++i;
            ++col;
        }
    }

    public void writeRow(ExcelNumericCell[] numericCells, int startCol, int startRow) {
        int i = 0;
        int col = startCol;
        while (i < numericCells.length) {
            this.addNumericCell(col, startRow, numericCells[i]);
            ++i;
            ++col;
        }
    }

    public void writeCol(ExcelTextCell[] textCells, int startCol, int startRow) {
        int i = 0;
        int row = startRow;
        while (i < textCells.length) {
            this.addTextCell(startCol, row, textCells[i]);
            ++i;
            ++row;
        }
    }

    public void writeCol(ExcelNumericCell[] numericCells, int startCol, int startRow) {
        int i = 0;
        int row = startRow;
        while (i < numericCells.length) {
            this.addNumericCell(startCol, row, numericCells[i]);
            ++i;
            ++row;
        }
    }

    public void writeBlock(ExcelTextCell[][] textCells, int startCol, int startRow) {
        int i = 0;
        int col = startCol;
        while (i < textCells.length) {
            this.writeCol(textCells[i], col, startRow);
            ++i;
            ++col;
        }
    }

    public void writeBlock(ExcelNumericCell[][] numericCells, int startCol, int startRow) {
        int i = 0;
        int col = startCol;
        while (i < numericCells.length) {
            this.writeCol(numericCells[i], col, startRow);
            ++i;
            ++col;
        }
    }

    private void addTextCell(int col, int row, ExcelTextCell textCell) {
        try {
            this.sheet.addCell(new Number(col, row, Double.parseDouble(textCell.getValue()), (CellFormat)textCell.getFormat()));
        }
        catch (NumberFormatException e) {
            this.addTextCellWithoutParsingNumber(col, row, textCell);
        }
        catch (RowsExceededException rowsExceededException) {
        }
        catch (WriteException writeException) {
            // empty catch block
        }
    }

    private void addTextCellWithoutParsingNumber(int col, int row, ExcelTextCell textCell) {
        try {
            WritableCellFormat format = textCell.getFormat();
            if (format.getBackgroundColour().getValue() == Colour.WHITE.getValue()) {
                format = this.extractAllFormattingExceptBackground(format);
            }
            if (format.getBackgroundColour().getValue() == Colour.WHITE.getValue()) {
                format.setBackground(Colour.WHITE);
            }
            this.sheet.addCell(new Label(col, row, textCell.getValue(), (CellFormat)format));
        }
        catch (RowsExceededException rowsExceededException) {
        }
        catch (WriteException writeException) {
            // empty catch block
        }
    }

    private void addNumericCell(int col, int row, ExcelNumericCell numericCell) {
        try {
            WritableCellFormat format = numericCell.getFormat();
            if (format.getBackgroundColour() == Colour.BLACK) {
                format.setBackground(Colour.AUTOMATIC);
            }
            if (format.getBackgroundColour().getValue() == Colour.WHITE.getValue()) {
                format = this.extractAllFormattingExceptBackground(format);
            }
            if (numericCell.getValue() != 0.0) {
                this.sheet.addCell(new Number(col, row, numericCell.getValue(), (CellFormat)format));
            } else {
                this.sheet.addCell(new Label(col, row, "", (CellFormat)format));
            }
        }
        catch (RowsExceededException rowsExceededException) {
        }
        catch (WriteException writeException) {
            // empty catch block
        }
    }

    private WritableCellFormat extractAllFormattingExceptBackground(WritableCellFormat oldFormat) {
        try {
            oldFormat.setBackground(Colour.WHITE, Pattern.NONE);
            return oldFormat;
        }
        catch (WriteException writeException) {
            return null;
        }
    }
}

