/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.file.writers.excel;

import java.io.IOException;
import java.text.DecimalFormat;
import jprofilegrid.data.calculations.AminoAcidConstants;
import jprofilegrid.data.profilegrid.ProfileGrid;
import jprofilegrid.data.profilegrid.Tier;
import jprofilegrid.file.writers.excel.DefaultFonts;
import jprofilegrid.file.writers.excel.ExcelDataBlockWriter;
import jprofilegrid.file.writers.excel.ExcelNumericCell;
import jprofilegrid.file.writers.excel.ExcelTextCell;
import jprofilegrid.file.writers.excel.ProfileGridCellToExcelCellConverter;
import jprofilegrid.file.writers.excel.ProfileGridFormatToExcelFormatConverter;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class ExcelFileWriter {
    private WritableWorkbook workbook;
    private ProfileGrid profileGrid;
    private WritableSheet currentSheet;
    private ExcelTextCell[] aminoAcidConstantsNames;
    private ExcelNumericCell[][] aminoAcidConstants;
    private ExcelTextCell[] aminoAcidSymbols;
    private ExcelTextCell[] aminoAcidNames;
    private ExcelTextCell comparisonSequenceRowName;
    private ExcelTextCell highlightSequenceRowName;
    private ExcelDataBlockWriter dataWriter;
    private Tier tier;
    private int startCol;
    private int startRow;
    private static int AMINO_ACID_DATA_ROW_OFFSET = 4;
    private static int AMINO_ACID_DATA_COLUMN_OFFSET = 2;
    private static int AMINO_ACID_NAMES_COLUMN_OFFSET = 0;
    private static int AMINO_ACID_SYMBOLS_COLUMN_OFFSET = 1;
    private static ExcelTextCell POSITION_IN_ALIGNMENT = new ExcelTextCell(DefaultFonts.getBoldAndRightAligned(), "Posn");
    private static int POSITION_IN_ALIGNMENT_ROW_OFFSET = 0;
    private static int POSITION_IN_ALIGNMENT_COLUMN_OFFSET = 1;
    private static ExcelTextCell MAJOR_ROW = new ExcelTextCell(DefaultFonts.getBoldAndRightAligned(), "Major");
    private static int MAJOR_ROW_OFFSET = 1;
    private static int MAJOR_COLUMN_OFFSET = 1;
    private static int COMPARISON_SEQUENCE_ROW_OFFSET = 2;
    private static int COMPARISON_SEQUENCE_COLUMN_OFFSET = 1;
    private static int HIGHLIGHT_SEQUENCE_ROW_OFFSET = 3;
    private static int HIGHLIGHT_SEQUENCE_COLUMN_OFFSET = 1;
    private static int ROWS_PER_TIER = 28;
    private static DecimalFormat formatter = new DecimalFormat();

    static {
        formatter.setMaximumFractionDigits(2);
        formatter.setMinimumFractionDigits(2);
        formatter.setMaximumIntegerDigits(1);
        formatter.setMinimumIntegerDigits(1);
    }

    public ExcelFileWriter(WritableWorkbook nWorkbook, ProfileGrid nProfileGrid) {
        this.workbook = nWorkbook;
        this.profileGrid = nProfileGrid;
        this.setAminoAcidSymbols();
        this.setAminoAcidNames();
        this.setAminoAcidConstants();
        this.comparisonSequenceRowName = new ExcelTextCell(DefaultFonts.getBoldAndCentered(), this.profileGrid.getTemplateSequenceName().getValue());
        WritableCellFormat highlightSequenceRowFormat = ProfileGridFormatToExcelFormatConverter.extractWritableCellFormat(this.profileGrid.getHighlightSequenceName());
        this.highlightSequenceRowName = new ExcelTextCell(highlightSequenceRowFormat, this.profileGrid.getHighlightSequenceName().getValue());
    }

    public void writeExcelFile(int columnsPerTier, int firstColumn, int lastColumn) {
        this.writePortionOfProfileGridInCurrentSheet(columnsPerTier, firstColumn, lastColumn);
        this.writeColorLegend();
        if (this.profileGrid.getUnknownSymbolsInSequence() != null) {
            this.writeUnknownAminoAcidSheet();
            this.writePlotSimSheet();
        }
        this.writeWorkbook();
        this.closeWorkbook();
    }

    private void writePortionOfProfileGridInCurrentSheet(int columnsPerTier, int firstColumn, int lastColumn) {
        this.createSheet(String.valueOf(this.profileGrid.getSortType()) + "-" + this.profileGrid.getHighlightSequenceName());
        int numberOfColumns = (int)Math.ceil((lastColumn - firstColumn + 1) / columnsPerTier);
        int i = 0;
        while (i < numberOfColumns) {
            this.tier = this.profileGrid.getTier(firstColumn + columnsPerTier * i, firstColumn + columnsPerTier * i + columnsPerTier);
            this.startCol = 0;
            this.startRow = ROWS_PER_TIER * i;
            this.writeTier();
            ++i;
        }
        this.tier = this.profileGrid.getTier(firstColumn + columnsPerTier * numberOfColumns, lastColumn + 1);
        this.startCol = 0;
        this.startRow = ROWS_PER_TIER * numberOfColumns;
        this.writeTier();
        this.startCol = 0;
        this.startRow = ROWS_PER_TIER * (numberOfColumns + 1);
    }

    private void writeUnknownAminoAcidSheet() {
        this.createSheet("Flags");
        this.startCol = 0;
        this.startRow = 0;
        this.writeUnknownAAs();
    }

    private void writePlotSimSheet() {
        this.createSheet("PlotSim_WS_" + this.profileGrid.getWindowSize() + "_" + this.profileGrid.getWeightedString());
        this.startCol = 0;
        this.startRow = 0;
        ExcelTextCell[] currentRow = new ExcelTextCell[2];
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(3);
        decimalFormat.setMinimumFractionDigits(3);
        int i = 0;
        while (i < this.profileGrid.getPlotSimValues().size()) {
            currentRow[0] = new ExcelTextCell(DefaultFonts.getDefaultFormat(), String.valueOf(i + 1));
            currentRow[1] = new ExcelTextCell(DefaultFonts.getDefaultFormat(), String.valueOf(Double.parseDouble(decimalFormat.format(this.profileGrid.getPlotSimValues().get(i)))));
            this.dataWriter.writeRow(currentRow, this.startCol, this.startRow + i);
            ++i;
        }
    }

    private void writeUnknownAAs() {
        int i = 0;
        int row = this.startRow;
        while (i < this.profileGrid.getUnknownSymbolsInSequence().size()) {
            int j = 0;
            while (j < this.profileGrid.getUnknownSymbolsInSequence().get(i).getNumberOfSpecies()) {
                int col = this.startCol + 2;
                this.dataWriter.writeString(new ExcelTextCell(DefaultFonts.getDefaultFormat(), this.profileGrid.getUnknownSymbolsInSequence().get(i).getSymbol()), 0, row);
                this.dataWriter.writeString(new ExcelTextCell(DefaultFonts.getDefaultFormat(), this.profileGrid.getUnknownSymbolsInSequence().get(i).getUnknownSymbolSpeciesAndLocation(j).getSpecies()), 1, row);
                int k = 0;
                while (k < this.profileGrid.getUnknownSymbolsInSequence().get(i).getUnknownSymbolSpeciesAndLocation(j).getNumberOfLocations()) {
                    this.dataWriter.writeDouble(new ExcelNumericCell(DefaultFonts.getDefaultFormat(), this.profileGrid.getUnknownSymbolsInSequence().get(i).getUnknownSymbolSpeciesAndLocation(j).getLocation(k)), col, row);
                    ++col;
                    ++k;
                }
                ++row;
                ++j;
            }
            ++i;
        }
    }

    private void writeTier() {
        this.writePositionRow();
        this.writeMajorRow();
        this.writeComparisonSequenceRow();
        this.writeHighlightSequenceRow();
        this.writeAminoAcidNamesAndSymbols();
        this.writeAminoAcidCounts();
    }

    private void writeColorLegend() {
        ExcelTextCell THRESHOLD = new ExcelTextCell(DefaultFonts.getBoldAndCentered(), "Threshold");
        ExcelTextCell THRESHOLD_COLOR = new ExcelTextCell(DefaultFonts.getBoldAndCentered(), "Color");
        ExcelTextCell SEQUENCES = new ExcelTextCell(DefaultFonts.getBoldAndCentered(), "Sequences:");
        this.dataWriter.writeString(THRESHOLD, this.startCol, this.startRow);
        this.dataWriter.writeString(THRESHOLD_COLOR, this.startCol + 1, this.startRow);
        int i = 0;
        while (i < this.profileGrid.getNumberOfThresholds()) {
            this.dataWriter.writeString(new ExcelTextCell(DefaultFonts.getDefaultFormatAndCentered(), String.valueOf(this.profileGrid.getThreshold(i))), this.startCol, this.startRow + 1 + i);
            if (this.profileGrid.getColour(i) != Colour.WHITE) {
                Colour colour = this.profileGrid.getColour(i) == Colour.BLACK ? Colour.AUTOMATIC : this.profileGrid.getColour(i);
                this.dataWriter.writeString(new ExcelTextCell(DefaultFonts.getDefaultFormatWithBackgroundColourAndCentered(colour), ExcelFileWriter.toTitleCase(this.profileGrid.getColour(i).getDescription())), this.startCol + 1, this.startRow + 1 + i);
            } else {
                this.dataWriter.writeString(new ExcelTextCell(DefaultFonts.getDefaultFormatAndCentered(), ExcelFileWriter.toTitleCase(this.profileGrid.getColour(i).getDescription())), this.startCol + 1, this.startRow + 1 + i);
            }
            ++i;
        }
        this.dataWriter.writeString(SEQUENCES, this.startCol, this.startRow + 1 + this.profileGrid.getNumberOfThresholds());
        this.dataWriter.writeDouble(new ExcelNumericCell(DefaultFonts.getDefaultFormatAndCentered(), this.profileGrid.getNumberOfSequences()), this.startCol + 1, this.startRow + 1 + this.profileGrid.getNumberOfThresholds());
    }

    private void writePositionRow() {
        this.dataWriter.writeString(POSITION_IN_ALIGNMENT, this.startCol + POSITION_IN_ALIGNMENT_COLUMN_OFFSET, this.startRow + POSITION_IN_ALIGNMENT_ROW_OFFSET);
        this.dataWriter.writeRow(ProfileGridCellToExcelCellConverter.getTextCells(this.tier.getPositionInAlignmentRow()), this.startCol + POSITION_IN_ALIGNMENT_COLUMN_OFFSET + 1, this.startRow + POSITION_IN_ALIGNMENT_ROW_OFFSET);
    }

    private void writeMajorRow() {
        this.dataWriter.writeString(MAJOR_ROW, this.startCol + MAJOR_COLUMN_OFFSET, this.startRow + MAJOR_ROW_OFFSET);
        this.dataWriter.writeRow(ProfileGridCellToExcelCellConverter.getTextCells(this.tier.getMajorAminoAcidRow()), this.startCol + MAJOR_COLUMN_OFFSET + 1, this.startRow + MAJOR_ROW_OFFSET);
    }

    private void writeComparisonSequenceRow() {
        this.dataWriter.writeString(this.comparisonSequenceRowName, this.startCol + COMPARISON_SEQUENCE_COLUMN_OFFSET, this.startRow + COMPARISON_SEQUENCE_ROW_OFFSET);
        this.dataWriter.writeRow(ProfileGridCellToExcelCellConverter.getTextCells(this.tier.getTemplateSequenceRow()), this.startCol + COMPARISON_SEQUENCE_COLUMN_OFFSET + 1, this.startRow + COMPARISON_SEQUENCE_ROW_OFFSET);
    }

    private void writeHighlightSequenceRow() {
        this.dataWriter.writeString(this.highlightSequenceRowName, this.startCol + HIGHLIGHT_SEQUENCE_COLUMN_OFFSET, this.startRow + HIGHLIGHT_SEQUENCE_ROW_OFFSET);
        this.dataWriter.writeRow(ProfileGridCellToExcelCellConverter.getTextCells(this.tier.getHighlightSequenceRow()), this.startCol + HIGHLIGHT_SEQUENCE_COLUMN_OFFSET + 1, this.startRow + HIGHLIGHT_SEQUENCE_ROW_OFFSET);
    }

    private void writeAminoAcidNamesAndSymbols() {
        this.writeAminoAcidNames(this.startCol + AMINO_ACID_NAMES_COLUMN_OFFSET, this.startRow + AMINO_ACID_DATA_ROW_OFFSET);
        this.writeAminoAcidSymbols(this.startCol + AMINO_ACID_SYMBOLS_COLUMN_OFFSET, this.startRow + AMINO_ACID_DATA_ROW_OFFSET);
        this.writeAminoAcidSymbols(this.startCol + AMINO_ACID_SYMBOLS_COLUMN_OFFSET + this.tier.getAminoAcidCounts().length + 1, this.startRow + AMINO_ACID_DATA_ROW_OFFSET);
    }

    private void writeAminoAcidCounts() {
        this.dataWriter.writeBlock(ProfileGridCellToExcelCellConverter.getNumericCells(this.tier.getAminoAcidCounts()), this.startCol + AMINO_ACID_DATA_COLUMN_OFFSET, this.startRow + AMINO_ACID_DATA_ROW_OFFSET);
    }

    private void writeAminoAcidSymbols(int col, int row) {
        this.dataWriter.writeCol(this.aminoAcidSymbols, col, row);
    }

    private void writeAminoAcidNames(int col, int row) {
        this.dataWriter.writeCol(this.aminoAcidNames, col, row);
    }

    private void setAminoAcidConstants() {
        this.aminoAcidConstantsNames = new ExcelTextCell[AminoAcidConstants.CONSTANT_NAMES.length];
        int i = 0;
        while (i < AminoAcidConstants.CONSTANT_NAMES.length) {
            this.aminoAcidConstantsNames[i] = new ExcelTextCell(DefaultFonts.getBoldAndCentered(), AminoAcidConstants.CONSTANT_NAMES[i]);
            ++i;
        }
        this.aminoAcidConstants = new ExcelNumericCell[AminoAcidConstants.ALL_CONSTANTS.length][];
        i = 0;
        while (i < AminoAcidConstants.ALL_CONSTANTS.length) {
            this.aminoAcidConstants[i] = new ExcelNumericCell[AminoAcidConstants.ALL_CONSTANTS[i].length];
            ++i;
        }
        i = 0;
        while (i < this.profileGrid.getSortedAminoAcidSymbols().length - 1) {
            double[] oldAminoAcidConstants = this.profileGrid.getAlignmentConstants().getConstantsForSymbol(this.profileGrid.getSortedAminoAcidSymbols()[i]);
            int j = 0;
            while (j < oldAminoAcidConstants.length) {
                this.aminoAcidConstants[j][i] = new ExcelNumericCell(DefaultFonts.getDefaultFormat(), oldAminoAcidConstants[j]);
                ++j;
            }
            ++i;
        }
    }

    private void setAminoAcidSymbols() {
        String[] oldAminoAcidSymbols = this.profileGrid.getSortedAminoAcidSymbols();
        ExcelTextCell[] nAminoAcidSymbols = new ExcelTextCell[oldAminoAcidSymbols.length];
        int i = 0;
        while (i < nAminoAcidSymbols.length) {
            nAminoAcidSymbols[i] = new ExcelTextCell(DefaultFonts.getBoldAndCentered(), oldAminoAcidSymbols[i]);
            ++i;
        }
        this.aminoAcidSymbols = nAminoAcidSymbols;
    }

    private void setAminoAcidNames() {
        String[] oldAminoAcidNames = this.profileGrid.getSortedAminoAcidNames();
        ExcelTextCell[] nAminoAcidNames = new ExcelTextCell[oldAminoAcidNames.length];
        int i = 0;
        while (i < nAminoAcidNames.length) {
            nAminoAcidNames[i] = new ExcelTextCell(DefaultFonts.getBoldAndRightAligned(), oldAminoAcidNames[i]);
            ++i;
        }
        this.aminoAcidNames = nAminoAcidNames;
    }

    public void writeWorkbook() {
        try {
            this.workbook.write();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeWorkbook() {
        try {
            this.workbook.close();
        }
        catch (IOException iOException) {
        }
        catch (WriteException writeException) {
            // empty catch block
        }
    }

    private void createSheet(String sheetName) {
        this.currentSheet = this.workbook.createSheet(sheetName, this.workbook.getNumberOfSheets());
        this.dataWriter = new ExcelDataBlockWriter(this.currentSheet);
    }

    private static String toTitleCase(String string) {
        String newString = "";
        boolean cap = true;
        int i = 0;
        while (i < string.length()) {
            newString = cap ? String.valueOf(newString) + String.valueOf(string.charAt(i)).toUpperCase() : String.valueOf(newString) + string.charAt(i);
            cap = newString.substring(newString.length() - 1, newString.length()).equalsIgnoreCase(" ");
            ++i;
        }
        return newString;
    }
}

