/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.file.writers.excel;

import java.text.DecimalFormat;
import java.text.ParseException;
import jprofilegrid.data.profilegrid.Numeric;
import jprofilegrid.data.profilegrid.Text;
import jprofilegrid.file.writers.excel.ExcelNumericCell;
import jprofilegrid.file.writers.excel.ExcelTextCell;
import jprofilegrid.file.writers.excel.ProfileGridFormatToExcelFormatConverter;
import jxl.write.WritableCellFormat;

public abstract class ProfileGridCellToExcelCellConverter {
    private static DecimalFormat formatter = new DecimalFormat();

    static {
        formatter.setMinimumFractionDigits(0);
        formatter.setMaximumFractionDigits(2);
    }

    public static ExcelTextCell[][] getTextCells(Text[][] cells) {
        ExcelTextCell[][] textCells = new ExcelTextCell[cells.length][];
        int i = 0;
        while (i < textCells.length) {
            textCells[i] = ProfileGridCellToExcelCellConverter.getTextCells(cells[i]);
            ++i;
        }
        return textCells;
    }

    public static ExcelTextCell[] getTextCells(Text[] cells) {
        ExcelTextCell[] textCells = new ExcelTextCell[cells.length];
        int i = 0;
        while (i < textCells.length) {
            textCells[i] = ProfileGridCellToExcelCellConverter.getTextCell(cells[i]);
            ++i;
        }
        return textCells;
    }

    public static ExcelNumericCell[][] getNumericCells(Numeric[][] cells) {
        ExcelNumericCell[][] numericCells = new ExcelNumericCell[cells.length][];
        int i = 0;
        while (i < numericCells.length) {
            numericCells[i] = ProfileGridCellToExcelCellConverter.getNumericCells(cells[i]);
            ++i;
        }
        return numericCells;
    }

    public static ExcelNumericCell[] getNumericCells(Numeric[] cells) {
        ExcelNumericCell[] numericCells = new ExcelNumericCell[cells.length];
        int i = 0;
        while (i < numericCells.length) {
            numericCells[i] = ProfileGridCellToExcelCellConverter.getNumericCell(cells[i]);
            ++i;
        }
        return numericCells;
    }

    public static ExcelNumericCell getNumericCell(Numeric cell) {
        WritableCellFormat format = ProfileGridFormatToExcelFormatConverter.extractWritableCellFormat(cell);
        double value = 0.0;
        try {
            value = formatter.parse(formatter.format(cell.getValue())).doubleValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new ExcelNumericCell(format, value);
    }

    public static ExcelTextCell getTextCell(Text cell) {
        WritableCellFormat format = ProfileGridFormatToExcelFormatConverter.extractWritableCellFormat(cell);
        String value = cell.getValue();
        return new ExcelTextCell(format, value);
    }
}

