/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.file.writers.pymol;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.PriorityQueue;
import jprofilegrid.data.GlobalData;
import jprofilegrid.data.profilegrid.ConservationRange;
import jprofilegrid.data.profilegrid.Text;
import jprofilegrid.data.profilegrid.Tier;
import jprofilegrid.file.writers.pymol.LinkAndMotif;
import jprofilegrid.gui.GlobalGUIData;

public class PyMOLScriptWriter {
    public static void outputPyMOLScript(String inputFile, String outputFile, int startIndex, int endIndex) {
        try {
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(outputFile));
            int[] positionInAlignmentRow = GlobalData.gridData.getProfileGrid().getEntireAlignment().getPositonInAlignmentRowWithoutSkippingGaps();
            int[][] aaCounts = GlobalData.gridData.getProfileGrid().getEntireAlignment().getIntegerAminoAcidCounts();
            double numberOfSequences = GlobalData.gridData.getProfileGrid().getNumberOfSequences();
            fileWriter.write("# JProfileGrid PyMOL Script\n");
            fileWriter.write("# Source Alignment File: " + inputFile + "\n");
            String templateSequenceName = GlobalData.gridData.getProfileGrid().getTemplateSequenceName().getValue();
            String highlightSequenceName = GlobalData.gridData.getProfileGrid().getHighlightSequenceName().getValue();
            fileWriter.write("# Template Sequence: " + templateSequenceName + "\n");
            fileWriter.write("# Highlight Sequence: " + (highlightSequenceName.equalsIgnoreCase("") ? "None Selected" : highlightSequenceName) + "\n\n");
            fileWriter.write("# Change \"filename.pdb\" below to the name of the PDB file.\n");
            fileWriter.write("load filename.pdb\n\n");
            fileWriter.write("# Various viewing settings.\n");
            fileWriter.write("viewport 750, 600\n");
            fileWriter.write("set cartoon_smooth_loops, 1\n");
            fileWriter.write("set cartoon_side_chain_helper, 1\n");
            fileWriter.write("set specular, 0.00000\n");
            fileWriter.write("set depth_cue, off\n");
            fileWriter.write("set ray_trace_fog, 0\n");
            fileWriter.write("set ray_shadows, 0\n\n");
            fileWriter.write("# Selects residues that are 100% conserved.\n");
            fileWriter.write("select ident, ");
            boolean first = true;
            int i = 0;
            while (i < aaCounts.length) {
                int j = 0;
                while (j < aaCounts[i].length) {
                    if ((double)aaCounts[i][j] == numberOfSequences) {
                        if (first) {
                            fileWriter.write("resi " + positionInAlignmentRow[i]);
                            first = false;
                        } else {
                            fileWriter.write("+" + positionInAlignmentRow[i]);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            fileWriter.write("\n");
            fileWriter.write("# Selects residues that pass the highest threshold value.\n");
            first = true;
            ConservationRange cRange = GlobalData.gridData.getConservationRanges();
            double maxThreshold = 0.0;
            int i2 = 0;
            while (i2 < cRange.getNumberOfRanges()) {
                if (cRange.getThreshold(i2) > maxThreshold) {
                    maxThreshold = cRange.getThreshold(i2);
                }
                ++i2;
            }
            fileWriter.write("select bin" + (int)(maxThreshold * 100.0) + ", ");
            i2 = 0;
            while (i2 < aaCounts.length) {
                int j = 0;
                while (j < aaCounts[i2].length) {
                    boolean columnOutputted = false;
                    if (!columnOutputted && (double)aaCounts[i2][j] / numberOfSequences >= maxThreshold) {
                        if (first) {
                            fileWriter.write("resi " + positionInAlignmentRow[i2]);
                            first = false;
                            columnOutputted = true;
                        } else {
                            columnOutputted = true;
                            fileWriter.write("+" + positionInAlignmentRow[i2]);
                        }
                    }
                    ++j;
                }
                ++i2;
            }
            fileWriter.write("\n\n");
            fileWriter.write("# Selects residues that are highlighted.\n");
            first = true;
            Text[] templateSequenceRow = GlobalData.gridData.getProfileGrid().getEntireAlignment().getTemplateSequenceRow();
            Text[] highlightSequenceRow = GlobalData.gridData.getProfileGrid().getEntireAlignment().getHighlightSequenceRow();
            int startValue = GlobalGUIData.gui.getGridParametersPanel().getPositionStart();
            int gapSubtractAmount = 0;
            if (!highlightSequenceName.equalsIgnoreCase("")) {
                fileWriter.write("select highlight, ");
                int i3 = 0;
                while (i3 < templateSequenceRow.length) {
                    String currentTemplateAA = templateSequenceRow[i3].getValue();
                    if (!(currentTemplateAA.equalsIgnoreCase(".") || currentTemplateAA.equalsIgnoreCase("*") || currentTemplateAA.equalsIgnoreCase("-"))) {
                        if (i3 < highlightSequenceRow.length && !currentTemplateAA.equalsIgnoreCase(highlightSequenceRow[i3].getValue())) {
                            if (first) {
                                fileWriter.write("resi " + (i3 + startValue + gapSubtractAmount));
                                first = false;
                            } else {
                                fileWriter.write("+" + (i3 + startValue + gapSubtractAmount));
                            }
                        }
                    } else {
                        --gapSubtractAmount;
                    }
                    ++i3;
                }
            } else {
                fileWriter.write("# Template and highlight sequences are the same.");
            }
            fileWriter.write("\n\n");
            fileWriter.write("# Similarity plot calculation results.\n");
            PriorityQueue<LinkAndMotif> linksAndMotifs = new PriorityQueue<LinkAndMotif>();
            int currentMotif = 0;
            boolean computed = false;
            int numberOfMotifs = GlobalData.gridData.getProfileGrid().getNumberOfMotifRegions();
            int i4 = 0;
            while (i4 < numberOfMotifs) {
                computed = true;
                Tier currentTier = GlobalData.gridData.getProfileGrid().getMotifRegion(i4);
                int currentTierLeft = currentTier.getPositonInAlignmentRowWithoutSkippingGaps()[0];
                int currentTierRight = currentTier.getPositonInAlignmentRowWithoutSkippingGaps()[currentTier.getPositonInAlignmentRowWithoutSkippingGaps().length - 1];
                boolean finishedFindingMotifEnd = false;
                while (i4 + 1 < numberOfMotifs && !finishedFindingMotifEnd) {
                    Tier nextTier = GlobalData.gridData.getProfileGrid().getMotifRegion(i4 + 1);
                    int nextTierLeft = nextTier.getPositonInAlignmentRowWithoutSkippingGaps()[0];
                    if (nextTierLeft <= currentTierRight + 1) {
                        currentTierRight = nextTier.getPositonInAlignmentRowWithoutSkippingGaps()[nextTier.getPositonInAlignmentRowWithoutSkippingGaps().length - 1];
                        ++i4;
                        continue;
                    }
                    finishedFindingMotifEnd = true;
                }
                linksAndMotifs.add(new LinkAndMotif(false, currentMotif, currentTierLeft, currentTierRight));
                ++currentMotif;
                ++i4;
            }
            int currentVariableRegion = 0;
            int numberOfVariableRegions = GlobalData.gridData.getProfileGrid().getNumberOfVariableRegions();
            int i5 = 0;
            while (i5 < numberOfVariableRegions) {
                computed = true;
                Tier currentTier = GlobalData.gridData.getProfileGrid().getVariableRegion(i5);
                int currentTierLeft = currentTier.getPositonInAlignmentRowWithoutSkippingGaps()[0];
                int currentTierRight = currentTier.getPositonInAlignmentRowWithoutSkippingGaps()[currentTier.getPositonInAlignmentRowWithoutSkippingGaps().length - 1];
                boolean finishedFindingVariableEnd = false;
                while (i5 + 1 < numberOfVariableRegions && !finishedFindingVariableEnd) {
                    Tier nextTier = GlobalData.gridData.getProfileGrid().getVariableRegion(i5 + 1);
                    int nextTierLeft = nextTier.getPositonInAlignmentRowWithoutSkippingGaps()[0];
                    if (nextTierLeft <= currentTierRight + 1) {
                        currentTierRight = nextTier.getPositonInAlignmentRowWithoutSkippingGaps()[nextTier.getPositonInAlignmentRowWithoutSkippingGaps().length - 1];
                        ++i5;
                        continue;
                    }
                    finishedFindingVariableEnd = true;
                }
                linksAndMotifs.add(new LinkAndMotif(true, currentVariableRegion, currentTierLeft, currentTierRight));
                ++currentVariableRegion;
                ++i5;
            }
            boolean pastStart = false;
            boolean isFirstPastStart = false;
            boolean isLastBeforeEnd = false;
            boolean pastEnd = false;
            int currentMotifNumber = 0;
            int currentVariableRegionNumber = 0;
            while (!linksAndMotifs.isEmpty()) {
                LinkAndMotif currentLinkOrMotif = (LinkAndMotif)linksAndMotifs.remove();
                if (!pastStart && currentLinkOrMotif.getStartIndex() <= startIndex && startIndex <= currentLinkOrMotif.getEndIndex()) {
                    pastStart = true;
                    isFirstPastStart = true;
                }
                if (!pastStart) continue;
                if (!pastEnd && currentLinkOrMotif.getEndIndex() >= endIndex && currentLinkOrMotif.getStartIndex() <= endIndex) {
                    pastEnd = true;
                    isLastBeforeEnd = true;
                }
                if (pastEnd && !isLastBeforeEnd) continue;
                if (currentLinkOrMotif.isLink()) {
                    currentLinkOrMotif.setNumber(currentVariableRegionNumber);
                    ++currentVariableRegionNumber;
                } else {
                    currentLinkOrMotif.setNumber(currentMotifNumber);
                    ++currentMotifNumber;
                }
                if (isFirstPastStart) {
                    isFirstPastStart = false;
                    fileWriter.write(String.valueOf(currentLinkOrMotif.getPyMOLStringWithoutRanges()) + startIndex + "-");
                    if (isLastBeforeEnd) {
                        fileWriter.write(String.valueOf(endIndex) + "\n");
                        isLastBeforeEnd = false;
                        continue;
                    }
                    fileWriter.write(String.valueOf(currentLinkOrMotif.getEndIndex()) + "\n");
                    continue;
                }
                if (isLastBeforeEnd) {
                    fileWriter.write(String.valueOf(currentLinkOrMotif.getPyMOLStringWithoutRanges()) + currentLinkOrMotif.getStartIndex() + "-" + endIndex);
                    isLastBeforeEnd = false;
                    continue;
                }
                fileWriter.write(String.valueOf(currentLinkOrMotif.getPyMOLString()) + "\n");
            }
            if (!computed) {
                fileWriter.write("# Similarity plot has not been computed in JProfileGrid.\n");
            } else {
                DecimalFormat formatter = new DecimalFormat();
                formatter.setMaximumFractionDigits(6);
                formatter.setMinimumFractionDigits(6);
                fileWriter.write("\n\n# Colors links light gray.\n");
                int i6 = 0;
                while (i6 < currentVariableRegionNumber) {
                    fileWriter.write("color gray80, var" + i6 + "\n");
                    ++i6;
                }
                fileWriter.write("\n# Coloring ranges for motifs (from red to green).\n");
                double colorStepSize = 1.0 / (double)currentMotifNumber;
                int i7 = 0;
                while (i7 < currentMotifNumber) {
                    fileWriter.write("set_color col" + i7 + ", [" + formatter.format(1.0 - (double)i7 * colorStepSize) + ", " + formatter.format((double)i7 * colorStepSize) + ", " + formatter.format(0L) + "]\n");
                    ++i7;
                }
                fileWriter.write("\n# Perform the coloring of the motifs.\n");
                i7 = 0;
                while (i7 < currentMotifNumber) {
                    fileWriter.write("color col" + i7 + ", mot" + i7 + "\n");
                    ++i7;
                }
            }
            fileWriter.write("\n# Cartoon-render everything.\n");
            fileWriter.write("hide all\n");
            fileWriter.write("bg_color white\n");
            fileWriter.write("show cartoon, all");
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

