/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import jprofilegrid.data.GlobalData;
import jprofilegrid.data.calculations.GridData;
import jprofilegrid.gui.GridBagConstraintsInitializer;
import jprofilegrid.gui.OpenWindowsMenu;
import jprofilegrid.gui.color.ColorPriorityQueue;
import jprofilegrid.gui.color.ColorSorter;
import jprofilegrid.gui.jframes.celldescription.CellDescriptionJFrame;
import jprofilegrid.gui.jframes.frequencycolors.FrequencyColorsJFrame;
import jprofilegrid.gui.jframes.main.MainJFrame;
import jprofilegrid.gui.jframes.profilegrid.ProfileGridJFrame;
import jxl.format.Colour;

public class GlobalGUIData
implements ActionListener,
WindowListener {
    public static GlobalGUIData globalGUIData;
    public static Colour[] SORTED_COLOURS;
    public static String[] SORTED_COLOUR_NAMES;
    private MenuBar menuBar = new MenuBar();
    private Menu fileMenu = new Menu("File");
    private Menu aboutMenu = new Menu("About");
    private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
    private MenuItem quitMenuItem = new MenuItem("Quit");
    public static Vector<JFrame> currentlyOpenWindows;
    public static MainJFrame gui;
    private static OpenWindowsMenu guiOpenWindowsMenu;
    private ProfileGridJFrame profileGridJFrame;
    public static OpenWindowsMenu profileGridOpenWindowsMenu;
    private static CellDescriptionJFrame cellDescriptionJFrame;
    public static OpenWindowsMenu cellDescriptionOpenWindowsMenu;
    private static FrequencyColorsJFrame freqColor;
    public static OpenWindowsMenu frequencyColorsOpenWindowsMenu;
    public static OpenWindowsMenu alignmentOpenWindowsMenu;
    private boolean firstCompute = true;

    static {
        SORTED_COLOURS = GlobalGUIData.getSortedColours();
        SORTED_COLOUR_NAMES = GlobalGUIData.getSortedColourNames();
        currentlyOpenWindows = new Vector();
        gui = new MainJFrame();
        guiOpenWindowsMenu = new OpenWindowsMenu();
        profileGridOpenWindowsMenu = new OpenWindowsMenu();
        cellDescriptionOpenWindowsMenu = new OpenWindowsMenu();
        frequencyColorsOpenWindowsMenu = new OpenWindowsMenu();
        alignmentOpenWindowsMenu = new OpenWindowsMenu();
    }

    public GlobalGUIData() {
        globalGUIData = this;
        this.profileGridJFrame = new ProfileGridJFrame();
        freqColor = new FrequencyColorsJFrame();
        gui.addWindowListener(this);
        gui.setMenuBar(this.menuBar);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(guiOpenWindowsMenu);
        this.menuBar.add(this.aboutMenu);
        this.quitMenuItem.addActionListener(globalGUIData);
        this.aboutMenu.add(this.aboutMenuItem);
        this.aboutMenuItem.addActionListener(globalGUIData);
        this.fileMenu.add(this.quitMenuItem);
    }

    private static Colour[] getSortedColours() {
        ColorPriorityQueue allColors = new ColorPriorityQueue();
        allColors.add(new ColorSorter(Colour.BLACK));
        allColors.add(new ColorSorter(Colour.GRAY_80));
        int i = 10;
        int j = 0;
        while (i < 63) {
            if (i != 20 && allColors.doesNotContain(new ColorSorter(Colour.getInternalColour(i)))) {
                allColors.add(new ColorSorter(Colour.getInternalColour(i)));
            }
            ++i;
            ++j;
        }
        allColors.add(new ColorSorter(Colour.WHITE));
        SORTED_COLOURS = new Colour[allColors.size()];
        i = 0;
        while (i < SORTED_COLOURS.length) {
            GlobalGUIData.SORTED_COLOURS[i] = ((ColorSorter)allColors.remove()).getColour();
            ++i;
        }
        return SORTED_COLOURS;
    }

    private static String[] getSortedColourNames() {
        ColorPriorityQueue allColors = new ColorPriorityQueue();
        allColors.add(new ColorSorter(Colour.BLACK));
        allColors.add(new ColorSorter(Colour.WHITE));
        allColors.add(new ColorSorter(Colour.GRAY_80));
        int i = 10;
        int j = 0;
        while (i < 63) {
            if (allColors.doesNotContain(new ColorSorter(Colour.getInternalColour(i)))) {
                allColors.add(new ColorSorter(Colour.getInternalColour(i)));
            }
            ++i;
            ++j;
        }
        SORTED_COLOUR_NAMES = new String[allColors.size()];
        i = 0;
        while (i < SORTED_COLOUR_NAMES.length) {
            GlobalGUIData.SORTED_COLOUR_NAMES[i] = ((ColorSorter)allColors.remove()).getColour().getDescription();
            ++i;
        }
        return SORTED_COLOUR_NAMES;
    }

    public static int getColorIndexWithName(String name) {
        int i = 0;
        while (i < SORTED_COLOURS.length) {
            if (name.equalsIgnoreCase(SORTED_COLOURS[i].getDescription())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void displayWindow() {
        gui.displayWindow();
    }

    public void updateProfileGridFrame() {
        if (GlobalData.analysisOptions.getSortTypeChanged() || GlobalData.analysisOptions.getSortAscendingChanged()) {
            GlobalData.gridData.convertSortedDataToProfileGrid();
        } else {
            GlobalData.gridData.updateProfileGrid();
        }
        this.profileGridJFrame.run();
        this.setCellDescriptionDialogSelectedAminoAcid(cellDescriptionJFrame.getSelectedRow(), cellDescriptionJFrame.getSelectedColumn());
    }

    public void openFrequencyColorsSelectionDialog() {
        freqColor.setLocation(gui.getX() + gui.getWidth() + 1, gui.getY() + gui.getHeight() / 2);
        freqColor.setVisible(true);
    }

    public void openIdentifySequencesDialog() {
        cellDescriptionJFrame.setLocation(gui.getX() + gui.getWidth() + 1, gui.getY() + gui.getHeight() / 4);
        cellDescriptionJFrame.setGrid(GlobalData.gridData);
        cellDescriptionJFrame.setVisible(true);
        cellDescriptionJFrame.update(cellDescriptionJFrame.getGraphics());
    }

    public void setCellDescriptionPaneVisible(boolean isVisible) {
        cellDescriptionJFrame.setVisible(isVisible);
    }

    public void setCellDescriptionDialogSelectedAminoAcid(int row, int column) {
        cellDescriptionJFrame.setSelectedAminoAcid(row, column);
        this.profileGridJFrame.setSelectedCell();
    }

    public void updateDisplayedSequences() {
        cellDescriptionJFrame.setDisplayedSequences(gui.getGridParametersPanel().getDisplayedResidueIfPresent());
        cellDescriptionJFrame.setSelectedAminoAcid(cellDescriptionJFrame.getSelectedRow(), cellDescriptionJFrame.getSelectedColumn());
    }

    public static void browseForMSAFile() {
        FileDialog fileDialog = new FileDialog((Frame)gui, "Load Alignment", 0);
        fileDialog.setVisible(true);
        String msaFilename = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
        if (fileDialog.getFile() != null) {
            gui.getLoadAlignmentPanel().getLoadFileBlank().setText(msaFilename);
            gui.getLoadAlignmentPanel().getLoadFileButton().setEnabled(true);
            gui.getLoadAlignmentPanel().setFilenameWithoutPath(fileDialog.getFile());
        }
    }

    private void resetJFrames() {
        if (this.profileGridJFrame != null) {
            this.profileGridJFrame.setVisible(false);
        }
        if (cellDescriptionJFrame != null) {
            cellDescriptionJFrame.setVisible(false);
        }
        if (freqColor != null) {
            freqColor.setVisible(false);
        }
    }

    public void performLoad() {
        this.resetJFrames();
        gui.getExportPanel().setOutputFilename(String.valueOf(gui.getLoadAlignmentPanel().getFilename()) + ".xls");
        GlobalData.gridData = new GridData(gui.getLoadAlignmentPanel().getFilenameWithoutPath(), gui.getLoadAlignmentPanel().getFilename(), gui.getLoadAlignmentPanel().getTypeOfMSA(), gui.getLoadAlignmentPanel().getAlignmentType());
        cellDescriptionJFrame = new CellDescriptionJFrame(GlobalData.gridData);
        gui.getGridParametersPanel().clearHighlightSequence();
        gui.getGridParametersPanel().clearPositionSequence();
        gui.getGridParametersPanel().clearSortTypeBlank();
        int numberOfSequences = GlobalData.gridData.getMultipleSequenceAlignment().getNumberOfSequences();
        int i = 0;
        while (i < numberOfSequences) {
            gui.getGridParametersPanel().addToHighlightSequence(GlobalData.gridData.getMultipleSequenceAlignment().getSequence(i).getSpecies());
            gui.getGridParametersPanel().addToTemplateSequence(GlobalData.gridData.getMultipleSequenceAlignment().getSequence(i).getSpecies());
            ++i;
        }
        this.firstCompute = true;
        gui.getGridParametersPanel().setSortTypeBlank(GlobalData.gridData.getAlignmentConstants().getSortTypes());
        GlobalGUIData.enableAllComponents(gui.getGridParametersPanel());
        GlobalGUIData.enableAllComponents(gui.getSimilarityParametersPanel().getEnabledSimilaritiesJPanel());
        gui.getSimilarityParametersPanel().enableProfileGridButton();
        GlobalGUIData.disableAllComponents(gui.getSimilarityParametersPanel());
        GlobalGUIData.disableAllComponents(gui.getGridParametersPanel().getPositionRulerJPanel());
        GlobalGUIData.disableAllComponents(gui.getExportPanel());
        gui.pack();
        globalGUIData.computeProfileGrid();
    }

    public void computeProfileGrid() {
        gui.getSimilarityParametersPanel().disableProfileGridButton();
        GlobalData.analysisOptions.setHighlightSequence(GlobalData.gridData.getMultipleSequenceAlignment().getSequence(this.getHighlightSequence()));
        GlobalData.analysisOptions.setTemplateSequence(GlobalData.gridData.getMultipleSequenceAlignment().getSequence(this.getTemplateSequence()));
        GlobalData.analysisOptions.setHighlightSequenceColour(this.getHighlightSequenceColour());
        GlobalData.analysisOptions.setPositionRowStart(this.getPositionRowStart());
        GlobalData.analysisOptions.setShowValuesAs(GlobalGUIData.getShowValuesAs());
        GlobalData.analysisOptions.setSkipGaps(this.getSkipGaps());
        GlobalData.analysisOptions.setSortType(this.getSortType());
        GlobalData.analysisOptions.setSortAscending(this.isAscendingSort());
        GlobalData.analysisOptions.setSimilarityParametersEnabled(this.similarityParametersEnabled());
        GlobalData.gridData.setAnalysisParameters(this.getOutputFilename(), this.getWindowSize(), this.getColumnsPerTier(), this.getThreshold(), this.frequencyColorsEnabled(), this.similarityParametersEnabled() && !this.firstCompute);
        if (this.firstCompute) {
            GlobalData.gridData.convertSortedDataToProfileGrid();
        }
        GlobalData.gridData.analyze(true);
        GlobalGUIData.enableAllComponents(gui.getGridParametersPanel());
        GlobalGUIData.enableAllComponents(gui.getGridParametersPanel().getPositionRulerJPanel());
        if (this.firstCompute) {
            GlobalGUIData.enableAllComponents(gui.getExportPanel());
            gui.getExportPanel().setOutputFileType(0);
        }
        gui.getExportPanel().setFinalColumn(GlobalData.gridData.getMultipleSequenceAlignment().getMinSequenceLength());
        gui.getExportPanel().setStartColumn(1);
        GlobalGUIData.enableAllComponents(gui.getExportPanel().getColumnsSelectionPanel());
        if (this.similarityParametersEnabled() && !gui.getSimilarityParametersPanel().currentlyComputing()) {
            GlobalGUIData.enableAllComponents(gui.getSimilarityParametersPanel());
        }
        this.profileGridJFrame.resetDisplay();
        if (this.firstCompute) {
            this.profileGridJFrame.setLocation(globalGUIData.getProfileGridLocation());
        }
        this.firstCompute = false;
        this.profileGridJFrame.setVisible(true);
        freqColor.updateProfileGrid();
        this.updateProfileGridFrame();
    }

    public void setSimilarityPlotComputeButtonRed() {
        gui.getSimilarityParametersPanel().setSimilarityComputationButtonRed();
    }

    public void setSimilarityPlotComputeButtonDone() {
        gui.getSimilarityParametersPanel().setSimilarityComputationButtonDone();
    }

    public void resetDisplay() {
        this.profileGridJFrame.resetDisplay();
    }

    public Point getProfileGridLocation() {
        return new Point(gui.getX() + gui.getWidth(), gui.getY());
    }

    public void browseForOutputFile() {
        FileDialog fileDialog = new FileDialog((Frame)gui, "Choose Output File", 1);
        fileDialog.setVisible(true);
        String outputFileName = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
        if (fileDialog.getFile() != null) {
            gui.getExportPanel().getOutputFileBlank().setText(outputFileName);
        }
    }

    public boolean getDisplayedResidueIfPresent() {
        return gui.getGridParametersPanel().getDisplayedResidueIfPresent();
    }

    public boolean similarityParametersEnabled() {
        return gui.getSimilarityParametersPanel().similarityParametersEnabled();
    }

    public Colour getHighlightSequenceColour() {
        return SORTED_COLOURS[gui.getGridParametersPanel().getHighlightSequenceColor()];
    }

    public String getOutputFilename() {
        return gui.getExportPanel().getOutputFilename();
    }

    public int getColumnsPerTier() {
        return gui.getExportPanel().getColumnsPerTier();
    }

    public double getThreshold() {
        return gui.getSimilarityParametersPanel().getThreshold();
    }

    public int getWindowSize() {
        return gui.getSimilarityParametersPanel().getWindowSize();
    }

    public int getHighlightSequence() {
        return gui.getGridParametersPanel().getHighlightSequence();
    }

    public int getSortType() {
        return gui.getGridParametersPanel().getSortType();
    }

    public boolean isAscendingSort() {
        return gui.getGridParametersPanel().isAscendingSort();
    }

    public int getTemplateSequence() {
        return gui.getGridParametersPanel().getPositionSequence();
    }

    public int getPositionRowStart() {
        try {
            return gui.getGridParametersPanel().getPositionStart();
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public boolean getSkipGaps() {
        return gui.getGridParametersPanel().skipGapsEnabled();
    }

    public boolean frequencyColorsEnabled() {
        return gui.getGridParametersPanel().frequencyColorsEnabled();
    }

    public static void disableAllComponents(Container cont) {
        Component[] allComponents = cont.getComponents();
        int i = 0;
        while (i < allComponents.length) {
            allComponents[i].setEnabled(false);
            ++i;
        }
    }

    public static void enableAllComponents(Container cont) {
        Component[] allComponents = cont.getComponents();
        int i = 0;
        while (i < allComponents.length) {
            allComponents[i].setEnabled(true);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.quitMenuItem) {
            System.exit(0);
        }
        if (event.getSource() == this.aboutMenuItem) {
            GlobalGUIData.displayAboutDialog();
        }
    }

    public static void displayAboutDialog() {
        JPanel aboutJPanel = new JPanel();
        aboutJPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagConstraintsInitializer.resetConstraints(constraints);
        constraints.insets = new Insets(0, 10, 2, 10);
        JLabel rowOne = new JLabel("JProfileGrid v1.2.2, August 19th, 2009");
        rowOne.setHorizontalAlignment(0);
        JLabel rowTwo = new JLabel("http://www.profilegrid.org");
        rowTwo.setHorizontalAlignment(0);
        JTextArea rowThree = new JTextArea("Cite publication: A.I.Roca, A.E.Alamda, and A.C.Abajian, ProfileGrids as a new visual\nrepresentation of large multiple sequence alignments: a case study of the RecA protein\nfamily, BMC Bioinformatics 9: 554 (2008)");
        rowThree.setBackground(gui.getBackground());
        rowThree.setEditable(false);
        JTextArea rowFive = new JTextArea("The ProfileGrid representation is in the public domain\nif others wish to code their own implementations.");
        rowFive.setBackground(gui.getBackground());
        rowFive.setFont(new Font(rowFive.getFont().getName(), 1, rowFive.getFont().getSize()));
        rowFive.setEditable(false);
        JTextArea rowSix = new JTextArea("Copyright (c) 2007 The Regents of the University of California. All Rights Reserved.\n\nPermission to use, copy, modify, and distribute this software and its documentation\nfor educational, research and non-profit purposes, without fee, and without a written\nagreement is hereby granted, provided that the above copyright notice, this paragraph\nand the following three paragraphs appear in all copies.\n\nPermission to incorporate this software into commercial products may be obtained\nby contacting profilegrid.org.\n\nThis software program and documentation are copyrighted by The Regents of the University\n of California. The software program and documentation are supplied \"as is\", without any\naccompanying services from The Regents. The Regents does not warrant that the operation of \nthe program will be uninterrupted or error-free. The end-user understands that the program\nwas developed for research purposes and is advised not to rely exclusively on the program\nfor any reason.\n\nIN NO EVENT SHALLTHE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT,\nINDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,\nARISING OUT OF THE USEOF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE\nUNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. \nTHE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,\nBUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\nA PARTICULAR PURPOSE AND ANY STATUTORY WARRANTY OF NON-INFRINGEMENT. THE\nSOFTWARE PROVIDED HEREUNDER IS ON AN \"AS IS\" BASIS, AND THE UNIVERSITY OF\nCALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,\nENHANCEMENTS, OR MODIFICATIONS.");
        rowSix.setBackground(gui.getBackground());
        rowSix.setEditable(false);
        aboutJPanel.add((Component)rowOne, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 10, 10, 10);
        aboutJPanel.add((Component)rowTwo, constraints);
        constraints.insets = new Insets(0, 10, 2, 10);
        ++constraints.gridy;
        constraints.anchor = 21;
        aboutJPanel.add((Component)rowThree, constraints);
        constraints.insets = new Insets(10, 10, 2, 10);
        ++constraints.gridy;
        aboutJPanel.add((Component)rowFive, constraints);
        ++constraints.gridy;
        aboutJPanel.add((Component)rowSix, constraints);
        aboutJPanel.setBackground(gui.getBackground());
        JDialog aboutDialog = new JDialog((Frame)gui, "About");
        aboutDialog.add(aboutJPanel);
        aboutDialog.pack();
        aboutDialog.setLocation(gui.getX() + (gui.getWidth() - aboutDialog.getWidth()) / 2, gui.getY());
        aboutDialog.setResizable(false);
        aboutDialog.setVisible(true);
    }

    public static int getShowValuesAs() {
        return gui.getGridParametersPanel().showValueAs();
    }

    public void windowActivated(WindowEvent e) {
        if (!currentlyOpenWindows.contains((JFrame)e.getSource())) {
            currentlyOpenWindows.add((JFrame)e.getSource());
        }
        this.updateWindowMenu();
    }

    public void windowClosed(WindowEvent e) {
        if (currentlyOpenWindows.contains((JFrame)e.getSource())) {
            currentlyOpenWindows.remove((JFrame)e.getSource());
        }
        this.updateWindowMenu();
    }

    public void windowClosing(WindowEvent e) {
        if (currentlyOpenWindows.contains((JFrame)e.getSource())) {
            currentlyOpenWindows.remove((JFrame)e.getSource());
        }
        this.updateWindowMenu();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
        if (!currentlyOpenWindows.contains((JFrame)e.getSource())) {
            currentlyOpenWindows.add((JFrame)e.getSource());
        }
        this.updateWindowMenu();
    }

    private void updateWindowMenu() {
        guiOpenWindowsMenu.updateOpenWindows();
        profileGridOpenWindowsMenu.updateOpenWindows();
        cellDescriptionOpenWindowsMenu.updateOpenWindows();
        frequencyColorsOpenWindowsMenu.updateOpenWindows();
        alignmentOpenWindowsMenu.updateOpenWindows();
    }
}

