/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.gui.jframes.alignmentwindow;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jprofilegrid.gui.GlobalGUIData;
import jprofilegrid.gui.GridBagConstraintsInitializer;

public class AlignmentWindow
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextArea alignmentJTextArea = new JTextArea();
    private JScrollPane scrollPane = new JScrollPane(this.alignmentJTextArea);
    private JScrollBar verticalBar = new JScrollBar(1);
    private JScrollBar horizontalBar = new JScrollBar(0);
    private MenuBar menuBar = new MenuBar();
    private Menu fileMenu = new Menu("File");
    private Menu aboutMenu = new Menu("About");
    private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
    private MenuItem quitMenuItem = new MenuItem("Quit");
    private static Dimension DEFAULT_DIMENSION = new Dimension(300, 200);

    public AlignmentWindow() {
        super("Alignment");
        this.addWindowListener(GlobalGUIData.globalGUIData);
        this.scrollPane.setVerticalScrollBar(this.verticalBar);
        this.scrollPane.setHorizontalScrollBar(this.horizontalBar);
        this.alignmentJTextArea.setBackground(this.getBackground());
        this.alignmentJTextArea.setFont(new Font("COURIER", 0, 16));
        this.alignmentJTextArea.setEditable(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagConstraintsInitializer.resetConstraints(constraints);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)this.scrollPane, constraints);
        this.setSize(DEFAULT_DIMENSION);
        this.initializeMenuBar();
    }

    private void initializeMenuBar() {
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(GlobalGUIData.alignmentOpenWindowsMenu);
        this.menuBar.add(this.aboutMenu);
        this.quitMenuItem.addActionListener(this);
        this.aboutMenu.add(this.aboutMenuItem);
        this.aboutMenuItem.addActionListener(this);
        this.fileMenu.add(this.quitMenuItem);
        this.setMenuBar(this.menuBar);
    }

    public void updateText(String newText) {
        this.alignmentJTextArea.setText(newText);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.quitMenuItem) {
            System.exit(0);
        }
        if (e.getSource() == this.aboutMenuItem) {
            GlobalGUIData.displayAboutDialog();
        }
    }
}

