/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.gui.jframes.celldescription;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jprofilegrid.data.calculations.GridData;
import jprofilegrid.data.calculations.Sequence;
import jprofilegrid.gui.GlobalGUIData;
import jprofilegrid.gui.GridBagConstraintsInitializer;
import jprofilegrid.gui.jframes.alignmentwindow.AlignmentWindow;

public class CellDescriptionJFrame
extends JFrame
implements ActionListener,
ClipboardOwner {
    private static final long serialVersionUID = 503347149005198654L;
    private JTextArea currentSelectedCell = new JTextArea("Select Cell");
    private GridData gridData;
    private JScrollPane scrollPane = new JScrollPane(this.currentSelectedCell);
    private JScrollBar verticalBar = new JScrollBar(1);
    private JScrollBar horizontalBar = new JScrollBar(0);
    private int row;
    private int column;
    private JButton showAlignmentJButton = new JButton("Show Alignment");
    private AlignmentWindow alignmentWindow = new AlignmentWindow();
    private boolean residuePresent = true;
    private MenuBar menuBar = new MenuBar();
    private Menu fileMenu = new Menu("File");
    private Menu aboutMenu = new Menu("About");
    private Menu editMenu = new Menu("Edit");
    private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
    private MenuItem quitMenuItem = new MenuItem("Quit");
    private MenuItem copyItem = new MenuItem("Copy Sequence List");

    public CellDescriptionJFrame(GridData nGridData) {
        super("Sequences");
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.addWindowListener(GlobalGUIData.globalGUIData);
        GridBagConstraintsInitializer.resetConstraints(constraints);
        this.gridData = nGridData;
        this.initializeMenuBar();
        this.scrollPane.setVerticalScrollBar(this.verticalBar);
        this.scrollPane.setHorizontalScrollBar(this.horizontalBar);
        this.currentSelectedCell.setEditable(false);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)this.scrollPane, constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        this.add((Component)this.showAlignmentJButton, constraints);
        this.showAlignmentJButton.addActionListener(this);
        this.setSize(150, 300);
    }

    private void initializeMenuBar() {
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(GlobalGUIData.cellDescriptionOpenWindowsMenu);
        this.menuBar.add(this.aboutMenu);
        this.quitMenuItem.addActionListener(this);
        this.aboutMenu.add(this.aboutMenuItem);
        this.aboutMenuItem.addActionListener(this);
        this.editMenu.add(this.copyItem);
        this.copyItem.addActionListener(this);
        this.fileMenu.add(this.quitMenuItem);
        this.setMenuBar(this.menuBar);
    }

    public void setVisible(boolean visible) {
        this.currentSelectedCell.setBackground(this.getBackground());
        super.setVisible(visible);
    }

    public void setSelectedAminoAcid(int row, int column) {
        Sequence currentSequence;
        this.row = row;
        this.column = column;
        String listOfSequences = "";
        Vector<Sequence> alignmentSequences = new Vector<Sequence>();
        alignmentSequences.add(this.gridData.getMultipleSequenceAlignment().getSequence(GlobalGUIData.globalGUIData.getTemplateSequence()));
        if (GlobalGUIData.globalGUIData.getTemplateSequence() != GlobalGUIData.globalGUIData.getHighlightSequence()) {
            alignmentSequences.add(this.gridData.getMultipleSequenceAlignment().getSequence(GlobalGUIData.globalGUIData.getHighlightSequence()));
        }
        boolean hasAtLeastOneSpecies = false;
        String currentSymbol = this.gridData.getProfileGrid().getSortedAminoAcidSymbols()[row];
        boolean currentSymbolIsGap = currentSymbol.equalsIgnoreCase(".") || currentSymbol.equalsIgnoreCase("-") || currentSymbol.equalsIgnoreCase("_");
        int i = 0;
        while (i < this.gridData.getMultipleSequenceAlignment().getNumberOfSequences()) {
            boolean comparisonSymbolIsGap;
            String comparisonSymbol;
            if (this.residuePresent) {
                comparisonSymbol = this.gridData.getMultipleSequenceAlignment().getSequence(i).getAminoAcid(column);
                boolean bl = comparisonSymbolIsGap = comparisonSymbol.equalsIgnoreCase(".") || comparisonSymbol.equalsIgnoreCase("-") || comparisonSymbol.equalsIgnoreCase("_");
                if (comparisonSymbol.equalsIgnoreCase(currentSymbol) || currentSymbolIsGap && comparisonSymbolIsGap) {
                    currentSequence = this.gridData.getMultipleSequenceAlignment().getSequence(i);
                    listOfSequences = listOfSequences.concat(currentSequence.getSpecies().concat("\n"));
                    if (this.alignmentWindow.isVisible()) {
                        alignmentSequences.add(currentSequence);
                    }
                    hasAtLeastOneSpecies = true;
                }
            } else {
                comparisonSymbol = this.gridData.getMultipleSequenceAlignment().getSequence(i).getAminoAcid(column);
                boolean bl = comparisonSymbolIsGap = comparisonSymbol.equalsIgnoreCase(".") || comparisonSymbol.equalsIgnoreCase("-") || comparisonSymbol.equalsIgnoreCase("_");
                if (!(comparisonSymbol.equalsIgnoreCase(currentSymbol) || currentSymbolIsGap && comparisonSymbolIsGap)) {
                    currentSequence = this.gridData.getMultipleSequenceAlignment().getSequence(i);
                    listOfSequences = listOfSequences.concat(currentSequence.getSpecies().concat("\n"));
                    if (this.alignmentWindow.isVisible()) {
                        alignmentSequences.add(currentSequence);
                    }
                    hasAtLeastOneSpecies = true;
                }
            }
            ++i;
        }
        if (hasAtLeastOneSpecies) {
            listOfSequences = listOfSequences.substring(0, listOfSequences.length() - 1);
        }
        StringBuffer alignment = new StringBuffer("");
        if (this.alignmentWindow.isVisible()) {
            int maxSequenceName = 0;
            int i2 = 0;
            while (i2 < alignmentSequences.size()) {
                if (((Sequence)alignmentSequences.get(i2)).getSpecies().length() > maxSequenceName) {
                    maxSequenceName = ((Sequence)alignmentSequences.get(i2)).getSpecies().length();
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < alignmentSequences.size()) {
                currentSequence = (Sequence)alignmentSequences.get(i2);
                alignment.append(currentSequence.getSpecies());
                int difference = maxSequenceName - currentSequence.getSpecies().length() + 1;
                int j = 0;
                while (j < difference) {
                    alignment.append(" ");
                    ++j;
                }
                alignment.append(String.valueOf(currentSequence.getEntireSequence()) + "\n");
                ++i2;
            }
        }
        this.currentSelectedCell.setText(listOfSequences);
        this.currentSelectedCell.setBackground(this.getBackground());
        this.alignmentWindow.updateText(alignment.toString());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.quitMenuItem) {
            System.exit(0);
        }
        if (e.getSource() == this.aboutMenuItem) {
            GlobalGUIData.displayAboutDialog();
        }
        if (e.getSource() == this.copyItem) {
            this.copySelectedText();
        }
        if (e.getSource() == this.showAlignmentJButton) {
            this.openAlignmentWindow();
        }
    }

    public void openAlignmentWindow() {
        this.alignmentWindow.setDefaultCloseOperation(1);
        this.alignmentWindow.setVisible(true);
        this.setSelectedAminoAcid(this.getSelectedRow(), this.getSelectedColumn());
    }

    public void copySelectedText() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(this.currentSelectedCell.getText()), this);
    }

    public void setGrid(GridData nGridData) {
        this.gridData = nGridData;
    }

    public void setDisplayedSequences(boolean nResiduePresent) {
        this.residuePresent = nResiduePresent;
    }

    public int getSelectedRow() {
        return this.row;
    }

    public int getSelectedColumn() {
        return this.column;
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

