/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.gui.jframes.frequencycolors;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jprofilegrid.data.GlobalData;
import jprofilegrid.data.profilegrid.ConservationRange;
import jprofilegrid.gui.GlobalGUIData;
import jprofilegrid.gui.color.ColorComboBoxRenderer;
import jxl.format.Colour;
import jxl.format.RGB;

public class FrequencyColorsJFrame
extends JFrame
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = -9206173067242992333L;
    private JComboBox numberOfThresholds = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5, 6});
    private GridBagLayout mainLayout = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private Vector<JTextField> thresholdValues = new Vector();
    private Vector<JComboBox> colorBoxes = new Vector();
    private MenuBar menuBar = new MenuBar();
    private Menu fileMenu = new Menu("File");
    private Menu aboutMenu = new Menu("About");
    private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
    private MenuItem quitMenuItem = new MenuItem("Quit");
    boolean loading = true;

    public FrequencyColorsJFrame() {
        this.setTitle("Frequency Colors");
        this.addWindowListener(GlobalGUIData.globalGUIData);
        this.setLayout(this.mainLayout);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.initializeMenuBar();
        this.initializeNumberOfThresholdsBlank();
        this.initializeColorBlanks();
        this.setResizable(false);
        this.loading = false;
        this.pack();
    }

    private void initializeMenuBar() {
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(GlobalGUIData.frequencyColorsOpenWindowsMenu);
        this.menuBar.add(this.aboutMenu);
        this.quitMenuItem.addActionListener(this);
        this.aboutMenu.add(this.aboutMenuItem);
        this.aboutMenuItem.addActionListener(this);
        this.fileMenu.add(this.quitMenuItem);
        this.setMenuBar(this.menuBar);
    }

    private void initializeNumberOfThresholdsBlank() {
        this.constraints.gridwidth = 2;
        JPanel thresholdNumPanel = new JPanel(new FlowLayout());
        thresholdNumPanel.add(new JLabel("Number of Bins:"));
        this.numberOfThresholds.setSelectedIndex(ConservationRange.DEFAULT_CONSERVATION_RANGE_COLORS.length - 1);
        this.numberOfThresholds.addActionListener(this);
        thresholdNumPanel.add(this.numberOfThresholds);
        this.add((Component)thresholdNumPanel, this.constraints);
    }

    private void initializeColorBlanks() {
        this.constraints.gridwidth = 1;
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.initializeLayout();
        this.initializeLabels();
        int i = 0;
        while (i < ConservationRange.DEFAULT_CONSERVATION_RANGE_COLORS.length) {
            this.addRange(ConservationRange.DEFAULT_CONSERVATION_RANGES[i], ConservationRange.DEFAULT_CONSERVATION_RANGE_COLORS[i]);
            ++i;
        }
        this.addKeyListeners();
        this.addActionListeners();
    }

    private void initializeLayout() {
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.anchor = 10;
    }

    private void initializeLabels() {
        this.add((Component)new JLabel("Threshold:"), this.constraints);
        ++this.constraints.gridx;
        this.add((Component)new JLabel("Color:"), this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
    }

    private void addRange(Double value, Colour colour) {
        this.thresholdValues.add(new JTextField(String.valueOf(value), 5));
        this.add((Component)this.thresholdValues.get(this.thresholdValues.size() - 1), this.constraints);
        ++this.constraints.gridx;
        this.colorBoxes.add(new JComboBox<Colour>(GlobalGUIData.SORTED_COLOURS));
        this.colorBoxes.get(this.colorBoxes.size() - 1).setRenderer(new ColorComboBoxRenderer());
        this.colorBoxes.get(this.colorBoxes.size() - 1).setSelectedIndex(GlobalGUIData.getColorIndexWithName(colour.getDescription()));
        this.add((Component)this.colorBoxes.get(this.colorBoxes.size() - 1), this.constraints);
        this.constraints.gridx = 0;
        ++this.constraints.gridy;
    }

    private void addKeyListeners() {
        int i = 0;
        while (i < this.thresholdValues.size()) {
            this.thresholdValues.get(i).addKeyListener(this);
            ++i;
        }
    }

    private void addActionListeners() {
        int i = 0;
        while (i < this.colorBoxes.size()) {
            this.colorBoxes.get(i).addActionListener(this);
            this.colorBoxes.get(i).setSelectedIndex(this.colorBoxes.get(i).getSelectedIndex());
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.numberOfThresholds) {
            this.updateActiveBins();
            return;
        }
        if (e.getSource() == this.quitMenuItem) {
            System.exit(0);
        }
        if (e.getSource() == this.aboutMenuItem) {
            GlobalGUIData.displayAboutDialog();
            return;
        }
        int i = 0;
        while (i < this.colorBoxes.size()) {
            if (e.getSource() == this.colorBoxes.get(i)) {
                this.updateColors(i);
                return;
            }
            ++i;
        }
    }

    public void updateActiveBins() {
        int i = (Integer)this.numberOfThresholds.getSelectedItem();
        while (i > 0) {
            this.thresholdValues.get(i - 1).setEnabled(true);
            this.colorBoxes.get(i - 1).setEnabled(true);
            --i;
        }
        i = (Integer)this.numberOfThresholds.getSelectedItem();
        while (i < this.thresholdValues.size()) {
            this.thresholdValues.get(i).setEnabled(false);
            this.colorBoxes.get(i).setEnabled(false);
            ++i;
        }
        if (!this.loading && GlobalData.gridData != null) {
            this.updateProfileGrid();
            return;
        }
    }

    public void updateProfileGrid() {
        ConservationRange cRange = new ConservationRange();
        int i = 0;
        while (i < this.thresholdValues.size()) {
            try {
                if (this.thresholdValues.get(i).isEnabled()) {
                    cRange.addConservationRange(Double.parseDouble(this.thresholdValues.get(i).getText()), (Colour)this.colorBoxes.get(i).getSelectedItem());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        GlobalData.gridData.setConservationRange(cRange);
        GlobalGUIData.globalGUIData.updateProfileGridFrame();
    }

    private void updateColors(int index) {
        RGB currentColor = GlobalGUIData.SORTED_COLOURS[this.colorBoxes.get(index).getSelectedIndex()].getDefaultRGB();
        this.colorBoxes.get(index).setForeground(new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue()));
        if (!this.loading && GlobalData.gridData != null) {
            this.updateProfileGrid();
            return;
        }
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent e) {
        if (!this.loading) {
            int i = 0;
            while (i < this.thresholdValues.size()) {
                if (e.getSource() == this.thresholdValues.get(i)) {
                    this.updateProfileGrid();
                }
                ++i;
            }
        }
    }

    public void keyTyped(KeyEvent arg0) {
    }
}

