/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.gui.jframes.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import jprofilegrid.data.GlobalData;
import jprofilegrid.gui.GlobalGUIData;

public class ExportJPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8154981749436394738L;
    private JLabel columnsPerTierLabel = new JLabel("Columns Per Tier:");
    private JLabel formatLabel = new JLabel("Format:");
    private JButton outputFileBrowseButton = new JButton("Browse");
    private JTextField columnsPerTierBlank = new JTextField(String.valueOf(50), 4);
    private JTextField outputFileBlank = new JTextField(1);
    private JButton exportButton = new JButton("Export");
    private JLabel rangeJLabel = new JLabel("  Range:");
    private JTextField startOfRange = new JTextField(4);
    private JTextField endOfRange = new JTextField(4);
    private JLabel toLabel = new JLabel("to");
    private JComboBox fileTypeSelection = new JComboBox<String>(new String[]{"Excel", "PyMOL"});
    private JPanel columnsSelectionPanel = new JPanel();

    public void initializeExportPanel() {
        LineBorder border = new LineBorder(new Color(9, 0, 128), 1);
        TitledBorder exportPanelBorder = BorderFactory.createTitledBorder(border, "Export");
        exportPanelBorder.setTitleColor(new Color(0, 0, 0));
        this.setBorder(exportPanelBorder);
        GridBagLayout exportPanelLayout = new GridBagLayout();
        GridBagConstraints exportPanelConstraints = new GridBagConstraints();
        this.setLayout(exportPanelLayout);
        exportPanelConstraints.fill = 2;
        exportPanelConstraints.gridx = 0;
        exportPanelConstraints.gridy = 0;
        exportPanelConstraints.weightx = 0.0;
        exportPanelConstraints.gridwidth = 1;
        this.outputFileBrowseButton.addActionListener(this);
        this.add((Component)this.outputFileBrowseButton, exportPanelConstraints);
        exportPanelConstraints.gridx = 1;
        exportPanelConstraints.gridy = 0;
        exportPanelConstraints.weightx = 1.0;
        exportPanelConstraints.gridwidth = 8;
        this.add((Component)this.outputFileBlank, exportPanelConstraints);
        exportPanelConstraints.fill = 0;
        exportPanelConstraints.gridx = 0;
        exportPanelConstraints.gridy = 1;
        exportPanelConstraints.weightx = 0.0;
        exportPanelConstraints.gridwidth = 1;
        this.add((Component)this.formatLabel, exportPanelConstraints);
        exportPanelConstraints.gridx = 1;
        exportPanelConstraints.gridy = 1;
        exportPanelConstraints.weightx = 0.0;
        exportPanelConstraints.gridwidth = 3;
        exportPanelConstraints.anchor = 21;
        this.add((Component)this.fileTypeSelection, exportPanelConstraints);
        exportPanelConstraints.gridx = 4;
        exportPanelConstraints.gridwidth = 4;
        this.columnsSelectionPanel.setLayout(new GridBagLayout());
        GridBagConstraints columnSelectionConstraints = new GridBagConstraints();
        columnSelectionConstraints.weightx = 0.0;
        columnSelectionConstraints.weighty = 0.0;
        columnSelectionConstraints.gridx = 2;
        columnSelectionConstraints.gridy = 0;
        columnSelectionConstraints.fill = 1;
        columnSelectionConstraints.anchor = 21;
        columnSelectionConstraints.gridwidth = 1;
        columnSelectionConstraints.gridheight = 1;
        exportPanelConstraints.gridx = 4;
        exportPanelConstraints.gridy = 1;
        exportPanelConstraints.weightx = 0.0;
        exportPanelConstraints.gridwidth = 5;
        exportPanelConstraints.gridheight = 2;
        exportPanelConstraints.ipadx = 0;
        exportPanelConstraints.anchor = 21;
        this.columnsSelectionPanel.add((Component)this.rangeJLabel, columnSelectionConstraints);
        exportPanelConstraints.gridx = 4;
        exportPanelConstraints.gridy = 1;
        exportPanelConstraints.weightx = 0.0;
        exportPanelConstraints.gridwidth = 5;
        exportPanelConstraints.gridheight = 2;
        exportPanelConstraints.ipadx = 0;
        exportPanelConstraints.anchor = 21;
        this.startOfRange.setText(String.valueOf(1));
        ++columnSelectionConstraints.gridx;
        columnSelectionConstraints.weightx = 1.0;
        this.columnsSelectionPanel.add((Component)this.startOfRange, columnSelectionConstraints);
        exportPanelConstraints.gridx = 3;
        exportPanelConstraints.gridy = 1;
        exportPanelConstraints.weightx = 0.0;
        exportPanelConstraints.gridwidth = 5;
        exportPanelConstraints.gridheight = 2;
        exportPanelConstraints.ipadx = 0;
        exportPanelConstraints.anchor = 21;
        ++columnSelectionConstraints.gridx;
        columnSelectionConstraints.weightx = 0.0;
        this.columnsSelectionPanel.add((Component)this.toLabel, columnSelectionConstraints);
        exportPanelConstraints.gridx = 4;
        exportPanelConstraints.gridy = 1;
        exportPanelConstraints.weightx = 0.0;
        exportPanelConstraints.gridwidth = 5;
        exportPanelConstraints.gridheight = 2;
        exportPanelConstraints.ipadx = 0;
        exportPanelConstraints.anchor = 21;
        columnSelectionConstraints.gridx += 5;
        columnSelectionConstraints.weightx = 1.0;
        this.columnsSelectionPanel.add((Component)this.endOfRange, columnSelectionConstraints);
        this.add((Component)this.columnsSelectionPanel, exportPanelConstraints);
        exportPanelConstraints.gridx = 0;
        exportPanelConstraints.gridy = 2;
        exportPanelConstraints.weightx = 0.0;
        exportPanelConstraints.gridwidth = 2;
        this.add((Component)this.columnsPerTierLabel, exportPanelConstraints);
        columnSelectionConstraints.fill = 2;
        exportPanelConstraints.gridx = 2;
        exportPanelConstraints.gridy = 2;
        exportPanelConstraints.weightx = 10.0;
        exportPanelConstraints.gridwidth = 20;
        exportPanelConstraints.anchor = 21;
        this.add((Component)this.columnsPerTierBlank, exportPanelConstraints);
        exportPanelConstraints.weightx = 1.0;
        exportPanelConstraints.gridx = 4;
        exportPanelConstraints.gridy = 2;
        exportPanelConstraints.weightx = 0.0;
        exportPanelConstraints.gridwidth = 5;
        exportPanelConstraints.gridheight = 2;
        exportPanelConstraints.ipadx = 0;
        exportPanelConstraints.anchor = 22;
        this.add((Component)this.exportButton, exportPanelConstraints);
        this.exportButton.addActionListener(this);
        this.exportButton.setEnabled(false);
        GlobalGUIData.disableAllComponents(this.columnsSelectionPanel);
        this.fileTypeSelection.addActionListener(this);
    }

    public int getColumnsPerTier() {
        try {
            return Integer.parseInt(this.columnsPerTierBlank.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getFirstColumn() {
        try {
            return Integer.parseInt(this.startOfRange.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void setStartColumn(int nStartColumn) {
        this.startOfRange.setText(String.valueOf(nStartColumn));
    }

    public void setFinalColumn(int nFinalColumn) {
        this.endOfRange.setText(String.valueOf(nFinalColumn));
    }

    public int getLastColumn() {
        try {
            return Integer.parseInt(this.endOfRange.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getOutputFilename() {
        return this.outputFileBlank.getText();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.exportButton) {
            if (this.fileTypeSelection.getSelectedIndex() == 0) {
                this.outputExcelFile();
            }
            if (this.fileTypeSelection.getSelectedIndex() == 1) {
                this.outputPyMOLScript();
            }
        }
        if (e.getSource() == this.outputFileBrowseButton) {
            GlobalGUIData.globalGUIData.browseForOutputFile();
        }
        if (e.getSource() == this.fileTypeSelection) {
            if (this.fileTypeSelection.getSelectedIndex() == 0) {
                this.outputFileBlank.setText(String.valueOf(this.outputFileBlank.getText().substring(0, this.outputFileBlank.getText().length() - 3)) + "xls");
                this.columnsPerTierLabel.setEnabled(true);
                this.columnsPerTierBlank.setEnabled(true);
            }
            if (this.fileTypeSelection.getSelectedIndex() == 1) {
                this.outputFileBlank.setText(String.valueOf(this.outputFileBlank.getText().substring(0, this.outputFileBlank.getText().length() - 3)) + "pml");
                this.columnsPerTierLabel.setEnabled(false);
                this.columnsPerTierBlank.setEnabled(false);
            }
        }
    }

    public void setOutputFileType(int index) {
        this.fileTypeSelection.setSelectedIndex(index);
    }

    public JPanel getColumnsSelectionPanel() {
        return this.columnsSelectionPanel;
    }

    private void setOutputData() {
        try {
            if (this.getFirstColumn() > 0) {
                GlobalData.gridData.setFirstColumn(this.getFirstColumn());
            }
            if (this.getLastColumn() > 0) {
                GlobalData.gridData.setLastColumn(this.getLastColumn());
            }
            GlobalData.gridData.updateOutputFile(this.getOutputFilename());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void outputExcelFile() {
        try {
            if (this.getColumnsPerTier() > 0) {
                GlobalData.gridData.setColumnsPerTier(this.getColumnsPerTier());
            }
            this.setOutputData();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        GlobalData.gridData.outputExcelFile();
    }

    private void outputPyMOLScript() {
        this.setOutputData();
        GlobalData.gridData.outputPyMOLScript();
    }

    public void setOutputFilename(String nFilename) {
        this.outputFileBlank.setText(nFilename);
    }

    public JTextField getOutputFileBlank() {
        return this.outputFileBlank;
    }
}

