/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.gui.jframes.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import jprofilegrid.data.GlobalData;
import jprofilegrid.gui.GlobalGUIData;
import jprofilegrid.gui.GridBagConstraintsInitializer;
import jprofilegrid.gui.color.ColorComboBoxRenderer;
import jxl.format.Colour;
import jxl.format.RGB;

public class GridParametersJPanel
extends JPanel
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 4477656123215277926L;
    private static final int SHOW_VALUES_DISABLED = 2;
    private GridBagConstraints constraints = new GridBagConstraints();
    private GridBagLayout anaylzePanelOptionsAreaLayout = new GridBagLayout();
    private Border border = new LineBorder(new Color(0, 100, 0), 1);
    private TitledBorder analyzePanelBorder = BorderFactory.createTitledBorder(this.border, "Grid Parameters");
    private JTextField startAtBlank = new JTextField(String.valueOf(1), 5);
    private JComboBox sortTypeBlank = new JComboBox<String>(new String[]{"Load Alignment"});
    private JComboBox templateSequenceBlank = new JComboBox<String>(new String[]{"Load Alignment"});
    private JComboBox highlightSequenceBlank = new JComboBox<String>(new String[]{"Load Alignment"});
    private JComboBox highlightSequenceColor = new JComboBox<Colour>(GlobalGUIData.SORTED_COLOURS);
    private JComboBox integerOrPercentage = new JComboBox<String>(new String[]{"Integer", "Percentage"});
    private JComboBox identifySeqIfResIsAbsOrPres = new JComboBox<String>(new String[]{"Present", "Absent"});
    private JTextArea identifySeqLabel = new JTextArea("Identify sequences where\nselected residue is:");
    private JCheckBox frequencyColorsJCheckBox = new JCheckBox();
    private JCheckBox ascendingJCheckBox = new JCheckBox();
    private JCheckBox skipGapsJCheckBox = new JCheckBox();
    private JCheckBox showValuesJCheckBox = new JCheckBox();
    private JButton frequencyColorsButton = new JButton("Frequency Colors");
    private JButton identifySequencesButton = new JButton("Sequences");
    private JLabel templateSequenceLabel = new JLabel("Template Sequence:");
    private JLabel positionRulerLabel = new JLabel("Position Ruler:");
    private JLabel skipGapsLabel = new JLabel("Skip Gaps");
    private JLabel startAtLabel = new JLabel("Start At");
    private JLabel sortAscendingAndTypeLabel = new JLabel("Sort Ascending/Type:");
    private JLabel enableFrequencyColorsLabel = new JLabel("Enable Frequency Colors:");
    private JLabel showValuesLabel = new JLabel("Show Values:");
    private JLabel highlightSequenceLabel = new JLabel("Highlight Sequence:");
    private JLabel comparisonColorLabel = new JLabel("Highlight Color:");
    private JPanel positionRulerJPanel = new JPanel(new GridBagLayout());

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.integerOrPercentage) {
            this.switchIntegerOrPercentage();
        }
        if (e.getSource() == this.showValuesJCheckBox) {
            this.switchIntegerOrPercentage();
        }
        if (e.getSource() == this.templateSequenceBlank) {
            this.updateTemplateSequence();
        }
        if (e.getSource() == this.highlightSequenceColor) {
            this.updateSequenceColor();
        }
        if (e.getSource() == this.highlightSequenceBlank) {
            this.updateHighlightSequence();
        }
        if (e.getSource() == this.sortTypeBlank) {
            this.updateSortType();
        }
        if (e.getSource() == this.ascendingJCheckBox) {
            this.updateAscendingOption();
        }
        if (e.getSource() == this.skipGapsJCheckBox) {
            this.updateSkipGapsOption();
        }
        if (e.getSource() == this.frequencyColorsJCheckBox) {
            this.changeFrequencyColorsDisplayedOption();
        }
        if (e.getSource() == this.frequencyColorsButton) {
            GlobalGUIData.globalGUIData.openFrequencyColorsSelectionDialog();
        }
        if (e.getSource() == this.identifySequencesButton) {
            GlobalGUIData.globalGUIData.openIdentifySequencesDialog();
        }
        if (e.getSource() == this.identifySeqIfResIsAbsOrPres) {
            GlobalGUIData.globalGUIData.updateDisplayedSequences();
        }
    }

    public void initializeAnalyzePanel() {
        this.analyzePanelBorder.setTitleColor(new Color(0, 0, 0));
        this.setBorder(this.analyzePanelBorder);
        this.setLayout(this.anaylzePanelOptionsAreaLayout);
        this.highlightSequenceColor.setRenderer(new ColorComboBoxRenderer());
        this.addListeners();
        this.highlightSequenceColor.setSelectedItem(Colour.OCEAN_BLUE);
        this.identifySeqLabel.setBackground(this.getBackground());
        this.identifySeqLabel.setEditable(false);
        this.identifySeqLabel.setFont(this.templateSequenceLabel.getFont());
        this.skipGapsJCheckBox.setSelected(true);
        this.frequencyColorsJCheckBox.setSelected(true);
        this.ascendingJCheckBox.setSelected(true);
        this.showValuesJCheckBox.setSelected(true);
        this.initializeLabels();
        GridBagConstraintsInitializer.resetConstraints(this.constraints);
        this.constraints.anchor = 21;
        this.constraints.gridx = 1;
        this.constraints.gridy = 1;
        this.constraints.gridwidth = 10;
        this.add((Component)this.templateSequenceBlank, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 0;
        this.initializePositionRulerJPanel();
        this.add((Component)this.positionRulerJPanel, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridwidth = 6;
        this.constraints.gridy = 3;
        this.add((Component)this.highlightSequenceBlank, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.highlightSequenceColor, this.constraints);
        ++this.constraints.gridy;
        this.constraints.gridx = 1;
        this.constraints.gridwidth = 1;
        this.constraints.weightx = 0.0;
        this.add((Component)this.ascendingJCheckBox, this.constraints);
        this.constraints.gridx = 2;
        this.constraints.gridwidth = 4;
        this.add((Component)this.sortTypeBlank, this.constraints);
        ++this.constraints.gridy;
        this.constraints.gridx = 1;
        this.constraints.gridwidth = 1;
        this.add((Component)this.frequencyColorsJCheckBox, this.constraints);
        this.constraints.gridx = 2;
        this.constraints.gridwidth = 4;
        this.add((Component)this.frequencyColorsButton, this.constraints);
        ++this.constraints.gridy;
        this.constraints.gridx = 1;
        this.constraints.gridwidth = 1;
        this.add((Component)this.showValuesJCheckBox, this.constraints);
        ++this.constraints.gridx;
        this.constraints.gridwidth = 4;
        this.add((Component)this.integerOrPercentage, this.constraints);
        ++this.constraints.gridy;
        this.constraints.gridx = 1;
        this.constraints.gridwidth = 2;
        this.add((Component)this.identifySeqIfResIsAbsOrPres, this.constraints);
        this.constraints.gridx += 2;
        this.constraints.gridwidth = 2;
        this.constraints.anchor = 21;
        this.add((Component)this.identifySequencesButton, this.constraints);
    }

    private void initializeLabels() {
        GridBagConstraintsInitializer.resetConstraints(this.constraints);
        this.constraints.anchor = 22;
        this.add((Component)this.positionRulerLabel, this.constraints);
        ++this.constraints.gridy;
        this.constraints.gridheight = 2;
        this.add((Component)this.templateSequenceLabel, this.constraints);
        this.constraints.gridy += 2;
        this.constraints.gridheight = 1;
        this.add((Component)this.highlightSequenceLabel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.comparisonColorLabel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.sortAscendingAndTypeLabel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.enableFrequencyColorsLabel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.showValuesLabel, this.constraints);
        ++this.constraints.gridy;
        this.constraints.gridheight = 2;
        this.add((Component)this.identifySeqLabel, this.constraints);
    }

    private void initializePositionRulerJPanel() {
        GridBagConstraints positionRulerJPanelConstraints = new GridBagConstraints();
        GridBagConstraintsInitializer.resetConstraints(positionRulerJPanelConstraints);
        positionRulerJPanelConstraints.ipadx = 5;
        this.positionRulerJPanel.add((Component)this.skipGapsLabel, positionRulerJPanelConstraints);
        ++positionRulerJPanelConstraints.gridx;
        this.positionRulerJPanel.add((Component)this.startAtLabel, positionRulerJPanelConstraints);
        ++positionRulerJPanelConstraints.gridy;
        positionRulerJPanelConstraints.fill = 2;
        this.positionRulerJPanel.add((Component)this.startAtBlank, positionRulerJPanelConstraints);
        --positionRulerJPanelConstraints.gridx;
        positionRulerJPanelConstraints.fill = 0;
        this.positionRulerJPanel.add((Component)this.skipGapsJCheckBox, positionRulerJPanelConstraints);
    }

    private void addListeners() {
        this.startAtBlank.addKeyListener(this);
        this.skipGapsJCheckBox.addActionListener(this);
        this.ascendingJCheckBox.addActionListener(this);
        this.sortTypeBlank.addActionListener(this);
        this.templateSequenceBlank.addActionListener(this);
        this.highlightSequenceBlank.addActionListener(this);
        this.integerOrPercentage.addActionListener(this);
        this.showValuesJCheckBox.addActionListener(this);
        this.identifySeqIfResIsAbsOrPres.addActionListener(this);
        this.frequencyColorsButton.addActionListener(this);
        this.frequencyColorsJCheckBox.addActionListener(this);
        this.identifySequencesButton.addActionListener(this);
        this.highlightSequenceColor.addActionListener(this);
    }

    public void switchIntegerOrPercentage() {
        GlobalData.analysisOptions.setShowValuesAs(this.showValueAs());
        GlobalGUIData.globalGUIData.updateProfileGridFrame();
    }

    public void updateSkipGapsOption() {
        GlobalData.analysisOptions.setSkipGaps(this.skipGapsEnabled());
        GlobalGUIData.globalGUIData.updateProfileGridFrame();
    }

    public void updateAscendingOption() {
        GlobalData.analysisOptions.setSortAscending(this.isAscendingSort());
        GlobalGUIData.globalGUIData.updateProfileGridFrame();
    }

    public void changeFrequencyColorsDisplayedOption() {
        if (this.frequencyColorsEnabled()) {
            GlobalData.gridData.enableFrequencyColors();
            this.enableFrequencyColorsButton();
        } else {
            GlobalData.gridData.disableFrequencyColors();
            this.disableFrequencyColorsButton();
        }
        GlobalGUIData.globalGUIData.updateProfileGridFrame();
    }

    public void updateSortType() {
        GlobalData.analysisOptions.setSortType(this.getSortType());
        GlobalGUIData.globalGUIData.updateProfileGridFrame();
    }

    public void updateTemplateSequence() {
        GlobalData.analysisOptions.setTemplateSequence(GlobalData.gridData.getMultipleSequenceAlignment().getSequence(this.getPositionSequence()));
        this.updateSequenceColor();
    }

    public void updateHighlightSequence() {
        GlobalData.analysisOptions.setHighlightSequence(GlobalData.gridData.getMultipleSequenceAlignment().getSequence(this.getHighlightSequence()));
        this.updateSequenceColor();
    }

    public void updateSequenceColor() {
        RGB currentColor = GlobalGUIData.SORTED_COLOURS[this.getHighlightSequenceColor()].getDefaultRGB();
        this.setHighlightSequenceColor(new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue()));
        GlobalData.analysisOptions.setHighlightSequenceColour(GlobalGUIData.SORTED_COLOURS[this.getHighlightSequenceColor()]);
        if (GlobalData.gridData != null) {
            GlobalGUIData.globalGUIData.updateProfileGridFrame();
        }
    }

    public boolean skipGapsEnabled() {
        return this.skipGapsJCheckBox.isSelected();
    }

    public boolean isAscendingSort() {
        return this.ascendingJCheckBox.isSelected();
    }

    public int getSortType() {
        return this.sortTypeBlank.getSelectedIndex();
    }

    public int getPositionSequence() {
        return this.templateSequenceBlank.getSelectedIndex();
    }

    public int getPositionStart() {
        return Integer.parseInt(this.startAtBlank.getText());
    }

    public boolean frequencyColorsEnabled() {
        return this.frequencyColorsJCheckBox.isSelected();
    }

    public int getHighlightSequence() {
        return this.highlightSequenceBlank.getSelectedIndex();
    }

    public int getHighlightSequenceColor() {
        return this.highlightSequenceColor.getSelectedIndex();
    }

    public int showValueAs() {
        if (this.showValuesJCheckBox.isSelected()) {
            this.integerOrPercentage.setEnabled(true);
            return this.integerOrPercentage.getSelectedIndex();
        }
        this.integerOrPercentage.setEnabled(false);
        return 2;
    }

    public boolean getDisplayedResidueIfPresent() {
        return this.identifySeqIfResIsAbsOrPres.getSelectedIndex() == 0;
    }

    public void clearHighlightSequence() {
        this.highlightSequenceBlank.removeActionListener(this);
        this.highlightSequenceBlank.removeAllItems();
        this.highlightSequenceBlank.addActionListener(this);
    }

    public void clearPositionSequence() {
        this.templateSequenceBlank.removeActionListener(this);
        this.templateSequenceBlank.removeAllItems();
        this.templateSequenceBlank.addActionListener(this);
    }

    public void clearSortTypeBlank() {
        this.sortTypeBlank.removeActionListener(this);
        this.sortTypeBlank.removeAllItems();
        this.sortTypeBlank.addActionListener(this);
    }

    public void addToHighlightSequence(String species) {
        this.highlightSequenceBlank.removeActionListener(this);
        this.highlightSequenceBlank.addItem(species);
        this.highlightSequenceBlank.addActionListener(this);
    }

    public void addToTemplateSequence(String species) {
        this.templateSequenceBlank.removeActionListener(this);
        this.templateSequenceBlank.addItem(species);
        this.templateSequenceBlank.addActionListener(this);
    }

    public void setSortTypeBlank(String[] data) {
        this.sortTypeBlank.removeActionListener(this);
        int i = 0;
        while (i < data.length) {
            this.sortTypeBlank.addItem(data[i]);
            ++i;
        }
        this.sortTypeBlank.addActionListener(this);
    }

    public void setHighlightSequenceColor(Color nColor) {
        this.highlightSequenceColor.setForeground(nColor);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.startAtBlank) {
            this.updatePositionStart();
        }
    }

    public void updatePositionStart() {
        try {
            GlobalData.analysisOptions.setPositionRowStart(this.getPositionStart());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        GlobalGUIData.globalGUIData.updateProfileGridFrame();
    }

    public void enableFrequencyColorsButton() {
        this.frequencyColorsButton.setEnabled(true);
    }

    public void disableFrequencyColorsButton() {
        this.frequencyColorsButton.setEnabled(false);
    }

    public void keyTyped(KeyEvent e) {
    }

    public JPanel getPositionRulerJPanel() {
        return this.positionRulerJPanel;
    }
}

