/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.gui.jframes.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import jprofilegrid.data.GlobalData;
import jprofilegrid.gui.GlobalGUIData;

public class SimilarityParametersJPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -8577716065919949185L;
    private EnableSimilaritiesJPanel enableSimilaritiesJPanel = new EnableSimilaritiesJPanel();
    private JTextField windowSizeBlank = new JTextField(String.valueOf(5));
    private JTextField thresholdBlank = new JTextField(String.valueOf(0.7));
    private JComponent[] parameterBlanks = new JComponent[]{this.windowSizeBlank, this.thresholdBlank};
    private JLabel[] parameterLabels = new JLabel[]{new JLabel("Window Size:"), new JLabel("Threshold:")};
    private String computeProfileGridString = new String("Compute");
    private String optionsPanelTitle = new String("Similarity Parameters");
    private JButton computeProfileGridButton = new JButton(this.computeProfileGridString);

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.computeProfileGridButton) {
            GlobalGUIData.globalGUIData.computeProfileGrid();
        }
    }

    public void setSimilarityComputationButtonRed() {
        this.computeProfileGridButton.setEnabled(false);
        this.computeProfileGridButton.setText("Computing");
    }

    public boolean currentlyComputing() {
        return this.computeProfileGridButton.getText().equalsIgnoreCase("Computing");
    }

    public void setSimilarityComputationButtonDone() {
        this.computeProfileGridButton.setEnabled(true);
        this.computeProfileGridButton.setText("Compute");
    }

    public int getWindowSize() {
        return Integer.parseInt(this.windowSizeBlank.getText());
    }

    public Double getThreshold() {
        return Double.parseDouble(this.thresholdBlank.getText());
    }

    public boolean similarityParametersEnabled() {
        return this.enableSimilaritiesJPanel.similarityParametersEnabled();
    }

    public EnableSimilaritiesJPanel getEnabledSimilaritiesJPanel() {
        return this.enableSimilaritiesJPanel;
    }

    public void initializeParametersPanel() {
        this.setLayout(new GridBagLayout());
        LineBorder border = new LineBorder(new Color(218, 165, 32), 1);
        TitledBorder optionsPanelBorder = BorderFactory.createTitledBorder(border, this.optionsPanelTitle);
        optionsPanelBorder.setTitleColor(new Color(0, 0, 0));
        this.setBorder(optionsPanelBorder);
        GridBagConstraints constraints = new GridBagConstraints();
        this.computeProfileGridButton.addActionListener(this);
        this.computeProfileGridButton.setEnabled(false);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 5;
        constraints.anchor = 10;
        this.add((Component)this.enableSimilaritiesJPanel, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.anchor = 10;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.fill = 2;
        this.add((Component)this.parameterLabels[0], constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        this.add((Component)this.parameterBlanks[0], constraints);
        ++constraints.gridx;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        this.add((Component)this.parameterLabels[1], constraints);
        ++constraints.gridx;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        this.add((Component)this.parameterBlanks[1], constraints);
        ++constraints.gridx;
        constraints.weightx = 0.0;
        this.add((Component)this.computeProfileGridButton, constraints);
        GlobalGUIData.disableAllComponents(this.enableSimilaritiesJPanel);
    }

    public void enableProfileGridButton() {
        this.computeProfileGridButton.setEnabled(true);
    }

    public void disableProfileGridButton() {
        this.computeProfileGridButton.setEnabled(false);
    }

    private class EnableSimilaritiesJPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 6235369997098867396L;
        private JLabel enableSimilarityParametersJLabel = new JLabel("Enable Similarity Parameters:");
        private JCheckBox enableSimilarityParametersJCheckBox = new JCheckBox();

        public EnableSimilaritiesJPanel() {
            this.initializeComponents();
        }

        private void initializeComponents() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridy = 0;
            constraints.gridx = 0;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            this.add((Component)this.enableSimilarityParametersJLabel, constraints);
            ++constraints.gridx;
            this.add((Component)this.enableSimilarityParametersJCheckBox, constraints);
            this.enableSimilarityParametersJCheckBox.addActionListener(this);
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.enableSimilarityParametersJCheckBox) {
                this.switchSimilarityParametersEnabled();
            }
        }

        public boolean similarityParametersEnabled() {
            return this.enableSimilarityParametersJCheckBox.isSelected();
        }

        private void switchSimilarityParametersEnabled() {
            if (this.enableSimilarityParametersJCheckBox.isSelected()) {
                GlobalGUIData.enableAllComponents(this.getParent());
            } else {
                GlobalGUIData.disableAllComponents(this.getParent());
            }
            GlobalData.analysisOptions.setSimilarityParametersEnabled(this.enableSimilarityParametersJCheckBox.isSelected());
            GlobalGUIData.globalGUIData.updateProfileGridFrame();
        }
    }
}

