/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.gui.jframes.profilegrid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import jprofilegrid.data.profilegrid.Cell;
import jprofilegrid.data.profilegrid.Text;
import jprofilegrid.file.writers.excel.ProfileGridFormatToExcelFormatConverter;
import jxl.format.Border;
import jxl.format.RGB;
import jxl.write.WritableCellFormat;

public class FixedAAColumnInTable
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -3483011388216552532L;
    public static int BORDER_THICKNESS = 2;
    Component cell;
    Object value;
    WritableCellFormat cellFormat;

    public Component getTableCellRendererComponent(JTable table, Object nValue, boolean isSelected, boolean hasFocus, int row, int column) {
        this.cell = super.getTableCellRendererComponent(table, this.value, isSelected, hasFocus, row, column);
        this.value = nValue;
        this.cellFormat = ProfileGridFormatToExcelFormatConverter.extractWritableCellFormat((Cell)this.value);
        this.setText(((Text)nValue).getValue() == null ? "" : ((Text)nValue).getValue());
        this.setFont(new Font("Times New Roman", 1, 12));
        this.setAlignmentX(0.5f);
        if (this.cellFormat.hasBorders()) {
            this.setBorders();
        } else {
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }
        super.setHorizontalAlignment(0);
        return this;
    }

    private void setBorders() {
        if (this.cellFormat.hasBorders()) {
            RGB topBorderColor = this.cellFormat.getBorderColour(Border.TOP).getDefaultRGB();
            Color topColor = topBorderColor.getRed() == 255 && topBorderColor.getBlue() == 255 && topBorderColor.getGreen() == 255 ? this.cell.getBackground() : new Color(topBorderColor.getRed(), topBorderColor.getGreen(), topBorderColor.getBlue());
            MatteBorder top = BorderFactory.createMatteBorder(BORDER_THICKNESS, 0, 0, 0, topColor);
            RGB bottomBorderColor = this.cellFormat.getBorderColour(Border.BOTTOM).getDefaultRGB();
            Color bottomColor = bottomBorderColor.getRed() == 255 && bottomBorderColor.getBlue() == 255 && bottomBorderColor.getGreen() == 255 ? this.cell.getBackground() : new Color(bottomBorderColor.getRed(), bottomBorderColor.getGreen(), bottomBorderColor.getBlue());
            MatteBorder bottom = BorderFactory.createMatteBorder(0, 0, BORDER_THICKNESS, 0, bottomColor);
            RGB leftBorderColor = this.cellFormat.getBorderColour(Border.LEFT).getDefaultRGB();
            Color leftColor = leftBorderColor.getRed() == 255 && leftBorderColor.getBlue() == 255 && leftBorderColor.getGreen() == 255 ? this.cell.getBackground() : new Color(leftBorderColor.getRed(), leftBorderColor.getGreen(), leftBorderColor.getBlue());
            MatteBorder left = BorderFactory.createMatteBorder(0, BORDER_THICKNESS, 0, 0, leftColor);
            RGB rightBorderColor = this.cellFormat.getBorderColour(Border.RIGHT).getDefaultRGB();
            Color rightColor = rightBorderColor.getRed() == 255 && rightBorderColor.getBlue() == 255 && rightBorderColor.getGreen() == 255 ? this.cell.getBackground() : new Color(rightBorderColor.getRed(), rightBorderColor.getGreen(), rightBorderColor.getBlue());
            MatteBorder right = BorderFactory.createMatteBorder(0, 0, 0, BORDER_THICKNESS, rightColor);
            CompoundBorder topAndBottom = new CompoundBorder(top, bottom);
            CompoundBorder leftAndRight = new CompoundBorder(left, right);
            this.setBorder(new CompoundBorder(topAndBottom, leftAndRight));
        }
    }
}

