/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.gui.jframes.profilegrid;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jprofilegrid.data.GlobalData;
import jprofilegrid.data.profilegrid.Cell;
import jprofilegrid.data.profilegrid.ConservationRange;
import jprofilegrid.data.profilegrid.Format;
import jprofilegrid.data.profilegrid.Numeric;
import jprofilegrid.data.profilegrid.ProfileGrid;
import jprofilegrid.data.profilegrid.Text;
import jprofilegrid.gui.GlobalGUIData;
import jprofilegrid.gui.jframes.profilegrid.FixedAAColumnInTable;
import jprofilegrid.gui.jframes.profilegrid.ProfileGridTableCellRenderer;
import jprofilegrid.gui.jframes.profilegrid.ProfileGridTableModel;
import jxl.format.RGB;

public class ProfileGridJFrame
extends JFrame
implements ActionListener,
Runnable {
    private static final long serialVersionUID = 8810051498829113732L;
    private ProfileGridTableModel profileGridTableModel = new ProfileGridTableModel();
    private JTable profileGridJTable = new JTable();
    private ProfileGridTableModel symbolSideBarsData = new ProfileGridTableModel();
    private JTable symbolSideBarsTable = new JTable();
    private ProfileGridScrollPane jscrollPane;
    private MenuBar menuBar = new MenuBar();
    private Menu fileMenu = new Menu("File");
    private Menu aboutMenu = new Menu("About");
    private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
    private MenuItem quitMenuItem = new MenuItem("Quit");

    public ProfileGridJFrame() {
        this.addWindowListener(GlobalGUIData.globalGUIData);
        this.setLayout(new BorderLayout());
        this.initializeMenuBar();
        this.setResizable(true);
        this.profileGridJTable.getTableHeader().setReorderingAllowed(false);
        this.symbolSideBarsTable.getTableHeader().setReorderingAllowed(false);
        this.profileGridJTable.setAutoResizeMode(0);
        this.profileGridJTable.setSelectionMode(0);
        this.setDefaultCloseOperation(1);
    }

    private void initializeMenuBar() {
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(GlobalGUIData.profileGridOpenWindowsMenu);
        this.menuBar.add(this.aboutMenu);
        this.quitMenuItem.addActionListener(this);
        this.aboutMenu.add(this.aboutMenuItem);
        this.aboutMenuItem.addActionListener(this);
        this.fileMenu.add(this.quitMenuItem);
        this.setMenuBar(this.menuBar);
    }

    public void resetDisplayedData() {
        ProfileGrid profileGrid = GlobalData.gridData.getProfileGrid();
        int i = 0;
        while (i < this.symbolSideBarsData.getRowCount()) {
            int j = 0;
            while (j < this.symbolSideBarsData.getColumnCount()) {
                if (j == 1) {
                    if (i >= 4) {
                        this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), profileGrid.getSortedAminoAcidNames()[i - 4]), i, j);
                    } else {
                        if (i == 0) {
                            this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "Posn"), i, j);
                        }
                        if (i == 1) {
                            this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "Major"), i, j);
                        }
                        if (i == 2) {
                            this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), profileGrid.getTemplateSequenceName().getValue()), i, j);
                        }
                        if (i == 3) {
                            this.symbolSideBarsData.setValueAt(profileGrid.getHighlightSequenceName(), i, j);
                        }
                    }
                }
                if (j == 0) {
                    if (i >= 4) {
                        this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), profileGrid.getSortedAminoAcidSymbols()[i - 4]), i, j);
                    } else if (i == 0) {
                        this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), this.profileGridJTable.getSelectedRow() >= 0 ? this.profileGridTableModel.getValueAt(this.profileGridJTable.getSelectedRow(), this.profileGridJTable.getSelectedRow()).toString() : ""), i, j);
                    } else {
                        this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), ""), i, j);
                    }
                }
                ++j;
            }
            ++i;
        }
        int numberOfSequences = GlobalData.gridData.getProfileGrid().getNumberOfSequences();
        this.setTitle(String.valueOf(GlobalData.gridData.getMultipleSequenceAlignment().getAlignmentName()) + " - " + numberOfSequences + " Sequences");
        int columnCount = this.profileGridTableModel.getColumnCount();
        int numberOfSpecies = profileGrid.getAlignmentConstants().getNames().length + 4;
        Text[] positionInAlignmentRow = profileGrid.getEntireAlignment().getPositionInAlignmentRow();
        Text[] majorAminoAcidRow = profileGrid.getEntireAlignment().getMajorAminoAcidRow();
        Text[] positionSequenceRow = profileGrid.getEntireAlignment().getTemplateSequenceRow();
        Text[] highlightSequenceRow = profileGrid.getEntireAlignment().getHighlightSequenceRow();
        Numeric[][] aminoAcidCounts = profileGrid.getEntireAlignment().getAminoAcidCounts();
        int i2 = 0;
        while (i2 < columnCount) {
            int j = 0;
            while (j < numberOfSpecies) {
                if (j == 0) {
                    this.profileGridTableModel.setValueAt(positionInAlignmentRow[i2], j, i2);
                }
                if (j == 1) {
                    this.profileGridTableModel.setValueAt(majorAminoAcidRow[i2], j, i2);
                }
                if (j == 2) {
                    this.profileGridTableModel.setValueAt(positionSequenceRow[i2], j, i2);
                }
                if (j == 3) {
                    this.profileGridTableModel.setValueAt(highlightSequenceRow[i2], j, i2);
                }
                if (j > 3) {
                    this.profileGridTableModel.setValueAt(aminoAcidCounts[i2][j - 4], j, i2);
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.profileGridJTable.getColumnCount()) {
            this.profileGridJTable.getColumnModel().getColumn(i2).setPreferredWidth(30);
            ++i2;
        }
        this.update(this.getGraphics());
    }

    public void setSelectedCell() {
        int col = this.profileGridJTable.getSelectedColumn();
        int row = this.profileGridJTable.getSelectedRow() - 4;
        if (col < GlobalData.gridData.getSortedData().getAminoAcidCounts().length && row < GlobalData.gridData.getSortedData().getAminoAcidCounts()[0].length && col >= 0 && row >= 0) {
            Integer value = GlobalData.gridData.getSortedData().getAminoAcidCounts()[col][row];
            String positionInTemplateSequence = GlobalData.gridData.getProfileGrid().getEntireAlignment().getPositionInAlignmentRow()[col].getValue();
            String positionInHighlightSequence = GlobalData.gridData.getProfileGrid().getEntireAlignment().getHighlightSequenceArray()[col].getValue();
            this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), this.symbolSideBarsTable.getValueAt(this.profileGridJTable.getSelectedRow(), 1).toString()), 0, 0);
            this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), value.toString()), 1, 0);
            this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), positionInTemplateSequence), 2, 0);
            this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), positionInHighlightSequence), 3, 0);
        } else {
            this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), ""), 0, 0);
            this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), ""), 1, 0);
            this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), ""), 2, 0);
            this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), ""), 3, 0);
        }
        this.repaint();
    }

    public void resetDisplay() {
        this.profileGridTableModel = new ProfileGridTableModel(GlobalData.gridData.getProfileGrid().getAlignmentConstants().getNames().length + 4, GlobalData.gridData.getProfileGrid().getEntireAlignment().getAminoAcidCounts().length);
        this.symbolSideBarsData = new ProfileGridTableModel(GlobalData.gridData.getProfileGrid().getAlignmentConstants().getNames().length + 4, 2);
        this.profileGridJTable = new JTable(this.profileGridTableModel);
        this.profileGridJTable.setSelectionMode(0);
        this.profileGridJTable.getTableHeader().setReorderingAllowed(false);
        this.profileGridJTable.setDragEnabled(false);
        this.profileGridJTable.setGridColor(Color.LIGHT_GRAY);
        this.profileGridJTable.setAutoResizeMode(0);
        this.profileGridJTable.setCellSelectionEnabled(true);
        this.profileGridJTable.setDragEnabled(false);
        this.profileGridJTable.setDefaultRenderer(Cell.class, new ProfileGridTableCellRenderer());
        this.symbolSideBarsTable = new JTable(this.symbolSideBarsData);
        this.symbolSideBarsTable.getTableHeader().setReorderingAllowed(false);
        this.symbolSideBarsTable.setColumnSelectionAllowed(false);
        this.symbolSideBarsTable.setRowSelectionAllowed(false);
        this.symbolSideBarsTable.setCellSelectionEnabled(false);
        this.symbolSideBarsTable.setPreferredScrollableViewportSize(new Dimension(150, this.symbolSideBarsTable.getPreferredScrollableViewportSize().height));
        this.symbolSideBarsTable.setAutoResizeMode(0);
        this.symbolSideBarsTable.setDefaultRenderer(Text.class, new FixedAAColumnInTable());
        if (this.jscrollPane != null) {
            this.remove(this.jscrollPane);
        }
        this.jscrollPane = new ProfileGridScrollPane(this.profileGridJTable);
        this.jscrollPane.setRowHeaderView(this.symbolSideBarsTable);
        this.add((Component)this.jscrollPane, "Center");
        this.pack();
        this.resetDisplayedData();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.quitMenuItem) {
            System.exit(0);
        }
        if (event.getSource() == this.aboutMenuItem) {
            GlobalGUIData.displayAboutDialog();
            return;
        }
    }

    public void run() {
        this.resetDisplayedData();
    }

    private class ProfileGridScrollPane
    extends JScrollPane {
        private static final long serialVersionUID = 1L;

        public ProfileGridScrollPane(JTable data) {
            super(data);
        }

        public void paint(Graphics g) {
            super.paintComponents(g);
            ConservationRange cRange = GlobalData.gridData.getConservationRanges();
            g.clearRect(0, ProfileGridJFrame.this.symbolSideBarsTable.getHeight(), ProfileGridJFrame.this.symbolSideBarsTable.getWidth(), this.getHeight());
            if (cRange.getNumberOfRanges() > 0) {
                int rectWidth = ProfileGridJFrame.this.symbolSideBarsTable.getWidth() / cRange.getNumberOfRanges();
                int i = 0;
                while (i < cRange.getNumberOfRanges()) {
                    RGB currentColor = cRange.getColour(i).getDefaultRGB();
                    new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue());
                    g.setColor(new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue()));
                    g.fillRect(i * rectWidth, ProfileGridJFrame.this.symbolSideBarsTable.getHeight() + 3, rectWidth, 20);
                    ++i;
                }
            }
        }
    }
}

