/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.gui.jframes.profilegrid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import jprofilegrid.data.profilegrid.Cell;
import jprofilegrid.file.writers.excel.ProfileGridFormatToExcelFormatConverter;
import jprofilegrid.gui.GlobalGUIData;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.RGB;
import jxl.write.WritableCellFormat;

public class ProfileGridTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -686000339606310665L;
    Component cell;
    Object value;
    WritableCellFormat cellFormat;
    private static DecimalFormat formatter = new DecimalFormat();
    private static int previousRowSelected = 0;
    private static int previousColumnSelected = 0;
    public static int BORDER_THICKNESS = 2;

    static {
        formatter.setMaximumFractionDigits(2);
        formatter.setMinimumFractionDigits(2);
        formatter.setMaximumIntegerDigits(1);
        formatter.setMinimumIntegerDigits(1);
    }

    private void setBold() {
        if (((Cell)this.value).getFormat().isBold()) {
            this.cell.setFont(new Font("Times New Roman", 1, 12));
        } else {
            this.cell.setFont(new Font("Times New Roman", 0, 12));
        }
    }

    private void setBorders() {
        if (this.cellFormat.hasBorders()) {
            RGB topBorderColor = this.cellFormat.getBorderColour(Border.TOP).getDefaultRGB();
            Color topColor = topBorderColor.getRed() == 255 && topBorderColor.getBlue() == 255 && topBorderColor.getGreen() == 255 ? this.cell.getBackground() : new Color(topBorderColor.getRed(), topBorderColor.getGreen(), topBorderColor.getBlue());
            MatteBorder top = BorderFactory.createMatteBorder(BORDER_THICKNESS, 0, 0, 0, topColor);
            RGB bottomBorderColor = this.cellFormat.getBorderColour(Border.BOTTOM).getDefaultRGB();
            Color bottomColor = bottomBorderColor.getRed() == 255 && bottomBorderColor.getBlue() == 255 && bottomBorderColor.getGreen() == 255 ? this.cell.getBackground() : new Color(bottomBorderColor.getRed(), bottomBorderColor.getGreen(), bottomBorderColor.getBlue());
            MatteBorder bottom = BorderFactory.createMatteBorder(0, 0, BORDER_THICKNESS, 0, bottomColor);
            RGB leftBorderColor = this.cellFormat.getBorderColour(Border.LEFT).getDefaultRGB();
            Color leftColor = leftBorderColor.getRed() == 255 && leftBorderColor.getBlue() == 255 && leftBorderColor.getGreen() == 255 ? this.cell.getBackground() : new Color(leftBorderColor.getRed(), leftBorderColor.getGreen(), leftBorderColor.getBlue());
            MatteBorder left = BorderFactory.createMatteBorder(0, BORDER_THICKNESS, 0, 0, leftColor);
            RGB rightBorderColor = this.cellFormat.getBorderColour(Border.RIGHT).getDefaultRGB();
            Color rightColor = rightBorderColor.getRed() == 255 && rightBorderColor.getBlue() == 255 && rightBorderColor.getGreen() == 255 ? this.cell.getBackground() : new Color(rightBorderColor.getRed(), rightBorderColor.getGreen(), rightBorderColor.getBlue());
            MatteBorder right = BorderFactory.createMatteBorder(0, 0, 0, BORDER_THICKNESS, rightColor);
            CompoundBorder topAndBottom = new CompoundBorder(top, bottom);
            CompoundBorder leftAndRight = new CompoundBorder(left, right);
            this.setBorder(new CompoundBorder(topAndBottom, leftAndRight));
        }
    }

    private void setBackgroundColor() {
        RGB rgbBackColor = this.cellFormat.getBackgroundColour().getDefaultRGB();
        Color backColor = new Color(rgbBackColor.getRed(), rgbBackColor.getGreen(), rgbBackColor.getBlue());
        this.cell.setBackground(backColor);
    }

    private void setForegroundColor() {
        RGB foreGroundColor = this.cellFormat.getFont().getColour().getDefaultRGB();
        Color foreColor = new Color(foreGroundColor.getRed(), foreGroundColor.getGreen(), foreGroundColor.getBlue());
        this.cell.setForeground(foreColor);
    }

    private void setAlignment() {
        if (this.cellFormat.getAlignment() == Alignment.CENTRE) {
            super.setHorizontalAlignment(0);
        }
        if (this.cellFormat.getAlignment() == Alignment.RIGHT) {
            this.setAlignmentY(4.0f);
        }
        if (this.cellFormat.getAlignment() == Alignment.LEFT) {
            this.setAlignmentY(2.0f);
        }
    }

    private void tryToSetTextAsNumber(Component cell, String text, int row) {
        try {
            if (GlobalGUIData.getShowValuesAs() != 1 || row == 0) {
                this.setText(String.valueOf((int)Double.parseDouble(text)));
                if (row == 0 && (int)Double.parseDouble(text) % 10 == 0) {
                    cell.setBackground(Color.LIGHT_GRAY);
                }
            } else {
                this.setText(String.valueOf(formatter.format(Double.parseDouble(text))));
            }
        }
        catch (NumberFormatException e) {
            this.setText(text);
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object nValue, boolean isSelected, boolean hasFocus, int row, int column) {
        this.cell = super.getTableCellRendererComponent(table, this.value, isSelected, hasFocus, row, column);
        this.value = nValue;
        this.cellFormat = ProfileGridFormatToExcelFormatConverter.extractWritableCellFormat((Cell)this.value);
        this.setBackgroundColor();
        this.tryToSetTextAsNumber(this.cell, ((Cell)this.value).toString(), row);
        this.setText(((Cell)this.value).toString().equalsIgnoreCase("0.0") || ((Cell)this.value).toString().equalsIgnoreCase("0") ? "" : this.getText());
        this.setBold();
        this.setBorders();
        this.setAlignment();
        this.setForegroundColor();
        if (isSelected) {
            int reductionAmount = 200;
            int red = this.getBackground().getRed() > reductionAmount ? this.getBackground().getRed() - reductionAmount : 0;
            int green = this.getBackground().getGreen() > reductionAmount ? this.getBackground().getGreen() - reductionAmount : 0;
            int blue = this.getBackground().getBlue() > reductionAmount ? this.getBackground().getBlue() - reductionAmount : 0;
            Color shadedBackground = new Color(red, green, blue);
            this.cell.setBackground(shadedBackground);
            if ((previousRowSelected != row || previousColumnSelected != column) && row >= 4 && row < table.getRowCount() && column >= 0 && column <= table.getColumnCount()) {
                previousRowSelected = row;
                previousColumnSelected = column;
                GlobalGUIData.globalGUIData.setCellDescriptionDialogSelectedAminoAcid(row - 4, column);
            }
        }
        return this.cell;
    }
}

