/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.biff.FontRecord;
import jxl.biff.IndexMapping;
import jxl.write.biff.File;

public class Fonts {
    private ArrayList<FontRecord> fonts = new ArrayList();
    private static final int numDefaultFonts = 4;

    public void addFont(FontRecord f) {
        if (!f.isInitialized()) {
            int pos = this.fonts.size();
            if (pos >= 4) {
                ++pos;
            }
            f.initialize(pos);
            this.fonts.add(f);
        }
    }

    public FontRecord getFont(int index) {
        if (index > 4) {
            --index;
        }
        return this.fonts.get(index);
    }

    public void write(File outputFile) throws IOException {
        Iterator<FontRecord> i = this.fonts.iterator();
        FontRecord font = null;
        while (i.hasNext()) {
            font = i.next();
            outputFile.write(font);
        }
    }

    IndexMapping rationalize() {
        IndexMapping mapping = new IndexMapping(this.fonts.size() + 1);
        ArrayList<FontRecord> newfonts = new ArrayList<FontRecord>();
        FontRecord fr3 = null;
        int numremoved = 0;
        int i = 0;
        while (i < 4) {
            fr3 = this.fonts.get(i);
            newfonts.add(fr3);
            mapping.setMapping(fr3.getFontIndex(), fr3.getFontIndex());
            ++i;
        }
        Iterator it = null;
        FontRecord fr2 = null;
        boolean duplicate = false;
        int i2 = 4;
        while (i2 < this.fonts.size()) {
            fr3 = this.fonts.get(i2);
            duplicate = false;
            it = newfonts.iterator();
            while (it.hasNext() && !duplicate) {
                fr2 = (FontRecord)it.next();
                if (!fr3.equals(fr2)) continue;
                duplicate = true;
                mapping.setMapping(fr3.getFontIndex(), mapping.getNewIndex(fr2.getFontIndex()));
                ++numremoved;
            }
            if (!duplicate) {
                newfonts.add(fr3);
                int newindex = fr3.getFontIndex() - numremoved;
                Assert.verify(newindex > 4);
                mapping.setMapping(fr3.getFontIndex(), newindex);
            }
            ++i2;
        }
        for (FontRecord fr3 : newfonts) {
            fr3.initialize(mapping.getNewIndex(fr3.getFontIndex()));
        }
        this.fonts = newfonts;
        return mapping;
    }
}

