/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import common.Logger;
import java.io.File;
import jxl.Workbook;
import jxl.demo.ReadWrite;
import jxl.demo.Write;

public class Demo {
    private static final int CSVFormat = 13;
    private static final int XMLFormat = 14;
    private static Logger logger = Logger.getLogger(Demo.class);

    private static void displayHelp() {
        System.err.println("Command format:  Demo [-unicode] [-csv] [-hide] excelfile");
        System.err.println("                 Demo -xml [-format]  excelfile");
        System.err.println("                 Demo -readwrite|-rw excelfile output");
        System.err.println("                 Demo -biffdump | -bd | -wa | -write | -formulas | -features | -escher | -escherdg excelfile");
        System.err.println("                 Demo -ps excelfile [property] [output]");
        System.err.println("                 Demo -version | -logtest | -h | -help");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Demo.displayHelp();
            System.exit(1);
        }
        if (args[0].equals("-help") || args[0].equals("-h")) {
            Demo.displayHelp();
            System.exit(1);
        }
        if (args[0].equals("-version")) {
            System.out.println("v" + Workbook.getVersion());
            System.exit(0);
        }
        if (args[0].equals("-logtest")) {
            logger.debug("A sample \"debug\" message");
            logger.info("A sample \"info\" message");
            logger.warn("A sample \"warning\" message");
            logger.error("A sample \"error\" message");
            logger.fatal("A sample \"fatal\" message");
            System.exit(0);
        }
        boolean write = false;
        boolean readwrite = false;
        boolean formulas = false;
        boolean biffdump = false;
        boolean jxlversion = false;
        boolean propertysets = false;
        boolean features = false;
        boolean escher = false;
        boolean escherdg = false;
        String file = args[0];
        String outputFile = null;
        if (args[0].equals("-write")) {
            write = true;
            file = args[1];
        } else if (args[0].equals("-formulas")) {
            formulas = true;
            file = args[1];
        } else if (args[0].equals("-features")) {
            features = true;
            file = args[1];
        } else if (args[0].equals("-escher")) {
            escher = true;
            file = args[1];
        } else if (args[0].equals("-escherdg")) {
            escherdg = true;
            file = args[1];
        } else if (args[0].equals("-biffdump") || args[0].equals("-bd")) {
            biffdump = true;
            file = args[1];
        } else if (args[0].equals("-wa")) {
            jxlversion = true;
            file = args[1];
        } else if (args[0].equals("-ps")) {
            propertysets = true;
            file = args[1];
            int cfr_ignored_0 = args.length;
            if (args.length == 4) {
                outputFile = args[3];
            }
        } else if (args[0].equals("-readwrite") || args[0].equals("-rw")) {
            readwrite = true;
            file = args[1];
            outputFile = args[2];
        } else {
            file = args[args.length - 1];
        }
        int format = 13;
        if (!(write || readwrite || formulas || biffdump || jxlversion || propertysets || features || escher || escherdg)) {
            int i = 0;
            while (i < args.length - 1) {
                if (!args[i].equals("-unicode")) {
                    if (args[i].equals("-xml")) {
                        format = 14;
                    } else if (args[i].equals("-csv")) {
                        format = 13;
                    } else if (!args[i].equals("-format") && !args[i].equals("-hide")) {
                        System.err.println("Command format:  CSV [-unicode] [-xml|-csv] excelfile");
                        System.exit(1);
                    }
                }
                ++i;
            }
        }
        try {
            if (write) {
                Write w = new Write(file);
                w.write();
            } else if (readwrite) {
                ReadWrite rw = new ReadWrite(file, outputFile);
                rw.readWrite();
            } else if (formulas) {
                Workbook w = Workbook.getWorkbook(new File(file));
                w.close();
            } else if (features) {
                Workbook w = Workbook.getWorkbook(new File(file));
                w.close();
            } else if (escher) {
                Workbook w = Workbook.getWorkbook(new File(file));
                w.close();
            } else if (escherdg) {
                Workbook w = Workbook.getWorkbook(new File(file));
                w.close();
            } else if (!(biffdump || jxlversion || propertysets)) {
                Workbook w = Workbook.getWorkbook(new File(file));
                if (format != 13) {
                    // empty if block
                }
                w.close();
            }
        }
        catch (Throwable t) {
            System.out.println(t.toString());
            t.printStackTrace();
        }
    }
}

