/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellType;
import jxl.Range;
import jxl.WorkbookSettings;
import jxl.biff.SheetRangeImpl;
import jxl.write.Blank;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.File;
import jxl.write.biff.MergedCellsRecord;
import jxl.write.biff.WritableSheetImpl;

class MergedCells {
    private static Logger logger = Logger.getLogger(MergedCells.class);
    private ArrayList<Range> ranges = new ArrayList();
    private WritableSheet sheet;
    private static final int maxRangesPerSheet = 1020;

    public MergedCells(WritableSheet ws) {
        this.sheet = ws;
    }

    void add(Range r) {
        this.ranges.add(r);
    }

    void insertRow(int row) {
        Object var2_2 = null;
        for (SheetRangeImpl sheetRangeImpl : this.ranges) {
            sheetRangeImpl.insertRow(row);
        }
    }

    void insertColumn(int col) {
        Object var2_2 = null;
        for (SheetRangeImpl sheetRangeImpl : this.ranges) {
            sheetRangeImpl.insertColumn(col);
        }
    }

    void removeColumn(int col) {
        Object var2_2 = null;
        for (SheetRangeImpl sheetRangeImpl : this.ranges) {
            if (sheetRangeImpl.getTopLeft().getColumn() == col && sheetRangeImpl.getBottomRight().getColumn() == col) {
                this.ranges.remove(this.ranges.indexOf(sheetRangeImpl));
                continue;
            }
            sheetRangeImpl.removeColumn(col);
        }
    }

    void removeRow(int row) {
        SheetRangeImpl sr = null;
        Iterator<Range> i = this.ranges.iterator();
        while (i.hasNext()) {
            sr = (SheetRangeImpl)i.next();
            if (sr.getTopLeft().getRow() == row && sr.getBottomRight().getRow() == row) {
                i.remove();
                continue;
            }
            sr.removeRow(row);
        }
    }

    Range[] getMergedCells() {
        Range[] cells = new Range[this.ranges.size()];
        int i = 0;
        while (i < cells.length) {
            cells[i] = this.ranges.get(i);
            ++i;
        }
        return cells;
    }

    void unmergeCells(Range r) {
        int index = this.ranges.indexOf(r);
        if (index != -1) {
            this.ranges.remove(index);
        }
    }

    private void checkIntersections() {
        ArrayList<SheetRangeImpl> newcells = new ArrayList<SheetRangeImpl>(this.ranges.size());
        for (SheetRangeImpl sheetRangeImpl : this.ranges) {
            Iterator i = newcells.iterator();
            SheetRangeImpl range = null;
            boolean intersects = false;
            while (i.hasNext() && !intersects) {
                range = (SheetRangeImpl)i.next();
                if (!range.intersects(sheetRangeImpl)) continue;
                logger.warn("Could not merge cells " + sheetRangeImpl + " as they clash with an existing set of merged cells.");
                intersects = true;
            }
            if (intersects) continue;
            newcells.add(sheetRangeImpl);
        }
        this.ranges = newcells;
    }

    private void checkRanges() {
        try {
            SheetRangeImpl range = null;
            int i = 0;
            while (i < this.ranges.size()) {
                range = (SheetRangeImpl)this.ranges.get(i);
                Cell tl = range.getTopLeft();
                Cell br = range.getBottomRight();
                boolean found = false;
                int c = tl.getColumn();
                while (c <= br.getColumn()) {
                    int r = tl.getRow();
                    while (r <= br.getRow()) {
                        Cell cell = this.sheet.getCell(c, r);
                        if (cell.getType() != CellType.EMPTY) {
                            if (!found) {
                                found = true;
                            } else {
                                logger.warn("Range " + range + " contains more than one data cell.  " + "Setting the other cells to blank.");
                                Blank b = new Blank(c, r);
                                this.sheet.addCell(b);
                            }
                        }
                        ++r;
                    }
                    ++c;
                }
                ++i;
            }
        }
        catch (WriteException e) {
            Assert.verify(false);
        }
    }

    void write(File outputFile) throws IOException {
        if (this.ranges.size() == 0) {
            return;
        }
        WorkbookSettings ws = ((WritableSheetImpl)this.sheet).getWorkbookSettings();
        if (!ws.getMergedCellCheckingDisabled()) {
            this.checkIntersections();
            this.checkRanges();
        }
        if (this.ranges.size() < 1020) {
            MergedCellsRecord mcr = new MergedCellsRecord(this.ranges);
            outputFile.write(mcr);
            return;
        }
        int numRecordsRequired = this.ranges.size() / 1020 + 1;
        int pos = 0;
        int i = 0;
        while (i < numRecordsRequired) {
            int numranges = Math.min(1020, this.ranges.size() - pos);
            ArrayList<Range> cells = new ArrayList<Range>(numranges);
            int j = 0;
            while (j < numranges) {
                cells.add(this.ranges.get(pos + j));
                ++j;
            }
            MergedCellsRecord mcr = new MergedCellsRecord(cells);
            outputFile.write(mcr);
            pos += numranges;
            ++i;
        }
    }
}

