/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.BuiltInName;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.read.biff.NameRecord;

class NameRecord
extends WritableRecordData {
    private byte[] data;
    private String name;
    private BuiltInName builtInName;
    private int index;
    private int sheetRef = 0;
    private NameRange[] ranges;
    private static final int areaReference = 59;
    private static final int subExpression = 41;

    public NameRecord(jxl.read.biff.NameRecord sr, int ind) {
        super(Type.NAME);
        this.data = sr.getData();
        this.name = sr.getName();
        this.sheetRef = sr.getSheetRef();
        this.index = ind;
        NameRecord.NameRange[] r = sr.getRanges();
        this.ranges = new NameRange[r.length];
        int i = 0;
        while (i < this.ranges.length) {
            this.ranges[i] = new NameRange(r[i]);
            ++i;
        }
    }

    NameRecord(String theName, int theIndex, int extSheet, int theStartRow, int theEndRow, int theStartCol, int theEndCol, boolean global) {
        super(Type.NAME);
        this.name = theName;
        this.index = theIndex;
        this.sheetRef = global ? 0 : this.index + 1;
        this.ranges = new NameRange[1];
        this.ranges[0] = new NameRange(extSheet, theStartRow, theEndRow, theStartCol, theEndCol);
    }

    NameRecord(BuiltInName theName, int theIndex, int extSheet, int theStartRow, int theEndRow, int theStartCol, int theEndCol, boolean global) {
        super(Type.NAME);
        this.builtInName = theName;
        this.index = theIndex;
        this.sheetRef = global ? 0 : this.index + 1;
        this.ranges = new NameRange[1];
        this.ranges[0] = new NameRange(extSheet, theStartRow, theEndRow, theStartCol, theEndCol);
    }

    NameRecord(BuiltInName theName, int theIndex, int extSheet, int theStartRow, int theEndRow, int theStartCol, int theEndCol, int theStartRow2, int theEndRow2, int theStartCol2, int theEndCol2, boolean global) {
        super(Type.NAME);
        this.builtInName = theName;
        this.index = theIndex;
        this.sheetRef = global ? 0 : this.index + 1;
        this.ranges = new NameRange[2];
        this.ranges[0] = new NameRange(extSheet, theStartRow, theEndRow, theStartCol, theEndCol);
        this.ranges[1] = new NameRange(extSheet, theStartRow2, theEndRow2, theStartCol2, theEndCol2);
    }

    public byte[] getData() {
        int pos;
        if (this.data != null) {
            return this.data;
        }
        int NAME_HEADER_LENGTH = 15;
        int AREA_RANGE_LENGTH = 11;
        int detailLength = this.ranges.length > 1 ? this.ranges.length * 11 + 4 : 11;
        int length = 15 + detailLength;
        this.data = new byte[length += this.builtInName != null ? 1 : this.name.length()];
        int options = 0;
        if (this.builtInName != null) {
            options |= 0x20;
        }
        IntegerHelper.getTwoBytes(options, this.data, 0);
        this.data[2] = 0;
        this.data[3] = this.builtInName != null ? (byte)1 : (byte)this.name.length();
        IntegerHelper.getTwoBytes(detailLength, this.data, 4);
        IntegerHelper.getTwoBytes(this.sheetRef, this.data, 6);
        IntegerHelper.getTwoBytes(this.sheetRef, this.data, 8);
        if (this.builtInName != null) {
            this.data[15] = (byte)this.builtInName.getValue();
        } else {
            StringHelper.getBytes(this.name, this.data, 15);
        }
        int n = pos = this.builtInName != null ? 16 : this.name.length() + 15;
        if (this.ranges.length > 1) {
            this.data[pos++] = 41;
            IntegerHelper.getTwoBytes(detailLength - 3, this.data, pos);
            pos += 2;
            int i = 0;
            while (i < this.ranges.length) {
                this.data[pos++] = 59;
                byte[] rd = this.ranges[i].getData();
                System.arraycopy(rd, 0, this.data, pos, rd.length);
                pos += rd.length;
                ++i;
            }
            this.data[pos] = 16;
        } else {
            this.data[pos] = 59;
            byte[] rd = this.ranges[0].getData();
            System.arraycopy(rd, 0, this.data, pos + 1, rd.length);
        }
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public int getSheetRef() {
        return this.sheetRef;
    }

    public void setSheetRef(int i) {
        this.sheetRef = i;
        IntegerHelper.getTwoBytes(this.sheetRef, this.data, 8);
    }

    public NameRange[] getRanges() {
        return this.ranges;
    }

    class NameRange {
        private int columnFirst;
        private int rowFirst;
        private int columnLast;
        private int rowLast;
        private int externalSheet;

        NameRange(NameRecord.NameRange nr) {
            this.columnFirst = nr.getFirstColumn();
            this.rowFirst = nr.getFirstRow();
            this.columnLast = nr.getLastColumn();
            this.rowLast = nr.getLastRow();
            this.externalSheet = nr.getExternalSheet();
        }

        NameRange(int extSheet, int theStartRow, int theEndRow, int theStartCol, int theEndCol) {
            this.columnFirst = theStartCol;
            this.rowFirst = theStartRow;
            this.columnLast = theEndCol;
            this.rowLast = theEndRow;
            this.externalSheet = extSheet;
        }

        int getFirstColumn() {
            return this.columnFirst;
        }

        int getFirstRow() {
            return this.rowFirst;
        }

        int getLastColumn() {
            return this.columnLast;
        }

        int getLastRow() {
            return this.rowLast;
        }

        int getExternalSheet() {
            return this.externalSheet;
        }

        byte[] getData() {
            byte[] d = new byte[10];
            IntegerHelper.getTwoBytes(this.externalSheet, d, 0);
            IntegerHelper.getTwoBytes(this.rowFirst, d, 2);
            IntegerHelper.getTwoBytes(this.rowLast, d, 4);
            IntegerHelper.getTwoBytes(this.columnFirst & 0xFF, d, 6);
            IntegerHelper.getTwoBytes(this.columnLast & 0xFF, d, 8);
            return d;
        }
    }
}

