/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import jxl.Cell;
import jxl.CellType;
import jxl.CellView;
import jxl.HeaderFooter;
import jxl.Hyperlink;
import jxl.Image;
import jxl.LabelCell;
import jxl.Range;
import jxl.Sheet;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.AutoFilter;
import jxl.biff.CellReferenceHelper;
import jxl.biff.ConditionalFormat;
import jxl.biff.DataValidation;
import jxl.biff.EmptyCell;
import jxl.biff.FormattingRecords;
import jxl.biff.IndexMapping;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.SheetRangeImpl;
import jxl.biff.XFRecord;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.ComboBox;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.format.CellFormat;
import jxl.format.Font;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.write.Blank;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.ButtonPropertySetRecord;
import jxl.write.biff.CellValue;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.File;
import jxl.write.biff.FooterRecord;
import jxl.write.biff.HeaderRecord;
import jxl.write.biff.HyperlinkRecord;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.MergedCells;
import jxl.write.biff.PLSRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.RowsExceededException;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.SheetCopier;
import jxl.write.biff.SheetWriter;
import jxl.write.biff.Styles;
import jxl.write.biff.WritableWorkbookImpl;

class WritableSheetImpl
implements WritableSheet {
    private static Logger logger = Logger.getLogger(WritableSheetImpl.class);
    private String name;
    private File outputFile;
    private RowRecord[] rows;
    private FormattingRecords formatRecords;
    private SharedStrings sharedStrings;
    private TreeSet<Object> columnFormats;
    private TreeSet<Object> autosizedColumns;
    private ArrayList<WritableHyperlink> hyperlinks;
    private MergedCells mergedCells;
    private int numRows;
    private int numColumns;
    private PLSRecord plsRecord;
    private ButtonPropertySetRecord buttonPropertySet;
    private boolean chartOnly;
    private DataValidation dataValidation;
    private ArrayList<Integer> rowBreaks;
    private ArrayList<Integer> columnBreaks;
    private ArrayList<DrawingGroupObject> drawings;
    private ArrayList<WritableImage> images;
    private ArrayList<ConditionalFormat> conditionalFormats;
    private AutoFilter autoFilter;
    private ArrayList<CellValue> validatedCells;
    private ComboBox comboBox;
    private boolean drawingsModified;
    private int maxRowOutlineLevel;
    private int maxColumnOutlineLevel;
    private SheetSettings settings;
    private SheetWriter sheetWriter;
    private WorkbookSettings workbookSettings;
    private WritableWorkbookImpl workbook;
    private static final int rowGrowSize = 10;
    private static final int numRowsPerSheet = 65536;
    private static final int maxSheetNameLength = 31;
    private static final char[] illegalSheetNameCharacters = new char[]{'*', ':', '?', '\\'};
    private static final String[] imageTypes = new String[]{"png"};

    public WritableSheetImpl(String n, File of, FormattingRecords fr, SharedStrings ss, WorkbookSettings ws, WritableWorkbookImpl ww) {
        this.name = this.validateName(n);
        this.outputFile = of;
        this.rows = new RowRecord[0];
        this.numRows = 0;
        this.numColumns = 0;
        this.chartOnly = false;
        this.workbook = ww;
        this.formatRecords = fr;
        this.sharedStrings = ss;
        this.workbookSettings = ws;
        this.drawingsModified = false;
        this.columnFormats = new TreeSet<Object>(new ColumnInfoComparator());
        this.autosizedColumns = new TreeSet();
        this.hyperlinks = new ArrayList();
        this.mergedCells = new MergedCells(this);
        this.rowBreaks = new ArrayList();
        this.columnBreaks = new ArrayList();
        this.drawings = new ArrayList();
        this.images = new ArrayList();
        this.conditionalFormats = new ArrayList();
        this.validatedCells = new ArrayList();
        this.settings = new SheetSettings(this);
        this.sheetWriter = new SheetWriter(this.outputFile, this, this.workbookSettings);
    }

    public Cell getCell(String loc) {
        return this.getCell(CellReferenceHelper.getColumn(loc), CellReferenceHelper.getRow(loc));
    }

    public Cell getCell(int column, int row) {
        return this.getWritableCell(column, row);
    }

    public WritableCell getWritableCell(String loc) {
        return this.getWritableCell(CellReferenceHelper.getColumn(loc), CellReferenceHelper.getRow(loc));
    }

    public WritableCell getWritableCell(int column, int row) {
        WritableCell c = null;
        if (row < this.rows.length && this.rows[row] != null) {
            c = this.rows[row].getCell(column);
        }
        if (c == null) {
            c = new EmptyCell(column, row);
        }
        return c;
    }

    public int getRows() {
        return this.numRows;
    }

    public int getColumns() {
        return this.numColumns;
    }

    public Cell findCell(String contents) {
        Cell cell = null;
        boolean found = false;
        int i = 0;
        while (i < this.getRows() && !found) {
            Cell[] row = this.getRow(i);
            int j = 0;
            while (j < row.length && !found) {
                if (row[j].getContents().equals(contents)) {
                    cell = row[j];
                    found = true;
                }
                ++j;
            }
            ++i;
        }
        return cell;
    }

    public LabelCell findLabelCell(String contents) {
        LabelCell cell = null;
        boolean found = false;
        int i = 0;
        while (i < this.getRows() && !found) {
            Cell[] row = this.getRow(i);
            int j = 0;
            while (j < row.length && !found) {
                if ((row[j].getType() == CellType.LABEL || row[j].getType() == CellType.STRING_FORMULA) && row[j].getContents().equals(contents)) {
                    cell = (LabelCell)row[j];
                    found = true;
                }
                ++j;
            }
            ++i;
        }
        return cell;
    }

    public Cell[] getRow(int row) {
        boolean found = false;
        int col = this.numColumns - 1;
        while (col >= 0 && !found) {
            if (this.getCell(col, row).getType() != CellType.EMPTY) {
                found = true;
                continue;
            }
            --col;
        }
        Cell[] cells = new Cell[col + 1];
        int i = 0;
        while (i <= col) {
            cells[i] = this.getCell(i, row);
            ++i;
        }
        return cells;
    }

    public Cell[] getColumn(int col) {
        boolean found = false;
        int row = this.numRows - 1;
        while (row >= 0 && !found) {
            if (this.getCell(col, row).getType() != CellType.EMPTY) {
                found = true;
                continue;
            }
            --row;
        }
        Cell[] cells = new Cell[row + 1];
        int i = 0;
        while (i <= row) {
            cells[i] = this.getCell(col, i);
            ++i;
        }
        return cells;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public void insertRow(int row) {
        void var3_4;
        if (row < 0 || row >= this.numRows) {
            return;
        }
        RowRecord[] oldRows = this.rows;
        this.rows = this.numRows == this.rows.length ? new RowRecord[oldRows.length + 10] : new RowRecord[oldRows.length];
        System.arraycopy(oldRows, 0, this.rows, 0, row);
        System.arraycopy(oldRows, row, this.rows, row + 1, this.numRows - row);
        int n = row + 1;
        while (var3_4 <= this.numRows) {
            if (this.rows[var3_4] != null) {
                this.rows[var3_4].incrementRow();
            }
            ++var3_4;
        }
        Object var3_5 = null;
        for (HyperlinkRecord hyperlinkRecord : this.hyperlinks) {
            hyperlinkRecord.insertRow(row);
        }
        if (this.dataValidation != null) {
            this.dataValidation.insertRow(row);
        }
        this.mergedCells.insertRow(row);
        ArrayList<Integer> newRowBreaks = new ArrayList<Integer>();
        for (int val : this.rowBreaks) {
            if (val >= row) {
                ++val;
            }
            newRowBreaks.add(new Integer(val));
        }
        this.rowBreaks = newRowBreaks;
        for (ConditionalFormat cf : this.conditionalFormats) {
            cf.insertRow(row);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowInserted(this, row);
        }
        ++this.numRows;
    }

    /*
     * WARNING - void declaration
     */
    public void insertColumn(int col) {
        void var2_3;
        if (col < 0 || col >= this.numColumns) {
            return;
        }
        boolean bl = false;
        while (var2_3 < this.numRows) {
            if (this.rows[var2_3] != null) {
                this.rows[var2_3].insertColumn(col);
            }
            ++var2_3;
        }
        Object var2_4 = null;
        for (HyperlinkRecord hyperlinkRecord : this.hyperlinks) {
            hyperlinkRecord.insertColumn(col);
        }
        for (ColumnInfoRecord columnInfoRecord : this.columnFormats) {
            if (columnInfoRecord.getColumn() < col) continue;
            columnInfoRecord.incrementColumn();
        }
        if (this.autosizedColumns.size() > 0) {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            for (Integer n : this.autosizedColumns) {
                if (n >= col) {
                    treeSet.add(new Integer(n + 1));
                    continue;
                }
                treeSet.add(n);
            }
            this.autosizedColumns = treeSet;
        }
        if (this.dataValidation != null) {
            this.dataValidation.insertColumn(col);
        }
        this.mergedCells.insertColumn(col);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int val : this.columnBreaks) {
            if (val >= col) {
                ++val;
            }
            arrayList.add(new Integer(val));
        }
        this.columnBreaks = arrayList;
        for (ConditionalFormat cf : this.conditionalFormats) {
            cf.insertColumn(col);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnInserted(this, col);
        }
        ++this.numColumns;
    }

    /*
     * WARNING - void declaration
     */
    public void removeColumn(int col) {
        void var2_3;
        if (col < 0 || col >= this.numColumns) {
            return;
        }
        boolean bl = false;
        while (var2_3 < this.numRows) {
            if (this.rows[var2_3] != null) {
                this.rows[var2_3].removeColumn(col);
            }
            ++var2_3;
        }
        Object var2_4 = null;
        for (HyperlinkRecord hyperlinkRecord : this.hyperlinks) {
            if (hyperlinkRecord.getColumn() == col && hyperlinkRecord.getLastColumn() == col) {
                this.hyperlinks.remove(this.hyperlinks.indexOf(hyperlinkRecord));
                continue;
            }
            hyperlinkRecord.removeColumn(col);
        }
        if (this.dataValidation != null) {
            this.dataValidation.removeColumn(col);
        }
        this.mergedCells.removeColumn(col);
        ArrayList<Integer> newColumnBreaks = new ArrayList<Integer>();
        for (int val : this.columnBreaks) {
            if (val == col) continue;
            if (val > col) {
                --val;
            }
            newColumnBreaks.add(new Integer(val));
        }
        this.columnBreaks = newColumnBreaks;
        Iterator<Object> i2 = this.columnFormats.iterator();
        ColumnInfoRecord removeColumn = null;
        while (i2.hasNext()) {
            ColumnInfoRecord cir = (ColumnInfoRecord)i2.next();
            if (cir.getColumn() == col) {
                removeColumn = cir;
                continue;
            }
            if (cir.getColumn() <= col) continue;
            cir.decrementColumn();
        }
        if (removeColumn != null) {
            this.columnFormats.remove(removeColumn);
        }
        if (this.autosizedColumns.size() > 0) {
            TreeSet<Integer> newAutosized = new TreeSet<Integer>();
            for (Integer n : this.autosizedColumns) {
                if (n == col) continue;
                if (n > col) {
                    newAutosized.add(new Integer(n - 1));
                    continue;
                }
                newAutosized.add(n);
            }
            this.autosizedColumns = newAutosized;
        }
        for (ConditionalFormat conditionalFormat : this.conditionalFormats) {
            conditionalFormat.removeColumn(col);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnRemoved(this, col);
        }
        --this.numColumns;
    }

    public void removeRow(int row) {
        if (row < 0 || row >= this.numRows) {
            return;
        }
        RowRecord[] oldRows = this.rows;
        this.rows = new RowRecord[oldRows.length];
        System.arraycopy(oldRows, 0, this.rows, 0, row);
        System.arraycopy(oldRows, row + 1, this.rows, row, this.numRows - (row + 1));
        int i = row;
        while (i < this.numRows) {
            if (this.rows[i] != null) {
                this.rows[i].decrementRow();
            }
            ++i;
        }
        HyperlinkRecord hr = null;
        Iterator<WritableHyperlink> i2 = this.hyperlinks.iterator();
        while (i2.hasNext()) {
            hr = i2.next();
            if (hr.getRow() == row && hr.getLastRow() == row) {
                i2.remove();
                continue;
            }
            hr.removeRow(row);
        }
        if (this.dataValidation != null) {
            this.dataValidation.removeRow(row);
        }
        this.mergedCells.removeRow(row);
        ArrayList<Integer> newRowBreaks = new ArrayList<Integer>();
        for (int val : this.rowBreaks) {
            if (val == row) continue;
            if (val > row) {
                --val;
            }
            newRowBreaks.add(new Integer(val));
        }
        this.rowBreaks = newRowBreaks;
        for (ConditionalFormat cf : this.conditionalFormats) {
            cf.removeRow(row);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowRemoved(this, row);
        }
        --this.numRows;
    }

    public void addCell(WritableCell cell) throws WriteException, RowsExceededException {
        if (cell.getType() == CellType.EMPTY && cell != null && cell.getCellFormat() == null) {
            return;
        }
        CellValue cv = (CellValue)cell;
        if (cv.isReferenced()) {
            throw new JxlWriteException(JxlWriteException.cellReferenced);
        }
        int row = cell.getRow();
        RowRecord rowrec = this.getRowRecord(row);
        rowrec.addCell(cv);
        this.numRows = Math.max(row + 1, this.numRows);
        this.numColumns = Math.max(this.numColumns, rowrec.getMaxColumn());
        cv.setCellDetails(this.formatRecords, this.sharedStrings, this);
    }

    RowRecord getRowRecord(int row) throws RowsExceededException {
        RowRecord rowrec;
        if (row >= 65536) {
            throw new RowsExceededException();
        }
        if (row >= this.rows.length) {
            RowRecord[] oldRows = this.rows;
            this.rows = new RowRecord[Math.max(oldRows.length + 10, row + 1)];
            System.arraycopy(oldRows, 0, this.rows, 0, oldRows.length);
            oldRows = null;
        }
        if ((rowrec = this.rows[row]) == null) {
            this.rows[row] = rowrec = new RowRecord(row, this);
        }
        return rowrec;
    }

    RowRecord getRowInfo(int r) {
        if (r < 0 || r > this.rows.length) {
            return null;
        }
        return this.rows[r];
    }

    ColumnInfoRecord getColumnInfo(int c) {
        Iterator<Object> i = this.columnFormats.iterator();
        ColumnInfoRecord cir = null;
        boolean stop = false;
        while (i.hasNext() && !stop) {
            cir = (ColumnInfoRecord)i.next();
            if (cir.getColumn() < c) continue;
            stop = true;
        }
        if (!stop) {
            return null;
        }
        return cir.getColumn() == c ? cir : null;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setHidden(boolean h) {
        this.settings.setHidden(h);
    }

    public void setProtected(boolean prot) {
        this.settings.setProtected(prot);
    }

    public void setSelected() {
        this.settings.setSelected();
    }

    public boolean isHidden() {
        return this.settings.isHidden();
    }

    public void setColumnView(int col, int width) {
        CellView cv = new CellView();
        cv.setSize(width * 256);
        this.setColumnView(col, cv);
    }

    public void setColumnView(int col, int width, CellFormat format) {
        CellView cv = new CellView();
        cv.setSize(width * 256);
        cv.setFormat(format);
        this.setColumnView(col, cv);
    }

    public void setColumnView(int col, CellView view) {
        block8: {
            XFRecord xfr = (XFRecord)view.getFormat();
            if (xfr == null) {
                Styles styles = this.getWorkbook().getStyles();
                xfr = styles.getNormalStyle();
            }
            try {
                int width;
                if (!xfr.isInitialized()) {
                    this.formatRecords.addStyle(xfr);
                }
                int n = width = view.depUsed() ? view.getDimension() * 256 : view.getSize();
                if (view.isAutosize()) {
                    this.autosizedColumns.add(new Integer(col));
                }
                ColumnInfoRecord cir = new ColumnInfoRecord(col, width, xfr);
                if (view.isHidden()) {
                    cir.setHidden(true);
                }
                if (!this.columnFormats.contains(cir)) {
                    this.columnFormats.add(cir);
                } else {
                    this.columnFormats.remove(cir);
                    this.columnFormats.add(cir);
                }
            }
            catch (NumFormatRecordsException e) {
                logger.warn("Maximum number of format records exceeded.  Using default format.");
                ColumnInfoRecord cir = new ColumnInfoRecord(col, view.getDimension() * 256, WritableWorkbook.NORMAL_STYLE);
                if (this.columnFormats.contains(cir)) break block8;
                this.columnFormats.add(cir);
            }
        }
    }

    public void setRowView(int row, int height) throws RowsExceededException {
        CellView cv = new CellView();
        cv.setSize(height);
        cv.setHidden(false);
        this.setRowView(row, cv);
    }

    public void setRowView(int row, boolean collapsed) throws RowsExceededException {
        CellView cv = new CellView();
        cv.setHidden(collapsed);
        this.setRowView(row, cv);
    }

    public void setRowView(int row, int height, boolean collapsed) throws RowsExceededException {
        CellView cv = new CellView();
        cv.setSize(height);
        cv.setHidden(collapsed);
        this.setRowView(row, cv);
    }

    public void setRowView(int row, CellView view) throws RowsExceededException {
        RowRecord rowrec = this.getRowRecord(row);
        XFRecord xfr = (XFRecord)view.getFormat();
        try {
            if (xfr != null && !xfr.isInitialized()) {
                this.formatRecords.addStyle(xfr);
            }
        }
        catch (NumFormatRecordsException e) {
            logger.warn("Maximum number of format records exceeded.  Using default format.");
            xfr = null;
        }
        rowrec.setRowDetails(view.getSize(), false, view.isHidden(), 0, false, xfr);
        this.numRows = Math.max(this.numRows, row + 1);
    }

    public void write() throws IOException {
        boolean dmod = this.drawingsModified;
        if (this.workbook.getDrawingGroup() != null) {
            dmod |= this.workbook.getDrawingGroup().hasDrawingsOmitted();
        }
        if (this.autosizedColumns.size() > 0) {
            this.autosizeColumns();
        }
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.columnBreaks, this.hyperlinks, this.mergedCells, this.columnFormats, this.maxRowOutlineLevel, this.maxColumnOutlineLevel);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.setSettings(this.settings);
        this.sheetWriter.setPLS(this.plsRecord);
        this.sheetWriter.setDrawings(this.drawings, dmod);
        this.sheetWriter.setButtonPropertySet(this.buttonPropertySet);
        this.sheetWriter.setDataValidation(this.dataValidation, this.validatedCells);
        this.sheetWriter.setConditionalFormats(this.conditionalFormats);
        this.sheetWriter.setAutoFilter(this.autoFilter);
        this.sheetWriter.write();
    }

    void copy(Sheet s) {
        this.settings = new SheetSettings(s.getSettings(), this);
        SheetCopier si = new SheetCopier(s, this);
        si.setColumnFormats(this.columnFormats);
        si.setFormatRecords(this.formatRecords);
        si.setHyperlinks(this.hyperlinks);
        si.setMergedCells(this.mergedCells);
        si.setRowBreaks(this.rowBreaks);
        si.setColumnBreaks(this.columnBreaks);
        si.setSheetWriter(this.sheetWriter);
        si.setDrawings(this.drawings);
        si.setImages(this.images);
        si.setConditionalFormats(this.conditionalFormats);
        si.copySheet();
        this.dataValidation = si.getDataValidation();
        this.comboBox = si.getComboBox();
        this.plsRecord = si.getPLSRecord();
        this.chartOnly = si.isChartOnly();
        this.buttonPropertySet = si.getButtonPropertySet();
        this.numRows = si.getRows();
        this.autoFilter = si.getAutoFilter();
        this.maxRowOutlineLevel = si.getMaxRowOutlineLevel();
        this.maxColumnOutlineLevel = si.getMaxColumnOutlineLevel();
    }

    final HeaderRecord getHeader() {
        return this.sheetWriter.getHeader();
    }

    final FooterRecord getFooter() {
        return this.sheetWriter.getFooter();
    }

    public boolean isProtected() {
        return this.settings.isProtected();
    }

    public Hyperlink[] getHyperlinks() {
        Hyperlink[] hl = new Hyperlink[this.hyperlinks.size()];
        int i = 0;
        while (i < this.hyperlinks.size()) {
            hl[i] = this.hyperlinks.get(i);
            ++i;
        }
        return hl;
    }

    public Range[] getMergedCells() {
        return this.mergedCells.getMergedCells();
    }

    public WritableHyperlink[] getWritableHyperlinks() {
        WritableHyperlink[] hl = new WritableHyperlink[this.hyperlinks.size()];
        int i = 0;
        while (i < this.hyperlinks.size()) {
            hl[i] = this.hyperlinks.get(i);
            ++i;
        }
        return hl;
    }

    public void removeHyperlink(WritableHyperlink h) {
        this.removeHyperlink(h, false);
    }

    public void removeHyperlink(WritableHyperlink h, boolean preserveLabel) {
        this.hyperlinks.remove(this.hyperlinks.indexOf(h));
        if (!preserveLabel) {
            Assert.verify(this.rows.length > h.getRow() && this.rows[h.getRow()] != null);
            this.rows[h.getRow()].removeCell(h.getColumn());
        }
    }

    public void addHyperlink(WritableHyperlink h) throws WriteException, RowsExceededException {
        Label l;
        String cnts;
        Cell c = this.getCell(h.getColumn(), h.getRow());
        String contents = null;
        if (h.isFile() || h.isUNC()) {
            cnts = h.getContents();
            contents = cnts == null ? h.getFile().getPath() : cnts;
        } else if (h.isURL()) {
            cnts = h.getContents();
            contents = cnts == null ? h.getURL().toString() : cnts;
        } else if (h.isLocation()) {
            contents = h.getContents();
        }
        if (c.getType() == CellType.LABEL) {
            l = (Label)c;
            l.setString(contents);
            WritableCellFormat wcf = new WritableCellFormat(l.getCellFormat());
            wcf.setFont(WritableWorkbook.HYPERLINK_FONT);
            l.setCellFormat(wcf);
        } else {
            l = new Label(h.getColumn(), h.getRow(), contents, (CellFormat)WritableWorkbook.HYPERLINK_STYLE);
            this.addCell(l);
        }
        int i = h.getRow();
        while (i <= h.getLastRow()) {
            int j = h.getColumn();
            while (j <= h.getLastColumn()) {
                if (i != h.getRow() && j != h.getColumn() && this.rows.length < h.getLastColumn() && this.rows[i] != null) {
                    this.rows[i].removeCell(j);
                }
                ++j;
            }
            ++i;
        }
        h.initialize(this);
        this.hyperlinks.add(h);
    }

    public Range mergeCells(int col1, int row1, int col2, int row2) throws WriteException, RowsExceededException {
        if (col2 < col1 || row2 < row1) {
            logger.warn("Cannot merge cells - top left and bottom right incorrectly specified");
        }
        if (col2 >= this.numColumns || row2 >= this.numRows) {
            this.addCell(new Blank(col2, row2));
        }
        SheetRangeImpl range = new SheetRangeImpl(this, col1, row1, col2, row2);
        this.mergedCells.add(range);
        return range;
    }

    public void setRowGroup(int row1, int row2, boolean collapsed) throws WriteException, RowsExceededException {
        if (row2 < row1) {
            logger.warn("Cannot merge cells - top and bottom rows incorrectly specified");
        }
        int i = row1;
        while (i <= row2) {
            RowRecord row = this.getRowRecord(i);
            row.incrementOutlineLevel();
            row.setCollapsed(collapsed);
            this.maxRowOutlineLevel = Math.max(this.maxRowOutlineLevel, row.getOutlineLevel());
            ++i;
        }
    }

    public void unsetRowGroup(int row1, int row2) throws WriteException, RowsExceededException {
        if (row2 < row1) {
            logger.warn("Cannot merge cells - top and bottom rows incorrectly specified");
        }
        if (row2 >= this.numRows) {
            logger.warn(row2 + " is greater than the sheet bounds");
            row2 = this.numRows - 1;
        }
        int i = row1;
        while (i <= row2) {
            this.rows[i].decrementOutlineLevel();
            ++i;
        }
        this.maxRowOutlineLevel = 0;
        i = this.rows.length;
        while (i-- > 0) {
            this.maxRowOutlineLevel = Math.max(this.maxRowOutlineLevel, this.rows[i].getOutlineLevel());
        }
    }

    public void setColumnGroup(int col1, int col2, boolean collapsed) throws WriteException, RowsExceededException {
        if (col2 < col1) {
            logger.warn("Cannot merge cells - top and bottom rows incorrectly specified");
        }
        int i = col1;
        while (i <= col2) {
            ColumnInfoRecord cir = this.getColumnInfo(i);
            cir.incrementOutlineLevel();
            cir.setCollapsed(collapsed);
            this.maxColumnOutlineLevel = Math.max(this.maxColumnOutlineLevel, cir.getOutlineLevel());
            ++i;
        }
    }

    public void unsetColumnGroup(int col1, int col2) throws WriteException, RowsExceededException {
        if (col2 < col1) {
            logger.warn("Cannot merge cells - top and bottom rows incorrectly specified");
        }
        int i = col1;
        while (i <= col2) {
            ColumnInfoRecord columnInfoRecord = this.getColumnInfo(i);
            columnInfoRecord.decrementOutlineLevel();
            ++i;
        }
        this.maxColumnOutlineLevel = 0;
        for (ColumnInfoRecord columnInfoRecord : this.columnFormats) {
            this.maxColumnOutlineLevel = Math.max(this.maxColumnOutlineLevel, columnInfoRecord.getOutlineLevel());
        }
    }

    public void unmergeCells(Range r) {
        this.mergedCells.unmergeCells(r);
    }

    public void setHeader(String l, String c, String r) {
        HeaderFooter header = new HeaderFooter();
        header.getLeft().append(l);
        header.getCentre().append(c);
        header.getRight().append(r);
        this.settings.setHeader(header);
    }

    public void setFooter(String l, String c, String r) {
        HeaderFooter footer = new HeaderFooter();
        footer.getLeft().append(l);
        footer.getCentre().append(c);
        footer.getRight().append(r);
        this.settings.setFooter(footer);
    }

    public void setPageSetup(PageOrientation p) {
        this.settings.setOrientation(p);
    }

    public void setPageSetup(PageOrientation p, double hm, double fm) {
        this.settings.setOrientation(p);
        this.settings.setHeaderMargin(hm);
        this.settings.setFooterMargin(fm);
    }

    public void setPageSetup(PageOrientation p, PaperSize ps, double hm, double fm) {
        this.settings.setPaperSize(ps);
        this.settings.setOrientation(p);
        this.settings.setHeaderMargin(hm);
        this.settings.setFooterMargin(fm);
    }

    public SheetSettings getSettings() {
        return this.settings;
    }

    WorkbookSettings getWorkbookSettings() {
        return this.workbookSettings;
    }

    public void addRowPageBreak(int row) {
        Iterator<Integer> i = this.rowBreaks.iterator();
        boolean found = false;
        while (i.hasNext() && !found) {
            if (i.next() != row) continue;
            found = true;
        }
        if (!found) {
            this.rowBreaks.add(new Integer(row));
        }
    }

    public void addColumnPageBreak(int col) {
        Iterator<Integer> i = this.columnBreaks.iterator();
        boolean found = false;
        while (i.hasNext() && !found) {
            if (i.next() != col) continue;
            found = true;
        }
        if (!found) {
            this.columnBreaks.add(new Integer(col));
        }
    }

    private Chart[] getCharts() {
        return this.sheetWriter.getCharts();
    }

    void checkMergedBorders() {
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.columnBreaks, this.hyperlinks, this.mergedCells, this.columnFormats, this.maxRowOutlineLevel, this.maxColumnOutlineLevel);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.checkMergedBorders();
    }

    /*
     * WARNING - void declaration
     */
    void rationalize(IndexMapping xfMapping, IndexMapping fontMapping, IndexMapping formatMapping) {
        void var5_9;
        for (ColumnInfoRecord columnInfoRecord : this.columnFormats) {
            columnInfoRecord.rationalize(xfMapping);
        }
        int i = 0;
        while (i < this.rows.length) {
            if (this.rows[i] != null) {
                this.rows[i].rationalize(xfMapping);
            }
            ++i;
        }
        Chart[] charts = this.getCharts();
        boolean bl = false;
        while (var5_9 < charts.length) {
            charts[var5_9].rationalize(xfMapping, fontMapping, formatMapping);
            ++var5_9;
        }
    }

    WritableWorkbookImpl getWorkbook() {
        return this.workbook;
    }

    public CellFormat getColumnFormat(int col) {
        return this.getColumnView(col).getFormat();
    }

    public int getColumnWidth(int col) {
        return this.getColumnView(col).getDimension();
    }

    public int getRowHeight(int row) {
        return this.getRowView(row).getDimension();
    }

    boolean isChartOnly() {
        return this.chartOnly;
    }

    public CellView getRowView(int row) {
        CellView cv = new CellView();
        try {
            RowRecord rr = this.getRowRecord(row);
            if (rr == null || rr.isDefaultHeight()) {
                cv.setDimension(this.settings.getDefaultRowHeight());
                cv.setSize(this.settings.getDefaultRowHeight());
            } else if (rr.isCollapsed()) {
                cv.setHidden(true);
            } else {
                cv.setDimension(rr.getRowHeight());
                cv.setSize(rr.getRowHeight());
            }
            return cv;
        }
        catch (RowsExceededException e) {
            cv.setDimension(this.settings.getDefaultRowHeight());
            cv.setSize(this.settings.getDefaultRowHeight());
            return cv;
        }
    }

    public CellView getColumnView(int col) {
        ColumnInfoRecord cir = this.getColumnInfo(col);
        CellView cv = new CellView();
        if (cir != null) {
            cv.setDimension(cir.getWidth() / 256);
            cv.setSize(cir.getWidth());
            cv.setHidden(cir.getHidden());
            cv.setFormat(cir.getCellFormat());
        } else {
            cv.setDimension(this.settings.getDefaultColumnWidth() / 256);
            cv.setSize(this.settings.getDefaultColumnWidth() * 256);
        }
        return cv;
    }

    public void addImage(WritableImage image) {
        boolean supported = false;
        java.io.File imageFile = image.getImageFile();
        String fileType = "?";
        if (imageFile != null) {
            String fileName = imageFile.getName();
            int fileTypeIndex = fileName.lastIndexOf(46);
            fileType = fileTypeIndex != -1 ? fileName.substring(fileTypeIndex + 1) : "";
            int i = 0;
            while (i < imageTypes.length && !supported) {
                if (fileType.equalsIgnoreCase(imageTypes[i])) {
                    supported = true;
                }
                ++i;
            }
        } else {
            supported = true;
        }
        if (supported) {
            this.workbook.addDrawing(image);
            this.drawings.add(image);
            this.images.add(image);
        } else {
            StringBuffer message = new StringBuffer("Image type ");
            message.append(fileType);
            message.append(" not supported.  Supported types are ");
            message.append(imageTypes[0]);
            int i = 1;
            while (i < imageTypes.length) {
                message.append(", ");
                message.append(imageTypes[i]);
                ++i;
            }
            logger.warn(message.toString());
        }
    }

    public int getNumberOfImages() {
        return this.images.size();
    }

    public WritableImage getImage(int i) {
        return this.images.get(i);
    }

    public Image getDrawing(int i) {
        return this.images.get(i);
    }

    public void removeImage(WritableImage wi) {
        this.drawings.remove(wi);
        this.images.remove(wi);
        this.drawingsModified = true;
        this.workbook.removeDrawing(wi);
    }

    private String validateName(String n) {
        if (n.length() > 31) {
            logger.warn("Sheet name " + n + " too long - truncating");
            n = n.substring(0, 31);
        }
        if (n.charAt(0) == '\'') {
            logger.warn("Sheet naming cannot start with ' - removing");
            n = n.substring(1);
        }
        int i = 0;
        while (i < illegalSheetNameCharacters.length) {
            String newname = n.replace(illegalSheetNameCharacters[i], '@');
            if (n != newname) {
                logger.warn(String.valueOf(illegalSheetNameCharacters[i]) + " is not a valid character within a sheet name - replacing");
            }
            n = newname;
            ++i;
        }
        return n;
    }

    void addDrawing(DrawingGroupObject o) {
        this.drawings.add(o);
        Assert.verify(!(o instanceof Drawing));
    }

    void removeDrawing(DrawingGroupObject o) {
        int origSize = this.drawings.size();
        this.drawings.remove(o);
        int newSize = this.drawings.size();
        this.drawingsModified = true;
        Assert.verify(newSize == origSize - 1);
    }

    public int[] getRowPageBreaks() {
        int[] rb = new int[this.rowBreaks.size()];
        int pos = 0;
        Iterator<Integer> i = this.rowBreaks.iterator();
        while (i.hasNext()) {
            rb[pos] = i.next();
            ++pos;
        }
        return rb;
    }

    public int[] getColumnPageBreaks() {
        int[] rb = new int[this.columnBreaks.size()];
        int pos = 0;
        Iterator<Integer> i = this.columnBreaks.iterator();
        while (i.hasNext()) {
            rb[pos] = i.next();
            ++pos;
        }
        return rb;
    }

    void addValidationCell(CellValue cv) {
        this.validatedCells.add(cv);
    }

    ComboBox getComboBox() {
        return this.comboBox;
    }

    void setComboBox(ComboBox cb) {
        this.comboBox = cb;
    }

    public DataValidation getDataValidation() {
        return this.dataValidation;
    }

    private void autosizeColumns() {
        for (Integer n : this.autosizedColumns) {
            this.autosizeColumn(n);
        }
    }

    private void autosizeColumn(int col) {
        int maxWidth = 0;
        ColumnInfoRecord cir = this.getColumnInfo(col);
        Font columnFont = cir.getCellFormat().getFont();
        Font defaultFont = WritableWorkbook.NORMAL_STYLE.getFont();
        int i = 0;
        while (i < this.numRows) {
            Cell cell = null;
            if (this.rows[i] != null) {
                cell = this.rows[i].getCell(col);
            }
            if (cell != null) {
                String contents = cell.getContents();
                Font font = cell.getCellFormat().getFont();
                Font activeFont = font.equals(defaultFont) ? columnFont : font;
                int pointSize = activeFont.getPointSize();
                int numChars = contents.length();
                if (activeFont.isItalic() || activeFont.getBoldWeight() > 400) {
                    numChars += 2;
                }
                int points = numChars * pointSize;
                maxWidth = Math.max(maxWidth, points * 256);
            }
            ++i;
        }
        cir.setWidth(maxWidth / defaultFont.getPointSize());
    }

    void importSheet(Sheet s) {
        this.settings = new SheetSettings(s.getSettings(), this);
        SheetCopier si = new SheetCopier(s, this);
        si.setColumnFormats(this.columnFormats);
        si.setFormatRecords(this.formatRecords);
        si.setHyperlinks(this.hyperlinks);
        si.setMergedCells(this.mergedCells);
        si.setRowBreaks(this.rowBreaks);
        si.setColumnBreaks(this.columnBreaks);
        si.setSheetWriter(this.sheetWriter);
        si.setDrawings(this.drawings);
        si.setImages(this.images);
        si.importSheet();
        this.dataValidation = si.getDataValidation();
        this.comboBox = si.getComboBox();
        this.plsRecord = si.getPLSRecord();
        this.chartOnly = si.isChartOnly();
        this.buttonPropertySet = si.getButtonPropertySet();
        this.numRows = si.getRows();
        this.maxRowOutlineLevel = si.getMaxRowOutlineLevel();
        this.maxColumnOutlineLevel = si.getMaxColumnOutlineLevel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnInfoComparator
    implements Comparator<Object> {
        private ColumnInfoComparator() {
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            Assert.verify(o1 instanceof ColumnInfoRecord);
            Assert.verify(o2 instanceof ColumnInfoRecord);
            ColumnInfoRecord ci1 = (ColumnInfoRecord)o1;
            ColumnInfoRecord ci2 = (ColumnInfoRecord)o2;
            return ci1.getColumn() - ci2.getColumn();
        }
    }
}

