/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.calculations;

import java.util.List;
import jprofilegrid.calculations.MultipleSequenceAnalysis;
import jprofilegrid.calculations.Sequence;
import jprofilegrid.constants.AlignmentConstants;
import jprofilegrid.constants.AminoAcidConstants;
import jprofilegrid.constants.DNAConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleSequenceAlignment {
    private AlignmentConstants alignmentConstants = new AminoAcidConstants();
    private MultipleSequenceAnalysis multipleSequenceAnalysis;
    private List<String> header;
    private List<Sequence> sequences;
    int minSequenceLength;
    private String alignmentName = "";

    public MultipleSequenceAlignment(List<String> header, List<Sequence> sequences) {
        this.header = header;
        this.sequences = sequences;
        this.findMinSequenceLength();
    }

    public AlignmentConstants getAlignmentConstants() {
        return this.alignmentConstants;
    }

    public List<String> getHeader() {
        return this.header;
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }

    private void findMinSequenceLength() {
        this.minSequenceLength = Integer.MAX_VALUE;
        for (Sequence sequence : this.sequences) {
            int length = sequence.getActualLength();
            if (length >= this.minSequenceLength) continue;
            this.minSequenceLength = length;
        }
        if (this.minSequenceLength == Integer.MAX_VALUE) {
            this.minSequenceLength = 0;
        }
    }

    public void setAlignmentName(String alignmentName) {
        this.alignmentName = alignmentName;
    }

    public void setAlignmentType(int alignmentType) {
        this.alignmentConstants = alignmentType == 1 ? new DNAConstants() : new AminoAcidConstants();
    }

    public void setMultipleSequenceAnalysis(MultipleSequenceAnalysis multipleSequenceAnalysis) {
        this.multipleSequenceAnalysis = multipleSequenceAnalysis;
    }

    public MultipleSequenceAnalysis getMultipleSequenceAnalysis() {
        return this.multipleSequenceAnalysis;
    }

    public int getMinSequenceLength() {
        return this.minSequenceLength;
    }

    public String getAlignmentName() {
        return this.alignmentName;
    }
}

