/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.calculations;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jprofilegrid.calculations.MultipleSequenceAlignment;
import jprofilegrid.calculations.Sequence;
import jprofilegrid.constants.AlignmentConstants;
import jprofilegrid.constants.AminoAcidConstants;
import jprofilegrid.model.AnalysisOptions;
import jprofilegrid.model.UnknownSymbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleSequenceAnalysis {
    private Vector<Vector<Double>> correctedWindowSizes;
    private int[] motiffEndpointIndices;
    private int[] variableEndpointIndices;
    private int windowLength;
    private Vector<UnknownSymbol> unkSymbolInSeq;
    private String weightedString;

    private MultipleSequenceAnalysis(Vector<Vector<Double>> nUncorrectedWindowSizes, int nWindowLength, Vector<Vector<Double>> nCorrectedWindowSizes, int[] motiffEndpoints, int[] nVariableEndpointIndices, Vector<UnknownSymbol> nUnknownSymbolsInSequences, String nWeightedString) {
        this.windowLength = nWindowLength;
        this.correctedWindowSizes = nCorrectedWindowSizes;
        this.motiffEndpointIndices = motiffEndpoints;
        this.variableEndpointIndices = nVariableEndpointIndices;
        this.unkSymbolInSeq = nUnknownSymbolsInSequences;
        this.weightedString = nWeightedString;
    }

    public Vector<Vector<Double>> getWindowSizes() {
        return this.correctedWindowSizes;
    }

    public int getWindowLength() {
        return this.windowLength;
    }

    public Vector<Vector<Double>> getCorrected() {
        return this.correctedWindowSizes;
    }

    public int[] getMotiffEndpointIndices() {
        return this.motiffEndpointIndices;
    }

    public int[] getVariableEndpointIndices() {
        return this.variableEndpointIndices;
    }

    private static MultipleSequenceAlignment sampleAlignment(MultipleSequenceAlignment multipleSequenceAlignment, int numSamples) {
        int rows;
        Vector<Sequence> sampledSequences = new Vector<Sequence>();
        int seqCount = multipleSequenceAlignment.getSequences().size();
        double stepSize = 1.0;
        if (seqCount < numSamples) {
            rows = seqCount;
        } else {
            rows = numSamples;
            stepSize = (double)seqCount / (double)numSamples;
        }
        double nextSeq = 0.0;
        for (int i = 0; i < rows; ++i) {
            int index = (int)nextSeq;
            if (nextSeq == (double)seqCount) {
                index = (int)nextSeq - 1;
            }
            Sequence s = multipleSequenceAlignment.getSequences().get(index);
            sampledSequences.add(s);
            nextSeq += stepSize;
        }
        return new MultipleSequenceAlignment(multipleSequenceAlignment.getHeader(), sampledSequences);
    }

    public static void analyze(MultipleSequenceAlignment original, AnalysisOptions analysisOptions) {
        int windowLength = analysisOptions.windowSize;
        double threshold = analysisOptions.threshold;
        String weightedString = analysisOptions.weightedString;
        AlignmentConstants constants = analysisOptions.alignmentConstants;
        Vector<Double> columnValues = new Vector<Double>();
        Vector<Integer> gapsPerColumn = new Vector<Integer>();
        int originalNumberOfSequences = original.getSequences().size();
        int numberOfSequences = Math.min((int)(analysisOptions.similarityFraction * (double)originalNumberOfSequences), originalNumberOfSequences);
        if (numberOfSequences <= 0) {
            numberOfSequences = 1;
        }
        MultipleSequenceAlignment alignment = MultipleSequenceAnalysis.sampleAlignment(original, numberOfSequences);
        int minimumLength = alignment.getMinSequenceLength();
        Hashtable<String, UnknownSymbol> unknownSymbols = new Hashtable<String, UnknownSymbol>();
        List<Sequence> sequences = alignment.getSequences();
        for (int columnNumber = 0; columnNumber < minimumLength; ++columnNumber) {
            int gapsInCurrentColumn = 0;
            double columnSum = 0.0;
            for (int i = 0; i < numberOfSequences; ++i) {
                Sequence sequence = sequences.get(i);
                String aa1 = sequence.getAminoAcid(columnNumber);
                double aa1w = sequence.getWeight();
                String currentSymbol = sequence.getAminoAcid(columnNumber);
                if (!constants.isSymbolDefined(currentSymbol)) {
                    String sequenceName = sequence.getName();
                    if (unknownSymbols.containsKey(currentSymbol)) {
                        ((UnknownSymbol)unknownSymbols.get(currentSymbol)).addUnknownSymbolSpeciesAndLocation(sequenceName, columnNumber + 1);
                    } else {
                        unknownSymbols.put(currentSymbol, new UnknownSymbol(currentSymbol, sequenceName, columnNumber + 1));
                    }
                }
                for (int j = i + 1; j < numberOfSequences; ++j) {
                    Sequence sequence2 = sequences.get(j);
                    String aa2 = sequence2.getAminoAcid(columnNumber);
                    double aa2w = sequence2.getWeight();
                    columnSum += AminoAcidConstants.getMatrixValue(aa1, aa2) * aa2w;
                    columnSum += AminoAcidConstants.getMatrixValue(aa2, aa1) * aa1w;
                }
            }
            gapsPerColumn.add(gapsInCurrentColumn);
            columnValues.add(columnSum);
        }
        Vector<Vector<Double>> ucWS = new Vector<Vector<Double>>();
        ucWS.add(null);
        for (int k = 1; k <= windowLength; ++k) {
            Vector<Double> uncorrectedSimilarities = new Vector<Double>();
            for (int leftColumn = -(k / 2); leftColumn < minimumLength - k / 2; ++leftColumn) {
                double plotcon = 0.0;
                if (leftColumn >= 0 && leftColumn + k <= minimumLength) {
                    for (int i = leftColumn; i < leftColumn + k; ++i) {
                        plotcon += ((Double)columnValues.get(i)).doubleValue();
                    }
                }
                double divisor = numberOfSequences * k * (numberOfSequences - 1) * k;
                double currentValue = plotcon / divisor;
                uncorrectedSimilarities.add(currentValue);
            }
            ucWS.add(uncorrectedSimilarities);
        }
        Vector<UnknownSymbol> allUnknownSymbols = new Vector<UnknownSymbol>();
        Iterator it = unknownSymbols.values().iterator();
        while (it.hasNext()) {
            allUnknownSymbols.add((UnknownSymbol)it.next());
        }
        MultipleSequenceAnalysis multipleSequenceAnalysis = MultipleSequenceAnalysis.performCorrections(alignment, ucWS, gapsPerColumn, numberOfSequences, windowLength, minimumLength, threshold, allUnknownSymbols, weightedString);
        original.setMultipleSequenceAnalysis(multipleSequenceAnalysis);
    }

    private static MultipleSequenceAnalysis performCorrections(MultipleSequenceAlignment alignment, Vector<Vector<Double>> ucWS, Vector<Integer> gapsPerColumn, int numberOfSequences, int windowLength, int minimumLength, double threshold, Vector<UnknownSymbol> unknownSymbolsInSequences, String weightedString) {
        Vector<Vector<Double>> correctedWindowSizes = new Vector<Vector<Double>>();
        for (int i = 0; i < ucWS.size(); ++i) {
            correctedWindowSizes.add(new Vector());
        }
        int maximumOccuringAminoAcidInColumn = 0;
        for (int k = 1; k <= windowLength; ++k) {
            int i;
            int i2;
            for (int i3 = 0; i3 < ucWS.get(k).size(); ++i3) {
                correctedWindowSizes.get(k).add(ucWS.get(k).get(i3));
            }
            double minValue = Double.MAX_VALUE;
            for (i2 = 0; i2 < correctedWindowSizes.get(k).size(); ++i2) {
                if (!(correctedWindowSizes.get(k).get(i2) < minValue)) continue;
                minValue = correctedWindowSizes.get(k).get(i2);
            }
            for (i2 = 0; i2 < correctedWindowSizes.get(k).size(); ++i2) {
                correctedWindowSizes.get(k).set(i2, correctedWindowSizes.get(k).get(i2) - minValue);
            }
            for (i2 = 0; i2 < correctedWindowSizes.get(k).size(); ++i2) {
                correctedWindowSizes.get(k).set(i2, correctedWindowSizes.get(k).get(i2) * (((double)numberOfSequences - (double)gapsPerColumn.get(i2).intValue()) / (double)numberOfSequences));
            }
            double maxValue = Double.MIN_VALUE;
            int maxColumnIndex = 0;
            for (int i4 = 0; i4 < correctedWindowSizes.get(k).size(); ++i4) {
                if (!(correctedWindowSizes.get(k).get(i4) > maxValue)) continue;
                maxValue = correctedWindowSizes.get(k).get(i4);
                maxColumnIndex = i4;
            }
            Hashtable<String, Integer> aminoAcidLookupTable = new Hashtable<String, Integer>();
            Vector<Integer> aminoAcidCounts = new Vector<Integer>();
            Vector<String> aminoAcidNames = new Vector<String>();
            for (int i5 = 0; i5 < numberOfSequences; ++i5) {
                String currentAminoAcid = alignment.getSequences().get(i5).getAminoAcid(maxColumnIndex);
                if (!aminoAcidLookupTable.containsKey(currentAminoAcid)) {
                    aminoAcidLookupTable.put(currentAminoAcid, aminoAcidCounts.size());
                    aminoAcidCounts.add(1);
                    aminoAcidNames.add(currentAminoAcid);
                    continue;
                }
                aminoAcidCounts.set((Integer)aminoAcidLookupTable.get(currentAminoAcid), (Integer)aminoAcidCounts.get((Integer)aminoAcidLookupTable.get(currentAminoAcid)) + 1);
            }
            int maximumOccurence = 0;
            int indexOfMaximalOccurence = 0;
            for (int i6 = 0; i6 < aminoAcidCounts.size(); ++i6) {
                if ((Integer)aminoAcidCounts.get(i6) <= maximumOccurence) continue;
                maximumOccurence = (Integer)aminoAcidCounts.get(i6);
                indexOfMaximalOccurence = i6;
            }
            maximumOccuringAminoAcidInColumn = (Integer)aminoAcidCounts.get(indexOfMaximalOccurence);
            double normalizationConstant = 1.0 / correctedWindowSizes.get(k).get(maxColumnIndex);
            for (i = 0; i < correctedWindowSizes.get(k).size(); ++i) {
                correctedWindowSizes.get(k).set(i, correctedWindowSizes.get(k).get(i) * normalizationConstant);
            }
            for (i = 0; i < correctedWindowSizes.get(k).size(); ++i) {
                correctedWindowSizes.get(k).set(i, correctedWindowSizes.get(k).get(i) * ((double)maximumOccuringAminoAcidInColumn / (double)numberOfSequences));
            }
        }
        return MultipleSequenceAnalysis.calculateMotiffEndpoints(ucWS, windowLength, correctedWindowSizes, threshold, unknownSymbolsInSequences, weightedString);
    }

    private static MultipleSequenceAnalysis calculateMotiffEndpoints(Vector<Vector<Double>> ucWS, int windowLength, Vector<Vector<Double>> cWS, double threshold, Vector<UnknownSymbol> unknownSymbolsInSequences, String weightedString) {
        int i;
        Vector<Double> columnValuesInDefaultWindow = cWS.get(windowLength);
        Vector<Integer> motiffEndpoints = new Vector<Integer>();
        Vector<Integer> variableEndpoints = new Vector<Integer>();
        boolean leftEndpointSearch = true;
        for (i = 0; i < columnValuesInDefaultWindow.size(); ++i) {
            if (leftEndpointSearch) {
                if (!(columnValuesInDefaultWindow.get(i) > threshold)) continue;
                motiffEndpoints.add(i);
                leftEndpointSearch = false;
                continue;
            }
            if (!(columnValuesInDefaultWindow.get(i) < threshold)) continue;
            motiffEndpoints.add(i);
            leftEndpointSearch = true;
        }
        if (motiffEndpoints.size() % 2 == 1) {
            motiffEndpoints.add(cWS.get(windowLength).size() - 1);
        }
        for (i = 0; i < motiffEndpoints.size(); ++i) {
            if (i == 0) {
                if ((Integer)motiffEndpoints.get(0) == 0) continue;
                variableEndpoints.add(0);
                variableEndpoints.add((Integer)motiffEndpoints.get(i) - 1);
                continue;
            }
            if ((Integer)motiffEndpoints.get(i - 1) + 1 != (Integer)motiffEndpoints.get(i) && i % 2 == 0) {
                variableEndpoints.add((Integer)motiffEndpoints.get(i) - 1);
                continue;
            }
            if (i < motiffEndpoints.size() - 1) {
                if ((Integer)motiffEndpoints.get(i + 1) - 1 == (Integer)motiffEndpoints.get(i) || i % 2 != 1) continue;
                variableEndpoints.add((Integer)motiffEndpoints.get(i) + 1);
                continue;
            }
            if (i != motiffEndpoints.size() - 1 || (Integer)motiffEndpoints.get(i) == cWS.get(windowLength).size() - 1) continue;
            variableEndpoints.add((Integer)motiffEndpoints.get(i) + 1);
            variableEndpoints.add(cWS.get(windowLength).size() - 1);
        }
        if (variableEndpoints.size() % 2 == 1) {
            variableEndpoints.add(cWS.get(windowLength).size() - 1);
        }
        int[] motiffEndpointsIntArray = new int[motiffEndpoints.size()];
        for (int i2 = 0; i2 < motiffEndpoints.size(); ++i2) {
            motiffEndpointsIntArray[i2] = (Integer)motiffEndpoints.get(i2);
        }
        int[] variableEndpointsIntArray = new int[variableEndpoints.size()];
        for (int i3 = 0; i3 < variableEndpoints.size(); ++i3) {
            variableEndpointsIntArray[i3] = (Integer)variableEndpoints.get(i3);
        }
        return new MultipleSequenceAnalysis(ucWS, windowLength, cWS, motiffEndpointsIntArray, variableEndpointsIntArray, unknownSymbolsInSequences, weightedString);
    }

    public Vector<UnknownSymbol> getUnknownSymbols() {
        return this.unkSymbolInSeq;
    }

    public String getWeightedString() {
        return this.weightedString;
    }
}

