/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.calculations;

import java.util.Hashtable;
import java.util.List;
import jprofilegrid.calculations.MultipleSequenceAlignment;
import jprofilegrid.calculations.Sequence;
import jprofilegrid.constants.SortedAminoAcidNamesAndSymbols;
import jprofilegrid.model.AnalysisOptions;

public class ResidueFrequencyCount {
    private SortedAminoAcidNamesAndSymbols sortedAminoAcidNamesAndSymbols;
    private int[][] aminoAcidCounts;
    private static final int NUMBER_OF_THREADS = 16;
    private static int numThreads;
    private static Object monitor;

    public ResidueFrequencyCount(SortedAminoAcidNamesAndSymbols nSortedAminoAcidNamesAndSymbols, int[][] AACounts) {
        this.sortedAminoAcidNamesAndSymbols = nSortedAminoAcidNamesAndSymbols;
        this.aminoAcidCounts = AACounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void analyze(MultipleSequenceAlignment multipleSequenceAlignment, final AnalysisOptions analysisOptions) {
        SortedAminoAcidNamesAndSymbols sortedAminoAcidNamesAndSymbols = SortedAminoAcidNamesAndSymbols.sort(analysisOptions.sortType, analysisOptions.sortAscending, analysisOptions.alignmentConstants);
        final Hashtable<Character, Integer> aaSymbolIndexHashtable = new Hashtable<Character, Integer>();
        String[] sortedAminoAcidSymbols = sortedAminoAcidNamesAndSymbols.getSortedAminoAcidSymbols();
        for (int i = 0; i < sortedAminoAcidSymbols.length; ++i) {
            aaSymbolIndexHashtable.put(Character.valueOf(sortedAminoAcidSymbols[i].toCharArray()[0]), i);
        }
        final List<Sequence> sequences = multipleSequenceAlignment.getSequences();
        final int numSymbols = sortedAminoAcidSymbols.length;
        final int numSequences = analysisOptions.sequenceIndicesInMSA.size();
        int seqLen = multipleSequenceAlignment.getMinSequenceLength();
        final int[][] AACounts = new int[seqLen][numSymbols];
        numThreads = 16;
        int numColPerThread = seqLen / 16;
        int leftOvers = seqLen % 16;
        for (int i = 0; i < 16; ++i) {
            int rangeStart = i * numColPerThread;
            int rangeEnd = rangeStart + numColPerThread;
            if (i == 15) {
                rangeEnd += leftOvers;
            }
            final int start = rangeStart;
            final int end = rangeEnd;
            Runnable aminoAcidCounter = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    for (int j = start; j < end; ++j) {
                        int[] aminoAcidCounts = new int[numSymbols];
                        for (int i = 0; i < numSequences; ++i) {
                            Sequence currentSequence = (Sequence)sequences.get(analysisOptions.sequenceIndicesInMSA.get(i));
                            char currentAminoAcid = currentSequence.getAminoAcidChar(j);
                            Integer index = (Integer)aaSymbolIndexHashtable.get(Character.valueOf(currentAminoAcid));
                            if (index != null && index != numSymbols - 1) {
                                int n = index;
                                aminoAcidCounts[n] = aminoAcidCounts[n] + 1;
                                continue;
                            }
                            if (currentAminoAcid != '-' && currentAminoAcid != '.') continue;
                            int n = numSymbols - 1;
                            aminoAcidCounts[n] = aminoAcidCounts[n] + 1;
                        }
                        AACounts[j] = aminoAcidCounts;
                    }
                    Object object = monitor;
                    synchronized (object) {
                        numThreads--;
                        if (numThreads == 0) {
                            monitor.notify();
                        }
                    }
                }
            };
            new Thread(aminoAcidCounter).start();
        }
        Object object = monitor;
        synchronized (object) {
            try {
                monitor.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        analysisOptions.sortedData = new ResidueFrequencyCount(sortedAminoAcidNamesAndSymbols, AACounts);
    }

    public int[][] getAminoAcidCounts() {
        return this.aminoAcidCounts;
    }

    public String[] getSortedAminoAcidNames() {
        return this.sortedAminoAcidNamesAndSymbols.getSortedAminoAcidNames();
    }

    public String[] getSortedAminoAcidSymbols() {
        return this.sortedAminoAcidNamesAndSymbols.getSortedAminoAcidSymbols();
    }

    public String getSortType() {
        return this.sortedAminoAcidNamesAndSymbols.getSortType();
    }

    static {
        monitor = new Object();
    }
}

