/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.calculations;

import java.util.Vector;
import jprofilegrid.calculations.MultipleSequenceAnalysis;
import jprofilegrid.calculations.ResidueFrequencyCount;
import jprofilegrid.calculations.Sequence;
import jprofilegrid.constants.AlignmentConstants;
import jprofilegrid.model.AnalysisOptions;
import jprofilegrid.model.Cell;
import jprofilegrid.model.ConservationRange;
import jprofilegrid.model.Format;
import jprofilegrid.model.Numeric;
import jprofilegrid.model.ProfileGrid;
import jprofilegrid.model.Text;
import jprofilegrid.model.Tier;
import jprofilegrid.model.UnknownSymbol;

public class ResidueFrequencyCountToProfileGrid {
    private static int showValuesAs;
    private static int numberOfSequences;
    private static int numberOfAminoAcids;
    private static int alignmentLength;
    private static Text referenceSequenceName;
    private static Text highlightSequenceName;
    private static Text[] positionInAlignmentRow;
    private static Text[] motiffNumberingRow;
    private static Text[] majorAminoAcidRow;
    private static Text[] referenceSequenceRow;
    private static Text[] highlightSequenceRow;
    private static Text[] highlightSequenceArray;
    private static Cell[][] aminoAcidCounts;
    private static String referenceSequenceNameString;
    private static String highlightSequenceNameString;
    private static Tier entireAlignment;
    private static int[] motiffEndpointIndices;
    private static int[] variableRegionEnpointIndices;
    private static int[] numberOfMotiffAndVariableRegions;
    private static Vector<Double> plotSimValues;

    public static void computeProfileGrid(ProfileGrid profileGrid, MultipleSequenceAnalysis multipleSequenceAnalysis) {
        Sequence highlightSequence;
        AnalysisOptions analysisOptions = profileGrid.getAnalysisOptions();
        ResidueFrequencyCount sortedData = analysisOptions.sortedData;
        Vector<UnknownSymbol> unknownSymbols = null;
        if (multipleSequenceAnalysis != null) {
            unknownSymbols = new Vector();
            plotSimValues = multipleSequenceAnalysis.getCorrected().get(multipleSequenceAnalysis.getWindowLength());
            motiffEndpointIndices = multipleSequenceAnalysis.getMotiffEndpointIndices();
            variableRegionEnpointIndices = multipleSequenceAnalysis.getVariableEndpointIndices();
            unknownSymbols = multipleSequenceAnalysis.getUnknownSymbols();
        }
        numberOfAminoAcids = sortedData.getSortedAminoAcidNames().length;
        alignmentLength = sortedData.getAminoAcidCounts().length;
        positionInAlignmentRow = new Text[alignmentLength];
        highlightSequenceArray = new Text[alignmentLength];
        motiffNumberingRow = new Text[alignmentLength];
        majorAminoAcidRow = new Text[alignmentLength];
        referenceSequenceRow = new Text[alignmentLength];
        highlightSequenceRow = new Text[alignmentLength];
        aminoAcidCounts = new Cell[alignmentLength][numberOfAminoAcids];
        int[] positionInAlignmentRowWithoutSkippingGaps = new int[alignmentLength];
        ConservationRange conservationRanges = analysisOptions.conservationRange;
        AlignmentConstants alignmentConstants = analysisOptions.alignmentConstants;
        String inputFilename = analysisOptions.inputFilename;
        double threshold = analysisOptions.threshold;
        boolean frequencyColorsEnabled = analysisOptions.frequencyColorsEnabled;
        int highlightType = analysisOptions.highlightType;
        int highlightThresholdType = analysisOptions.highlightThresholdType;
        double highlightThreshold = analysisOptions.highlightThreshold;
        Sequence referenceSequence = analysisOptions.referenceSequence;
        if (referenceSequence != null) {
            referenceSequenceNameString = referenceSequence.getName();
        }
        if ((highlightSequence = analysisOptions.highlightSequence) != null) {
            highlightSequenceNameString = highlightSequence.getName();
        }
        referenceSequenceName = new Text(new Format(Format.RIGHT_ALIGNED, true), referenceSequenceNameString);
        highlightSequenceName = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), highlightSequenceNameString.equalsIgnoreCase(referenceSequenceNameString) ? "" : highlightSequenceNameString);
        if (!highlightSequenceName.getValue().equalsIgnoreCase("") && highlightType == 0) {
            highlightSequenceName.getFormat().setBorderColor(analysisOptions.highlightSequenceColour);
        }
        showValuesAs = analysisOptions.showValuesAs;
        numberOfSequences = analysisOptions.sequenceIndicesInMSA.size();
        String[] aminoAcidSymbols = sortedData.getSortedAminoAcidSymbols();
        for (int i = 0; i < alignmentLength; ++i) {
            ResidueFrequencyCountToProfileGrid.positionInAlignmentRow[i] = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "");
            ResidueFrequencyCountToProfileGrid.highlightSequenceArray[i] = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "");
            ResidueFrequencyCountToProfileGrid.motiffNumberingRow[i] = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "");
            ResidueFrequencyCountToProfileGrid.majorAminoAcidRow[i] = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "");
            ResidueFrequencyCountToProfileGrid.referenceSequenceRow[i] = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "");
            ResidueFrequencyCountToProfileGrid.highlightSequenceRow[i] = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), highlightSequenceNameString.equalsIgnoreCase(referenceSequenceNameString) || highlightSequence == null ? "" : highlightSequence.getAminoAcid(i));
            for (int j = 0; j < numberOfAminoAcids; ++j) {
                double curData = 0.0;
                if (showValuesAs != 3) {
                    curData = (double)sortedData.getAminoAcidCounts()[i][j] / (showValuesAs == 0 ? 1.0 : (double)numberOfSequences);
                    ResidueFrequencyCountToProfileGrid.aminoAcidCounts[i][j] = new Numeric(new Format(Format.CENTER_ALIGNED, Format.NOT_BOLD), curData);
                } else {
                    ResidueFrequencyCountToProfileGrid.aminoAcidCounts[i][j] = new Text(new Format(Format.CENTER_ALIGNED, Format.NOT_BOLD), "");
                }
                if (showValuesAs != 2) continue;
                ResidueFrequencyCountToProfileGrid.aminoAcidCounts[i][j] = sortedData.getAminoAcidCounts()[i][j] != 0 ? new Text(new Format(Format.CENTER_ALIGNED, Format.NOT_BOLD), aminoAcidSymbols[j]) : new Text(new Format(Format.CENTER_ALIGNED, Format.NOT_BOLD), "");
            }
        }
        entireAlignment = new Tier(positionInAlignmentRow, motiffNumberingRow, majorAminoAcidRow, referenceSequenceRow, aminoAcidCounts, alignmentConstants, sortedData.getAminoAcidCounts(), positionInAlignmentRowWithoutSkippingGaps, highlightSequenceArray);
        entireAlignment.setHighlightSequenceRow(highlightSequenceRow);
        if (multipleSequenceAnalysis != null && analysisOptions.similarityParametersEnabled) {
            numberOfMotiffAndVariableRegions = ResidueFrequencyCountToProfileGrid.calculateNumberOfMotiffAndVariableRegions();
            ResidueFrequencyCountToProfileGrid.calculateMotiffBorderings();
        }
        if (frequencyColorsEnabled) {
            ResidueFrequencyCountToProfileGrid.calculateConservedCellColors(entireAlignment.getAminoAcidCounts(), conservationRanges, numberOfSequences, sortedData);
        }
        ResidueFrequencyCountToProfileGrid.calculateMajorRow(entireAlignment, sortedData.getSortedAminoAcidSymbols(), threshold * (double)numberOfSequences, sortedData);
        ResidueFrequencyCountToProfileGrid.calculatePositionRow(analysisOptions, entireAlignment.getPositionInAlignmentRow(), positionInAlignmentRowWithoutSkippingGaps);
        if (!highlightSequenceNameString.equals(referenceSequenceNameString)) {
            ResidueFrequencyCountToProfileGrid.calculatePositionRowForHighlightSequence(analysisOptions, entireAlignment.getHighlightSequenceArray(), positionInAlignmentRowWithoutSkippingGaps);
        }
        if (multipleSequenceAnalysis != null && analysisOptions.similarityParametersEnabled) {
            ResidueFrequencyCountToProfileGrid.calculateMotiffAndVarRegions();
        }
        if (analysisOptions.referenceSequence != null) {
            ResidueFrequencyCountToProfileGrid.calculateReferenceSequenceRow(analysisOptions.referenceSequence, entireAlignment.getReferenceSequenceRow());
        }
        String[] sortedAminoAcidSymbols = sortedData.getSortedAminoAcidSymbols();
        ResidueFrequencyCountToProfileGrid.calculateHighlightSequenceCells(analysisOptions, sortedAminoAcidSymbols, entireAlignment.getAminoAcidCounts(), sortedData, highlightType, highlightThresholdType, highlightThreshold, showValuesAs);
        profileGrid.setInputFile(inputFilename);
        profileGrid.setEntireAlignment(entireAlignment);
        profileGrid.setSortedAminoAcidNames(sortedData.getSortedAminoAcidNames());
        profileGrid.setSortedAminoAcidSymbols(sortedData.getSortedAminoAcidSymbols());
        profileGrid.setReferenceSequenceName(referenceSequenceName);
        profileGrid.setHighlightSequenceName(highlightSequenceName);
        profileGrid.setMotifEndpointIndices(motiffEndpointIndices);
        profileGrid.setVariableRegionEndpointIndices(variableRegionEnpointIndices);
        if (numberOfMotiffAndVariableRegions != null) {
            profileGrid.setNumberOfMotifRegions(numberOfMotiffAndVariableRegions[0]);
            profileGrid.setNumberOfVariableRegions(numberOfMotiffAndVariableRegions[1]);
        }
        profileGrid.setUnknownSymbols(unknownSymbols);
        profileGrid.setPlotSimValues(plotSimValues);
        profileGrid.setNumberOfSequences(numberOfSequences);
    }

    private static int[] calculateNumberOfMotiffAndVariableRegions() {
        int numberOfMotifRegions = motiffEndpointIndices.length / 2;
        int numberOfVariableRegions = variableRegionEnpointIndices.length / 2;
        return new int[]{numberOfMotifRegions, numberOfVariableRegions};
    }

    private static void calculateMotiffBorderings() {
        int i;
        Text[] majorAminoAcidRow = entireAlignment.getMajorAminoAcidRow();
        Text[] comparisonSequenceRow = entireAlignment.getReferenceSequenceRow();
        Text[] highlightSequenceRow = entireAlignment.getHighlightSequenceRow();
        Cell[][] aminoAcidCounts = entireAlignment.getAminoAcidCounts();
        Format[] majorAminoAcidRowFormats = new Format[majorAminoAcidRow.length];
        Format[] comparisonSequenceRowFormats = new Format[comparisonSequenceRow.length];
        Format[] highlightSequenceRowFormats = new Format[highlightSequenceRow.length];
        Format[][] aminoAcidCountsFormats = new Format[aminoAcidCounts.length][];
        for (i = 0; i < entireAlignment.getMajorAminoAcidRow().length; ++i) {
            majorAminoAcidRowFormats[i] = entireAlignment.getMajorAminoAcidRow()[i].getFormat();
        }
        for (i = 0; i < entireAlignment.getReferenceSequenceRow().length; ++i) {
            comparisonSequenceRowFormats[i] = entireAlignment.getReferenceSequenceRow()[i].getFormat();
        }
        for (i = 0; i < entireAlignment.getHighlightSequenceRow().length; ++i) {
            highlightSequenceRowFormats[i] = entireAlignment.getHighlightSequenceRow()[i].getFormat();
        }
        for (i = 0; i < entireAlignment.getAminoAcidCounts().length; ++i) {
            aminoAcidCountsFormats[i] = new Format[aminoAcidCounts[i].length];
            for (int j = 0; j < entireAlignment.getAminoAcidCounts()[i].length; ++j) {
                aminoAcidCountsFormats[i][j] = entireAlignment.getAminoAcidCounts()[i][j].getFormat();
            }
        }
        boolean leftEndpoint = true;
        boolean inMotiff = false;
        int indexIntoMotiffEndpoints = 0;
        for (int i2 = 0; i2 < aminoAcidCountsFormats.length && indexIntoMotiffEndpoints < motiffEndpointIndices.length; ++i2) {
            if (i2 == motiffEndpointIndices[indexIntoMotiffEndpoints]) {
                int j;
                ++indexIntoMotiffEndpoints;
                majorAminoAcidRowFormats[i2].setTopBorderEnabled(true);
                aminoAcidCountsFormats[i2][aminoAcidCountsFormats[i2].length - 1].setBottomBorderEnabled(true);
                if (leftEndpoint) {
                    inMotiff = true;
                    majorAminoAcidRowFormats[i2].setLeftBorderEnabled(true);
                    comparisonSequenceRowFormats[i2].setLeftBorderEnabled(true);
                    highlightSequenceRowFormats[i2].setLeftBorderEnabled(true);
                    for (j = 0; j < aminoAcidCountsFormats[i2].length; ++j) {
                        aminoAcidCountsFormats[i2][j].setLeftBorderEnabled(true);
                    }
                } else {
                    inMotiff = false;
                    majorAminoAcidRowFormats[i2].setRightBorderEnabled(true);
                    comparisonSequenceRowFormats[i2].setRightBorderEnabled(true);
                    highlightSequenceRowFormats[i2].setRightBorderEnabled(true);
                    for (j = 0; j < aminoAcidCountsFormats[i2].length; ++j) {
                        aminoAcidCountsFormats[i2][j].setRightBorderEnabled(true);
                    }
                }
                boolean bl = leftEndpoint = !leftEndpoint;
            }
            if (!inMotiff) continue;
            majorAminoAcidRowFormats[i2].setTopBorderEnabled(true);
            aminoAcidCountsFormats[i2][aminoAcidCountsFormats[i2].length - 1].setBottomBorderEnabled(true);
        }
    }

    private static void calculateMotiffAndVarRegions() {
        int j;
        int i;
        int currentNum = 0;
        Text[] motifNumberingRow = entireAlignment.getMorphNumberingRow();
        for (i = 0; i < motiffEndpointIndices.length; i += 2) {
            for (j = motiffEndpointIndices[i]; j <= motiffEndpointIndices[i + 1]; ++j) {
                motifNumberingRow[j].setValue("Mot " + currentNum);
            }
            ++currentNum;
        }
        currentNum = 0;
        for (i = 0; i < variableRegionEnpointIndices.length; i += 2) {
            for (j = variableRegionEnpointIndices[i]; j <= variableRegionEnpointIndices[i + 1]; ++j) {
                motifNumberingRow[j].setValue("Var " + currentNum);
            }
            ++currentNum;
        }
    }

    private static void calculateConservedCellColors(Cell[][] aminoAcidCounts, ConservationRange conservationRanges, double numberOfSequences, ResidueFrequencyCount sortedData) {
        for (int i = 0; i < aminoAcidCounts.length; ++i) {
            for (int j = 0; j < aminoAcidCounts[i].length; ++j) {
                double maxValSet = 0.0;
                for (int k = 0; k < conservationRanges.getNumberOfRanges(); ++k) {
                    if (!((double)sortedData.getAminoAcidCounts()[i][j] / numberOfSequences >= conservationRanges.getThreshold(k)) || !(maxValSet <= conservationRanges.getThreshold(k))) continue;
                    aminoAcidCounts[i][j].getFormat().setBackgroundColor(conservationRanges.getColour(k));
                    maxValSet = conservationRanges.getThreshold(k);
                }
            }
        }
    }

    private static void calculateMajorRow(Tier entireAlignment, String[] sortedAminoAcidSymbols, double threshold, ResidueFrequencyCount sortedData) {
        for (int i = 0; i < entireAlignment.getMajorAminoAcidRow().length; ++i) {
            int indexOfMaxiumumOccuringAminoAcid;
            int[] currentColumn = sortedData.getAminoAcidCounts()[i];
            if (!((double)currentColumn[indexOfMaxiumumOccuringAminoAcid = ResidueFrequencyCountToProfileGrid.getIndexOfMaximumOccuringAminoAcidIn(currentColumn)] > threshold) || sortedAminoAcidSymbols[indexOfMaxiumumOccuringAminoAcid].equalsIgnoreCase("-")) continue;
            entireAlignment.getMajorAminoAcidRow()[i].setValue(sortedAminoAcidSymbols[indexOfMaxiumumOccuringAminoAcid]);
        }
    }

    private static int getIndexOfMaximumOccuringAminoAcidIn(int[] aminoAcidCountsColumn) {
        int index = 0;
        double maxCounts = 0.0;
        for (int i = 0; i < aminoAcidCountsColumn.length; ++i) {
            if (!((double)aminoAcidCountsColumn[i] > maxCounts)) continue;
            index = i;
            maxCounts = aminoAcidCountsColumn[i];
        }
        return index;
    }

    private static void calculatePositionRow(AnalysisOptions analysisOptions, Text[] positionInAlignmentRow, int[] positionInAlignmentRowWithoutSkippingGaps) {
        String aminoAcid;
        int i;
        int currentPosition = analysisOptions.positionRowStart;
        Sequence referenceSequence = analysisOptions.referenceSequence;
        boolean startedReferenceSequence = false;
        boolean endedReferenceSequence = false;
        int startNumber = -1;
        int endNumber = positionInAlignmentRow.length - 1;
        int lastCount = 0;
        for (i = positionInAlignmentRow.length - 1; i >= 0 && !endedReferenceSequence; --i) {
            aminoAcid = referenceSequence.getAminoAcid(i);
            if (aminoAcid.equalsIgnoreCase("-") || aminoAcid.equalsIgnoreCase(".")) continue;
            endedReferenceSequence = true;
            endNumber = i;
        }
        for (i = 0; i < positionInAlignmentRow.length; ++i) {
            positionInAlignmentRowWithoutSkippingGaps[i] = currentPosition;
            if (analysisOptions.skipGaps) {
                aminoAcid = referenceSequence.getAminoAcid(i);
                if (!aminoAcid.equalsIgnoreCase("-") && !aminoAcid.equalsIgnoreCase(".")) {
                    startedReferenceSequence = true;
                    positionInAlignmentRow[i].setValue(String.valueOf(currentPosition));
                    if (i == endNumber) {
                        lastCount = currentPosition + 1;
                    }
                    ++currentPosition;
                }
                if (startedReferenceSequence) continue;
                startNumber = i;
                continue;
            }
            positionInAlignmentRow[i].setValue(String.valueOf(currentPosition));
            ++currentPosition;
        }
        if (analysisOptions.skipGaps) {
            int i2;
            int negativeCounter = analysisOptions.positionRowStart - startNumber - 1;
            for (i2 = 0; i2 <= startNumber; ++i2) {
                positionInAlignmentRow[i2].setValue(String.valueOf(negativeCounter));
                ++negativeCounter;
            }
            for (i2 = endNumber + 1; i2 < positionInAlignmentRow.length; ++i2) {
                positionInAlignmentRow[i2].setValue(String.valueOf(lastCount));
                ++lastCount;
            }
        }
    }

    private static void calculatePositionRowForHighlightSequence(AnalysisOptions analysisOptions, Text[] highlightSequenceArray, int[] positionInAlignmentRowWithoutSkippingGaps) {
        int currentPosition = analysisOptions.positionRowStart;
        Sequence highlightSequence = analysisOptions.highlightSequence;
        if (highlightSequence != null) {
            for (int i = 0; i < highlightSequenceArray.length; ++i) {
                positionInAlignmentRowWithoutSkippingGaps[i] = currentPosition;
                if (analysisOptions.skipGaps) {
                    if (highlightSequence.getAminoAcid(i).equalsIgnoreCase("-")) continue;
                    highlightSequenceArray[i].setValue(String.valueOf(currentPosition));
                    ++currentPosition;
                    continue;
                }
                highlightSequenceArray[i].setValue(String.valueOf(currentPosition));
                ++currentPosition;
            }
        }
    }

    private static void calculateReferenceSequenceRow(Sequence referenceSequence, Text[] comparisonSequenceRow) {
        for (int i = 0; i < comparisonSequenceRow.length; ++i) {
            comparisonSequenceRow[i].setValue(referenceSequence.getAminoAcid(i));
        }
    }

    private static void calculateHighlightSequenceCells(AnalysisOptions analysisOptions, String[] aminoAcidSymbols, Cell[][] aminoAcidCounts, ResidueFrequencyCount sortedData, int highlightType, int highlightThresholdType, double boxThreshold, int integerOrPercentage) {
        Sequence referenceSequence = analysisOptions.referenceSequence;
        Sequence highlightSequence = analysisOptions.highlightSequence;
        if (referenceSequence != null && highlightSequence != null) {
            for (int i = 0; i < aminoAcidCounts.length; ++i) {
                for (int j = 0; j < aminoAcidCounts[i].length; ++j) {
                    if (highlightType == 0) {
                        if (highlightSequence.getAminoAcid(i).equalsIgnoreCase(referenceSequence.getAminoAcid(i)) || !highlightSequence.getAminoAcid(i).equalsIgnoreCase(aminoAcidSymbols[j])) continue;
                        aminoAcidCounts[i][j].getFormat().setBorderColor(analysisOptions.highlightSequenceColour);
                        aminoAcidCounts[i][j].getFormat().setLeftBorderEnabled(true);
                        aminoAcidCounts[i][j].getFormat().setRightBorderEnabled(true);
                        aminoAcidCounts[i][j].getFormat().setTopBorderEnabled(true);
                        aminoAcidCounts[i][j].getFormat().setBottomBorderEnabled(true);
                        continue;
                    }
                    double currentThreshold = sortedData.getAminoAcidCounts()[i][j];
                    if (integerOrPercentage == 1) {
                        currentThreshold /= (double)numberOfSequences;
                    }
                    boolean passesThreshold = false;
                    if (highlightThresholdType == 0) {
                        boolean bl = passesThreshold = currentThreshold >= boxThreshold;
                    }
                    if (highlightThresholdType == 1) {
                        boolean bl = passesThreshold = currentThreshold == boxThreshold;
                    }
                    if (highlightThresholdType == 2) {
                        boolean bl = passesThreshold = currentThreshold <= boxThreshold;
                    }
                    if (!(currentThreshold > 0.0) || !passesThreshold) continue;
                    aminoAcidCounts[i][j].getFormat().setBorderColor(analysisOptions.highlightSequenceColour);
                    aminoAcidCounts[i][j].getFormat().setLeftBorderEnabled(true);
                    aminoAcidCounts[i][j].getFormat().setRightBorderEnabled(true);
                    aminoAcidCounts[i][j].getFormat().setTopBorderEnabled(true);
                    aminoAcidCounts[i][j].getFormat().setBottomBorderEnabled(true);
                }
            }
        }
    }

    static {
        referenceSequenceNameString = "";
        highlightSequenceNameString = "";
    }
}

