/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.calculations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sequence
implements Comparable<Sequence> {
    private String sequenceNames;
    private StringBuffer sequenceBuffer = new StringBuffer();
    private int check;
    private int length;
    private double weight;
    private boolean sequenceNamePassedRegexFilter = true;
    private boolean sequencePassedRegexFilter = true;
    private boolean sequencePassedMetaDataFilter = true;
    private boolean sequencePassedSelectionFilter = true;

    public Sequence(String nsequenceNames, int nLength, int nCheck, double nWeight) {
        this.sequenceNames = nsequenceNames;
        this.length = nLength;
        this.check = nCheck;
        this.weight = nWeight;
    }

    public Sequence(String nsequenceNames, String nSequence, int nLength, int nCheck, double nWeight) {
        this.sequenceNames = nsequenceNames;
        this.length = nLength;
        this.check = nCheck;
        this.weight = nWeight;
        this.sequenceBuffer = new StringBuffer(nSequence);
    }

    public static Sequence deepCopy(Sequence originalSequence) {
        return new Sequence(new String(originalSequence.getName()), new String(originalSequence.getSequence()), new Integer(originalSequence.getLength()), new Integer(originalSequence.getCheck()), new Double(originalSequence.getWeight()));
    }

    public String getName() {
        return this.sequenceNames;
    }

    public int getLength() {
        return this.length;
    }

    public int getCheck() {
        return this.check;
    }

    public double getWeight() {
        return this.weight;
    }

    public String getEntireSequence() {
        return this.sequenceBuffer.toString();
    }

    public String getAminoAcid(int index) {
        if (index < this.sequenceBuffer.length()) {
            return this.sequenceBuffer.substring(index, index + 1);
        }
        return null;
    }

    public char getAminoAcidChar(int index) {
        return this.sequenceBuffer.charAt(index);
    }

    public String toString() {
        return new String("Name:\t" + this.sequenceNames + "\tLength:\t" + this.length + "\tCheck:\t" + this.check + "\tWeight:\t" + this.weight);
    }

    public int getActualLength() {
        return this.sequenceBuffer.length();
    }

    public void addToSequence(String nSequence) {
        this.sequenceBuffer.append(nSequence);
    }

    public String getSequence() {
        return this.sequenceBuffer.toString();
    }

    public void setSequenceNamePassedRegexFilter(boolean sequenceNamePassedRegexFilter) {
        this.sequenceNamePassedRegexFilter = sequenceNamePassedRegexFilter;
    }

    public void setSequencePassedRegexFilter(boolean sequencePassedRegexFilter) {
        this.sequencePassedRegexFilter = sequencePassedRegexFilter;
    }

    public void setSequencePassedSelectionFilter(boolean sequencePassedSelectionFilter) {
        this.sequencePassedSelectionFilter = sequencePassedSelectionFilter;
    }

    public void setSequencePassedMetaDataFilter(boolean sequencePassedMetaDataFilter) {
        this.sequencePassedMetaDataFilter = sequencePassedMetaDataFilter;
    }

    public boolean getSequenceNamePassedRegexFilter() {
        return this.sequenceNamePassedRegexFilter;
    }

    public boolean getSequencePassedRegexFilter() {
        return this.sequencePassedRegexFilter;
    }

    public boolean getSequencePassedMetaDataFilter() {
        return this.sequencePassedMetaDataFilter;
    }

    public boolean getSequencePassedSelectionFilter() {
        return this.sequencePassedSelectionFilter;
    }

    @Override
    public int compareTo(Sequence sequence) {
        return this.sequenceNames.compareTo(sequence.getName());
    }
}

