/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.calculations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Symbol
implements Comparable<Symbol> {
    private String name;
    private String symbol;
    private char symbolChar;
    private double[] properties;
    private int compType;
    boolean ascending = false;

    public Symbol(String nName, String nSymbol, double[] nProperties, int nCompType, boolean nAscending) {
        this.name = nName;
        this.symbol = nSymbol;
        if (this.symbol.length() > 0) {
            this.symbolChar = this.symbol.charAt(0);
        }
        this.properties = nProperties;
        this.compType = nCompType;
        this.ascending = nAscending;
    }

    @Override
    public int compareTo(Symbol other) {
        if (this.ascending) {
            if (this.compType == 1) {
                return this.name.compareTo(other.getName());
            }
            if (this.compType == 0) {
                return this.symbol.compareTo(other.getSymbol());
            }
            if (this.getComparisonValue() > other.getComparisonValue()) {
                return 1;
            }
            if (this.getComparisonValue() < other.getComparisonValue()) {
                return -1;
            }
        } else {
            if (this.compType == 1) {
                return -1 * this.name.compareTo(other.getName());
            }
            if (this.compType == 0) {
                return -1 * this.symbol.compareTo(other.getSymbol());
            }
            if (this.getComparisonValue() < other.getComparisonValue()) {
                return 1;
            }
            if (this.getComparisonValue() > other.getComparisonValue()) {
                return -1;
            }
        }
        return 0;
    }

    public Double getComparisonValue() {
        return this.properties[this.compType - 2];
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public char getSymbolChar() {
        return this.symbolChar;
    }
}

