/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.constants;

import java.util.PriorityQueue;
import jprofilegrid.calculations.Symbol;
import jprofilegrid.constants.AlignmentConstants;

public class SortedAminoAcidNamesAndSymbols {
    private String[] sortedAminoAcidNames;
    private String[] sortedAminoAcidSymbols;
    private String sortType;

    public SortedAminoAcidNamesAndSymbols(String[] nSortedAminoAcidNames, String[] nSortedAminoAcidSymbols, String nSortType) {
        this.sortedAminoAcidNames = nSortedAminoAcidNames;
        this.sortedAminoAcidSymbols = nSortedAminoAcidSymbols;
        this.sortType = nSortType;
    }

    public static SortedAminoAcidNamesAndSymbols sort(int nSortType, boolean ascending, AlignmentConstants alignmentConstants) {
        int i;
        String[] unsortedNames = alignmentConstants.getNames();
        String[] unsortedSymbols = alignmentConstants.getSymbols();
        String sortType = nSortType == 0 ? "Alpha-Code" : (nSortType == 1 ? "Alpha-Name" : unsortedNames[nSortType - 2]);
        int lastName = unsortedNames.length - 1;
        String[] sortedAminoAcidNames = new String[unsortedNames.length];
        String[] sortedAminoAcidSymbols = new String[unsortedNames.length];
        PriorityQueue<Symbol> sortedAAs = new PriorityQueue<Symbol>();
        for (i = 0; i < lastName; ++i) {
            sortedAAs.add(new Symbol(unsortedNames[i], unsortedSymbols[i], alignmentConstants.getConstantsForSymbol(i), nSortType, ascending));
        }
        for (i = 0; i < lastName; ++i) {
            Symbol currentAA = (Symbol)sortedAAs.poll();
            sortedAminoAcidNames[i] = currentAA.getName();
            sortedAminoAcidSymbols[i] = currentAA.getSymbol();
        }
        sortedAminoAcidNames[lastName] = unsortedNames[lastName];
        sortedAminoAcidSymbols[lastName] = unsortedSymbols[lastName];
        return new SortedAminoAcidNamesAndSymbols(sortedAminoAcidNames, sortedAminoAcidSymbols, sortType);
    }

    public String[] getSortedAminoAcidNames() {
        return this.sortedAminoAcidNames;
    }

    public String[] getSortedAminoAcidSymbols() {
        return this.sortedAminoAcidSymbols;
    }

    public String getSortType() {
        return this.sortType;
    }
}

