/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.model;

import java.util.ArrayList;
import java.util.List;
import jprofilegrid.calculations.ResidueFrequencyCount;
import jprofilegrid.calculations.Sequence;
import jprofilegrid.constants.AlignmentConstants;
import jprofilegrid.model.ConservationRange;
import jxl.format.Colour;

public class AnalysisOptions {
    public List<Integer> sequenceIndicesInMSA;
    public boolean regExFilteringEnabled = false;
    public boolean metaDataFilteringEnabled = false;
    public boolean selectionFilteringEnabled = false;
    public boolean referenceSequenceChanged = false;
    public boolean skipGaps = false;
    public boolean skipGapsChanged = false;
    public boolean positionRowStartChanged = false;
    public boolean sortAscending = true;
    public boolean sortAscendingChanged = false;
    public boolean recalculateSorting = true;
    public boolean showValuesAsChanged = false;
    public boolean highlightSequenceChanged = false;
    public boolean highlightSequenceColourChanged = false;
    public boolean highlightTypeChanged = false;
    public boolean similarityParametersEnabled = false;
    public boolean recalculateSimilarityParameters = false;
    public boolean frequencyColorsEnabled = true;
    public Sequence referenceSequence;
    public Sequence highlightSequence;
    public int positionRowStart;
    public int sortType;
    public int showValuesAs;
    public int windowSize;
    public int columnsPerTier;
    public int firstColumn = 1;
    public int lastColumn;
    public int highlightType;
    public int highlightThresholdType;
    public Colour highlightSequenceColour = Colour.PINK;
    public double highlightThreshold;
    public double threshold;
    public double similarityFraction = 1.0;
    public String inputFilename;
    public String outputFilename;
    public String weightedString = "Unweighted";
    public String pdbFile;
    public AlignmentConstants alignmentConstants;
    public ConservationRange conservationRange = ConservationRange.DEFAULT_CONSERVATION_RANGE;
    public ResidueFrequencyCount sortedData;

    public AnalysisOptions(int numberOfSequences) {
        this.sequenceIndicesInMSA = new ArrayList<Integer>();
        for (int i = 0; i < numberOfSequences; ++i) {
            this.sequenceIndicesInMSA.add(i);
        }
    }
}

