/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.model;

import java.util.Vector;
import jxl.format.Colour;

public class ConservationRange {
    public static final String[] COLOR_SET_NAMES = new String[]{"Blue Ramp", "Spectrum-1", "Spectrum-2", "Grayscale"};
    public static final Colour[][] COLOR_SETS = new Colour[][]{{Colour.WHITE, Colour.LIGHT_TURQUOISE, Colour.PALE_BLUE, Colour.LIGHT_BLUE, Colour.BLUE, Colour.DARK_BLUE}, {Colour.WHITE, Colour.GRAY_25, Colour.YELLOW, Colour.ORANGE, Colour.GREEN, Colour.RED}, {Colour.WHITE, Colour.GREY_40_PERCENT, Colour.LIGHT_BLUE, Colour.GREEN, Colour.ORANGE, Colour.RED}, {Colour.WHITE, Colour.GRAY_25, Colour.GREY_40_PERCENT, Colour.GRAY_50, Colour.GRAY_80, Colour.BLACK}};
    public static final Double[] DEFAULT_CONSERVATION_RANGES = new Double[]{0.0, 0.1, 0.25, 0.5, 0.7, 0.9};
    public static final ConservationRange DEFAULT_CONSERVATION_RANGE = new ConservationRange(ConservationRange.getDefaultConservationColors(), DEFAULT_CONSERVATION_RANGES);
    Vector<Double> range = new Vector();
    Vector<Colour> colours = new Vector();

    public ConservationRange() {
    }

    public ConservationRange(Colour[] nColourRanges, Double[] nDefaultConservationRanges) {
        int i;
        for (i = 0; i < nColourRanges.length; ++i) {
            this.colours.add(nColourRanges[i]);
        }
        for (i = 0; i < nDefaultConservationRanges.length; ++i) {
            this.range.add(nDefaultConservationRanges[i]);
        }
    }

    public int getNumberOfRanges() {
        return this.range.size();
    }

    public void addConservationRange(double freq, Colour colour) {
        this.range.add(freq);
        this.colours.add(colour);
    }

    public double getThreshold(int index) {
        return this.range.get(index);
    }

    public Colour getColour(int index) {
        return this.colours.get(index);
    }

    public static Colour[] getDefaultConservationColors() {
        return COLOR_SETS[0];
    }

    public Double[] getDefaultConservationRanges() {
        return DEFAULT_CONSERVATION_RANGES;
    }
}

