/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.model;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import jprofilegrid.model.AnalysisOptions;
import jprofilegrid.model.Text;
import jprofilegrid.model.Tier;
import jprofilegrid.model.UnknownSymbol;
import jprofilegrid.writers.ExcelFileWriter;
import jprofilegrid.writers.PyMOLScriptWriter;
import jxl.Workbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileGrid {
    private String inputFile;
    private Tier entireAlignment;
    private String[] sortedAminoAcidNames;
    private String[] sortedAminoAcidSymbols;
    private int numberOfVariableRegions;
    private int numberOfMotifRegions;
    private int numberOfSequences;
    private Text referenceSequenceName;
    private Text highlightSequenceName;
    private int[] motifEndpointIndices;
    private int[] variableRegionEndpointIndices;
    private Vector<Double> plotSimValues;
    private Vector<UnknownSymbol> unknownSymbols;
    private AnalysisOptions analysisOptions;

    public ProfileGrid(int numberOfSequences) {
        this.analysisOptions = new AnalysisOptions(numberOfSequences);
    }

    public Tier getVariableRegion(int variableRegionNumber) {
        return this.getEntireAlignment().subTier(this.getVariableRegionEndpointIndices()[2 * variableRegionNumber], this.getVariableRegionEndpointIndices()[2 * variableRegionNumber + 1] + 1);
    }

    public Tier getMotifRegion(int motifRegionNumber) {
        return this.getEntireAlignment().subTier(this.getMotifEndpointIndices()[2 * motifRegionNumber], this.getMotifEndpointIndices()[2 * motifRegionNumber + 1] + 1);
    }

    public Tier getEntireAlignment() {
        return this.entireAlignment;
    }

    public Tier getTier(int startCol, int endCol) {
        return this.getEntireAlignment().subTier(startCol, endCol);
    }

    public int getSequenceLength() {
        return this.getEntireAlignment().getAminoAcidCounts().length;
    }

    public String[] getSortedAminoAcidNames() {
        return this.sortedAminoAcidNames;
    }

    public String[] getSortedAminoAcidSymbols() {
        return this.sortedAminoAcidSymbols;
    }

    public void setAnalysisOptions(AnalysisOptions analysisOptions) {
        this.analysisOptions = analysisOptions;
    }

    public AnalysisOptions getAnalysisOptions() {
        return this.analysisOptions;
    }

    public void outputExcelFile() {
        try {
            String filename = this.analysisOptions.outputFilename;
            int columnsPerTier = this.analysisOptions.columnsPerTier;
            ExcelFileWriter writer = new ExcelFileWriter(Workbook.createWorkbook(new File(filename)), this);
            writer.writeExcelFile(columnsPerTier, this.analysisOptions.firstColumn - 1, this.analysisOptions.lastColumn - 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void outputPyMOLScript() {
        String filename = this.analysisOptions.outputFilename;
        int firstColumn = this.analysisOptions.firstColumn;
        int lastColumn = this.analysisOptions.lastColumn;
        String pdbFile = this.analysisOptions.pdbFile;
        if (pdbFile == null) {
            pdbFile = "filename.pdb";
        }
        PyMOLScriptWriter.outputPyMOLScript(this, this.analysisOptions, this.getInputFile(), filename, pdbFile, firstColumn, lastColumn);
    }

    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public void setEntireAlignment(Tier entireAlignment) {
        this.entireAlignment = entireAlignment;
    }

    public void setSortedAminoAcidNames(String[] sortedAminoAcidNames) {
        this.sortedAminoAcidNames = sortedAminoAcidNames;
    }

    public void setSortedAminoAcidSymbols(String[] sortedAminoAcidSymbols) {
        this.sortedAminoAcidSymbols = sortedAminoAcidSymbols;
    }

    public void setReferenceSequenceName(Text referenceSequenceName) {
        this.referenceSequenceName = referenceSequenceName;
    }

    public Text getReferenceSequenceName() {
        return this.referenceSequenceName;
    }

    public void setHighlightSequenceName(Text highlightSequenceName) {
        this.highlightSequenceName = highlightSequenceName;
    }

    public Text getHighlightSequenceName() {
        return this.highlightSequenceName;
    }

    public void setMotifEndpointIndices(int[] motifEndpointIndices) {
        this.motifEndpointIndices = motifEndpointIndices;
    }

    public int[] getMotifEndpointIndices() {
        return this.motifEndpointIndices;
    }

    public void setVariableRegionEndpointIndices(int[] variableRegionEndpointIndices) {
        this.variableRegionEndpointIndices = variableRegionEndpointIndices;
    }

    public int[] getVariableRegionEndpointIndices() {
        return this.variableRegionEndpointIndices;
    }

    public void setNumberOfVariableRegions(int numberOfVariableRegions) {
        this.numberOfVariableRegions = numberOfVariableRegions;
    }

    public int getNumberOfVariableRegions() {
        return this.numberOfVariableRegions;
    }

    public void setNumberOfMotifRegions(int numberOfMotifRegions) {
        this.numberOfMotifRegions = numberOfMotifRegions;
    }

    public int getNumberOfMotifRegions() {
        return this.numberOfMotifRegions;
    }

    public void setUnknownSymbols(Vector<UnknownSymbol> unknownSymbols) {
        this.unknownSymbols = unknownSymbols;
    }

    public Vector<UnknownSymbol> getUnknownSymbols() {
        return this.unknownSymbols;
    }

    public void setPlotSimValues(Vector<Double> plotSimValues) {
        this.plotSimValues = plotSimValues;
    }

    public Vector<Double> getPlotSimValues() {
        return this.plotSimValues;
    }

    public void setNumberOfSequences(int numberOfSequences) {
        this.numberOfSequences = numberOfSequences;
    }

    public int getNumberOfSequences() {
        return this.numberOfSequences;
    }
}

