/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.model;

import jprofilegrid.constants.AlignmentConstants;
import jprofilegrid.model.Cell;
import jprofilegrid.model.Format;
import jprofilegrid.model.Numeric;
import jprofilegrid.model.Text;

public class Tier {
    private Text[] majorAminoAcidRow;
    private Text[] templateSequenceRow;
    private Text[] positionInAlignmentRow;
    private Text[] motiffNumberingRow;
    private Text[] highlightSequenceRow;
    private Text[] highlightSequenceArray;
    private Cell[][] aminoAcidCounts;
    private static Text totalCountsString = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "Counts");
    private static Text totalFrequenciesString = new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), "Freq.");
    private Numeric[] totalAminoAcidCounts;
    private Numeric[] totalAminoAcidFrequencies;
    private AlignmentConstants constants;
    private int[][] integerAminoAcidCounts;
    private int[] positionInAlignmentRowWithoutSkippingGaps;

    public Tier(Text[] nPositionInAlignmentRow, Text[] nMotiffNumberingRow, Text[] nMajorAminoAcidRow, Text[] nComparisonSequenceRow, Cell[][] nAminoAcidCounts, AlignmentConstants nConstants, int[][] nIntegerAminoAcidCounts, int[] nPositonInAlignmentRowWithoutSkippingGaps, Text[] nHighlightSequenceArray) {
        this.positionInAlignmentRow = nPositionInAlignmentRow;
        this.motiffNumberingRow = nMotiffNumberingRow;
        this.majorAminoAcidRow = nMajorAminoAcidRow;
        this.templateSequenceRow = nComparisonSequenceRow;
        this.aminoAcidCounts = nAminoAcidCounts;
        this.constants = nConstants;
        this.integerAminoAcidCounts = nIntegerAminoAcidCounts;
        this.positionInAlignmentRowWithoutSkippingGaps = nPositonInAlignmentRowWithoutSkippingGaps;
        this.highlightSequenceArray = nHighlightSequenceArray;
    }

    public int[][] getIntegerAminoAcidCounts() {
        return this.integerAminoAcidCounts;
    }

    public int[] getPositonInAlignmentRowWithoutSkippingGaps() {
        return this.positionInAlignmentRowWithoutSkippingGaps;
    }

    public void setHighlightSequenceRow(Text[] nHighlightSequenceRow) {
        this.highlightSequenceRow = nHighlightSequenceRow;
    }

    public Numeric[] getTotalAminoAcidCounts() {
        return this.totalAminoAcidCounts;
    }

    public Numeric[] getTotalAminoAcidFrequencies() {
        return this.totalAminoAcidFrequencies;
    }

    public Text[] getMajorAminoAcidRow() {
        return this.majorAminoAcidRow;
    }

    public Text[] getReferenceSequenceRow() {
        return this.templateSequenceRow;
    }

    public Text[] getPositionInAlignmentRow() {
        return this.positionInAlignmentRow;
    }

    public Text[] getMorphNumberingRow() {
        return this.motiffNumberingRow;
    }

    public Text[] getHighlightSequenceRow() {
        return this.highlightSequenceRow;
    }

    public Text[] getHighlightSequenceArray() {
        return this.highlightSequenceArray;
    }

    public Cell[][] getAminoAcidCounts() {
        return this.aminoAcidCounts;
    }

    public Text getTotalCountsString() {
        return totalCountsString;
    }

    public Text getTotalFequenciesString() {
        return totalFrequenciesString;
    }

    public Tier subTier(int startCol, int endCol) {
        int lengthOfTier = endCol - startCol;
        Text[] nMajorAminoAcidRow = new Text[lengthOfTier];
        Text[] nComparisonSequenceRow = new Text[lengthOfTier];
        Text[] nPositionInAlignmentRow = new Text[lengthOfTier];
        Text[] nMotiffNumberingRow = new Text[lengthOfTier];
        Text[] nHighlightSequenceRow = new Text[lengthOfTier];
        Text[] nHighlightSequenceArray = new Text[lengthOfTier];
        Cell[][] nAminoAcidCounts = new Cell[lengthOfTier][this.aminoAcidCounts.length];
        int[][] nIntegerAminoAcidCounts = new int[lengthOfTier][this.aminoAcidCounts.length];
        int[] nPositionInAlignmentRowWithoutSkippingGaps = new int[lengthOfTier];
        for (int i = startCol; i < endCol; ++i) {
            nMajorAminoAcidRow[i - startCol] = this.majorAminoAcidRow[i];
            nComparisonSequenceRow[i - startCol] = this.templateSequenceRow[i];
            nPositionInAlignmentRow[i - startCol] = this.positionInAlignmentRow[i];
            nMotiffNumberingRow[i - startCol] = this.motiffNumberingRow[i];
            nAminoAcidCounts[i - startCol] = this.aminoAcidCounts[i];
            nIntegerAminoAcidCounts[i - startCol] = this.integerAminoAcidCounts[i];
            nHighlightSequenceRow[i - startCol] = this.highlightSequenceRow[i];
            nPositionInAlignmentRowWithoutSkippingGaps[i - startCol] = this.positionInAlignmentRowWithoutSkippingGaps[i];
            nHighlightSequenceArray[i - startCol] = this.highlightSequenceArray[i];
        }
        Tier nTier = new Tier(nPositionInAlignmentRow, nMotiffNumberingRow, nMajorAminoAcidRow, nComparisonSequenceRow, nAminoAcidCounts, this.constants, nIntegerAminoAcidCounts, nPositionInAlignmentRowWithoutSkippingGaps, nHighlightSequenceArray);
        nTier.setHighlightSequenceRow(nHighlightSequenceRow);
        return nTier;
    }
}

