/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.presenter;

import java.util.Iterator;
import java.util.PriorityQueue;
import jxl.format.Colour;
import jxl.format.RGB;

public class ColorManager {
    private static Colour[] SORTED_COLOURS;
    private static String[] SORTED_COLOUR_NAMES;

    public static Colour[] getSortedColours() {
        return SORTED_COLOURS;
    }

    public static String[] getSortedColourNames() {
        return SORTED_COLOUR_NAMES;
    }

    public static void initializeSortedColours() {
        ColorPriorityQueue allColors = new ColorPriorityQueue();
        allColors.add(new ColorSorter(Colour.BLACK));
        allColors.add(new ColorSorter(Colour.GRAY_80));
        int i = 10;
        int j = 0;
        while (i < 63) {
            if (i != 20 && allColors.doesNotContain(new ColorSorter(Colour.getInternalColour(i)))) {
                allColors.add(new ColorSorter(Colour.getInternalColour(i)));
            }
            ++i;
            ++j;
        }
        allColors.add(new ColorSorter(Colour.WHITE));
        SORTED_COLOURS = new Colour[allColors.size()];
        for (i = 0; i < SORTED_COLOURS.length; ++i) {
            ColorManager.SORTED_COLOURS[i] = ((ColorSorter)allColors.remove()).getColour();
        }
    }

    private static void initializeSortedColourNames() {
        ColorPriorityQueue allColors = new ColorPriorityQueue();
        allColors.add(new ColorSorter(Colour.BLACK));
        allColors.add(new ColorSorter(Colour.WHITE));
        allColors.add(new ColorSorter(Colour.GRAY_80));
        int i = 10;
        int j = 0;
        while (i < 63) {
            if (allColors.doesNotContain(new ColorSorter(Colour.getInternalColour(i)))) {
                allColors.add(new ColorSorter(Colour.getInternalColour(i)));
            }
            ++i;
            ++j;
        }
        SORTED_COLOUR_NAMES = new String[allColors.size()];
        for (i = 0; i < SORTED_COLOUR_NAMES.length; ++i) {
            ColorManager.SORTED_COLOUR_NAMES[i] = ((ColorSorter)allColors.remove()).getColour().getDescription();
        }
    }

    public static int getColorIndexWithName(String name) {
        for (int i = 0; i < SORTED_COLOURS.length; ++i) {
            if (!name.equalsIgnoreCase(SORTED_COLOURS[i].getDescription())) continue;
            return i;
        }
        return -1;
    }

    static {
        ColorManager.initializeSortedColours();
        ColorManager.initializeSortedColourNames();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColorSorter
    implements Comparable<ColorSorter> {
        private Colour thisColor;

        public ColorSorter(Colour nColour) {
            this.thisColor = nColour;
        }

        @Override
        public int compareTo(ColorSorter color) {
            RGB thisRGB = this.thisColor.getDefaultRGB();
            RGB thatRGB = color.getColour().getDefaultRGB();
            if (thisRGB.getGreen() > thatRGB.getGreen()) {
                return -1;
            }
            if (thisRGB.getGreen() < thatRGB.getGreen()) {
                return 1;
            }
            if (thisRGB.getRed() > thatRGB.getRed()) {
                return -1;
            }
            if (thisRGB.getRed() < thatRGB.getRed()) {
                return 1;
            }
            if (thisRGB.getBlue() > thatRGB.getBlue()) {
                return -1;
            }
            if (thisRGB.getBlue() <= thatRGB.getBlue()) {
                return 1;
            }
            return 0;
        }

        public Colour getColour() {
            return this.thisColor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColorPriorityQueue
    extends PriorityQueue<ColorSorter> {
        private static final long serialVersionUID = 8634045462607950274L;

        private ColorPriorityQueue() {
        }

        public boolean doesNotContain(ColorSorter otherColour) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!((ColorSorter)it.next()).getColour().getDescription().equalsIgnoreCase(otherColour.getColour().getDescription())) continue;
                return false;
            }
            return true;
        }
    }
}

