/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.presenter;

import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jprofilegrid.calculations.MultipleSequenceAlignment;
import jprofilegrid.calculations.ResidueFrequencyCount;
import jprofilegrid.calculations.ResidueFrequencyCountToProfileGrid;
import jprofilegrid.calculations.Sequence;
import jprofilegrid.model.AnalysisOptions;
import jprofilegrid.model.ConservationRange;
import jprofilegrid.model.ProfileGrid;
import jprofilegrid.presenter.ColorManager;
import jprofilegrid.presenter.SelectionFilterResults;
import jprofilegrid.presenter.SequenceFilter;
import jprofilegrid.presenter.SimilarityParametersWorker;
import jprofilegrid.readers.MSAReaderController;
import jprofilegrid.view.alignmentwindow.AlignmentWindow;
import jprofilegrid.view.celldescription.CellDescriptionJFrame;
import jprofilegrid.view.frequencycolors.FrequencyColorsJFrame;
import jprofilegrid.view.gridparameters.GrepSequenceJComboBox;
import jprofilegrid.view.gridparameters.GridParametersJPanel;
import jprofilegrid.view.highlight.HighlightJFrame;
import jprofilegrid.view.main.ExportJPanel;
import jprofilegrid.view.main.FiltersJPanel;
import jprofilegrid.view.main.LoadAlignmentJPanel;
import jprofilegrid.view.main.MainJFrame;
import jprofilegrid.view.main.SimilarityParametersJPanel;
import jprofilegrid.view.metadata.MetaDataColumnsJFrame;
import jprofilegrid.view.overview.OverviewJFrame;
import jprofilegrid.view.profilegrid.ProfileGridJFrame;
import jprofilegrid.writers.FASTAFileWriter;
import jprofilegrid.writers.ImageFileWriter;
import jxl.format.Colour;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileGridPresenter
implements SimilarityParametersWorker.SimilarityParametersWorkerCallback {
    private static final int MAX_SEQUENCES_TO_DRAW = 600;
    private static final short SINGLE_DISPLAY = 0;
    private static final short PSEUDO_MIRROR = 1;
    private static final short SELECTION = 2;
    private ProfileGridJFrame profileGridJFrame = new ProfileGridJFrame(this);
    private OverviewJFrame profileGridOverviewJFrame;
    private OverviewJFrame alignmentOverviewJFrame;
    private MetaDataColumnsJFrame metaDataColumnsJFrame;
    private CellDescriptionJFrame cellDescriptionJFrame = new CellDescriptionJFrame(this);
    private FrequencyColorsJFrame freqColor;
    private HighlightJFrame highlightJFrame = new HighlightJFrame(this);
    private AlignmentWindow alignmentWindow = new AlignmentWindow(this);
    private MultipleSequenceAlignment multipleSequenceAlignment;
    private ProfileGrid topProfileGrid;
    private ProfileGrid bottomProfileGrid;
    private MainJFrame mainJFrame = new MainJFrame(this);

    public void openHighlightJFrame() {
        int x = this.mainJFrame.getX();
        int y = this.mainJFrame.getY();
        int w = this.mainJFrame.getWidth();
        int h = this.mainJFrame.getHeight();
        this.highlightJFrame.setLocation(x + w + 1, y + h / 2);
        this.onHighlightTypeChanged();
        this.highlightJFrame.setVisible(true);
    }

    public void openIdentifySequencesDialog() {
        int x = this.mainJFrame.getX();
        int y = this.mainJFrame.getY();
        int w = this.mainJFrame.getWidth();
        int h = this.mainJFrame.getHeight();
        this.cellDescriptionJFrame.setLocation(x + w + 1, y + h / 4);
        this.cellDescriptionJFrame.setVisible(true);
        this.cellDescriptionJFrame.update(this.cellDescriptionJFrame.getGraphics());
    }

    public void browseForMSAFile() {
        FileDialog fileDialog = new FileDialog((Frame)this.mainJFrame, "Load Alignment", 0);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String msaFilename = fileDialog.getDirectory() + fileDialog.getFile();
            LoadAlignmentJPanel loadAlignmentPanel = this.mainJFrame.getLoadAlignmentPanel();
            loadAlignmentPanel.getLoadFileBlank().setText(msaFilename);
            loadAlignmentPanel.getLoadFileButton().setEnabled(true);
            loadAlignmentPanel.setFilenameWithoutPath(fileDialog.getFile());
        }
    }

    public void performLoad() {
        LoadAlignmentJPanel loadAlignmentJPanel = this.mainJFrame.getLoadAlignmentPanel();
        String filename = loadAlignmentJPanel.getFilename();
        int typeOfMSA = loadAlignmentJPanel.getTypeOfMSA();
        int alignmentType = loadAlignmentJPanel.getAlignmentType();
        this.multipleSequenceAlignment = MSAReaderController.loadMultipleSequenceAlignment(typeOfMSA, alignmentType, new File(filename));
        int numberOfSequences = this.multipleSequenceAlignment.getSequences().size();
        this.topProfileGrid = new ProfileGrid(numberOfSequences);
        this.bottomProfileGrid = new ProfileGrid(numberOfSequences);
        SimilarityParametersJPanel similarityParametersJPanel = this.mainJFrame.getSimilarityParametersPanel();
        GridParametersJPanel gridParametersJPanel = this.mainJFrame.getGridParametersPanel();
        ExportJPanel exportJPanel = this.mainJFrame.getExportPanel();
        FiltersJPanel filtersJPanel = this.mainJFrame.getFiltersPanel();
        gridParametersJPanel.setSortTypeBlank(this.multipleSequenceAlignment.getAlignmentConstants().getSortTypes());
        exportJPanel.setOutputFilename(filename + ".xls");
        exportJPanel.setFinalColumn(this.multipleSequenceAlignment.getMinSequenceLength());
        int x = this.mainJFrame.getX();
        int y = this.mainJFrame.getY();
        int w = this.mainJFrame.getWidth();
        this.profileGridJFrame.setLocation(x + w, y);
        if (this.multipleSequenceAlignment.getSequences().size() > 10000) {
            gridParametersJPanel.selectPercentage();
        }
        this.updateSortSequenceLists();
        this.updateTopProfileGrid();
        ProfileGridPresenter.setAllComponentsEnabled(true, gridParametersJPanel);
        ProfileGridPresenter.setAllComponentsEnabled(true, gridParametersJPanel.getPositionRulerJPanel());
        ProfileGridPresenter.setAllComponentsEnabled(true, gridParametersJPanel.getFrequencyColorsJPanel());
        ProfileGridPresenter.setAllComponentsEnabled(true, gridParametersJPanel.getSortAndDualDisplayJPanel());
        ProfileGridPresenter.setAllComponentsEnabled(true, gridParametersJPanel.getOverviewTypesJPanel());
        ProfileGridPresenter.setAllComponentsEnabled(true, similarityParametersJPanel);
        ProfileGridPresenter.setAllComponentsEnabled(true, exportJPanel.getColumnsSelectionPanel());
        ProfileGridPresenter.setAllComponentsEnabled(true, exportJPanel);
        ProfileGridPresenter.setAllComponentsEnabled(true, filtersJPanel);
        this.profileGridJFrame.setVisible(true);
        this.mainJFrame.pack();
    }

    public void updateSpecificProfileGrid(ProfileGrid profileGrid) {
        SimilarityParametersJPanel similarityParametersJPanel = this.mainJFrame.getSimilarityParametersPanel();
        GridParametersJPanel gridParametersJPanel = this.mainJFrame.getGridParametersPanel();
        ExportJPanel exportJPanel = this.mainJFrame.getExportPanel();
        FiltersJPanel filtersJPanel = this.mainJFrame.getFiltersPanel();
        List<Sequence> sequences = this.multipleSequenceAlignment.getSequences();
        AnalysisOptions analysisOptions = profileGrid.getAnalysisOptions();
        Sequence highlightSequence = this.getHighlightSequence();
        Sequence referenceSequence = this.getReferenceSequence();
        if (highlightSequence != null) {
            analysisOptions.highlightSequence = highlightSequence;
        }
        if (referenceSequence != null) {
            analysisOptions.referenceSequence = referenceSequence;
        }
        analysisOptions.highlightType = this.highlightJFrame.getHighlightType();
        analysisOptions.highlightThresholdType = this.highlightJFrame.getAboveEqualsOrBelow();
        analysisOptions.highlightThreshold = this.highlightJFrame.getHighlightThreshold();
        analysisOptions.highlightSequenceColour = ColorManager.getSortedColours()[this.getHighlightSequenceColor()];
        analysisOptions.similarityParametersEnabled = similarityParametersJPanel.similarityParametersEnabled();
        analysisOptions.similarityFraction = similarityParametersJPanel.getSimilarityFraction();
        analysisOptions.windowSize = similarityParametersJPanel.getWindowSize();
        analysisOptions.threshold = similarityParametersJPanel.getThreshold();
        analysisOptions.regExFilteringEnabled = filtersJPanel.getRegExFilteringEnabled();
        analysisOptions.metaDataFilteringEnabled = gridParametersJPanel.getMetaDataFilteringEnabled();
        analysisOptions.positionRowStart = gridParametersJPanel.getPositionStart();
        analysisOptions.sortType = gridParametersJPanel.getSortType();
        analysisOptions.frequencyColorsEnabled = gridParametersJPanel.frequencyColorsEnabled();
        analysisOptions.skipGaps = gridParametersJPanel.skipGapsEnabled();
        analysisOptions.showValuesAs = gridParametersJPanel.showValueAs();
        analysisOptions.sortAscending = gridParametersJPanel.isAscendingSort();
        analysisOptions.columnsPerTier = exportJPanel.getColumnsPerTier();
        analysisOptions.outputFilename = exportJPanel.getOutputFilename();
        analysisOptions.alignmentConstants = this.multipleSequenceAlignment.getAlignmentConstants();
        analysisOptions.conservationRange = this.getFrequencyColorConservationRanges();
        analysisOptions.sequenceIndicesInMSA = new ArrayList<Integer>();
        for (int i = 0; i < sequences.size(); ++i) {
            Sequence sequence = sequences.get(i);
            boolean passedRegexFilters = true;
            if (analysisOptions.regExFilteringEnabled) {
                passedRegexFilters = sequence.getSequenceNamePassedRegexFilter() && sequence.getSequencePassedRegexFilter();
            }
            boolean passedMetaDataFilter = true;
            if (analysisOptions.metaDataFilteringEnabled) {
                passedMetaDataFilter = sequence.getSequencePassedMetaDataFilter();
            }
            boolean passedSelectionfilter = true;
            if (analysisOptions.selectionFilteringEnabled) {
                passedSelectionfilter = sequence.getSequencePassedSelectionFilter();
            }
            if (!passedRegexFilters || !passedMetaDataFilter || !passedSelectionfilter) continue;
            analysisOptions.sequenceIndicesInMSA.add(i);
        }
        if (analysisOptions.recalculateSimilarityParameters) {
            new SimilarityParametersWorker(this.multipleSequenceAlignment, analysisOptions, this);
        }
        if (analysisOptions.recalculateSorting) {
            ResidueFrequencyCount.analyze(this.multipleSequenceAlignment, analysisOptions);
        }
        ResidueFrequencyCountToProfileGrid.computeProfileGrid(profileGrid, this.multipleSequenceAlignment.getMultipleSequenceAnalysis());
        analysisOptions.recalculateSimilarityParameters = false;
        analysisOptions.recalculateSorting = false;
    }

    public void updateTopProfileGrid() {
        this.updateSpecificProfileGrid(this.topProfileGrid);
        AnalysisOptions analysisOptions = this.topProfileGrid.getAnalysisOptions();
        this.updateSortSequenceLists();
        if (this.profileGridOverviewJFrame != null) {
            this.profileGridOverviewJFrame.resetDisplay(this.topProfileGrid);
        }
        if (this.alignmentOverviewJFrame != null) {
            this.alignmentOverviewJFrame.resetDisplay(this.topProfileGrid);
        }
        String title = this.multipleSequenceAlignment.getAlignmentName() + " - " + analysisOptions.sequenceIndicesInMSA.size() + " Sequences";
        this.profileGridJFrame.resetTopProfileGrid(title, this.topProfileGrid);
        if (this.profileGridJFrame.getDualDisplayEnabled()) {
            this.updateSpecificProfileGrid(this.bottomProfileGrid);
            this.profileGridJFrame.resetBottomProfileGrid(this.bottomProfileGrid);
        }
    }

    public Sequence getHighlightSequence() {
        GrepSequenceJComboBox highlightSequenceBlank = this.highlightJFrame.getHighlightSequenceBlank();
        return highlightSequenceBlank.getSelectedSequence();
    }

    public Sequence getReferenceSequence() {
        GridParametersJPanel gridParametersJPanel = this.mainJFrame.getGridParametersPanel();
        GrepSequenceJComboBox referenceSequenceBlank = gridParametersJPanel.getReferenceSequenceBlank();
        return referenceSequenceBlank.getSelectedSequence();
    }

    public int getHighlightSequenceColor() {
        JComboBox highlightSequenceColorBlank = this.highlightJFrame.getHighlightSequenceColorBlank();
        return highlightSequenceColorBlank.getSelectedIndex();
    }

    public void onHighlightTypeChanged() {
        JRadioButton sequenceRadioButton = this.highlightJFrame.getSequenceRadioButton();
        JRadioButton aboveRadioButton = this.highlightJFrame.getAboveRadioButton();
        JRadioButton equalsRadioButton = this.highlightJFrame.getEqualsRadioButton();
        JRadioButton belowRadioButton = this.highlightJFrame.getBelowRadioButton();
        JPanel highlightValuesJPanel = this.highlightJFrame.getHighlightValuesJPanel();
        JPanel highlightSequenceJPanel = this.highlightJFrame.getHighlightSequenceJPanel();
        boolean sequenceFilteringEnabled = sequenceRadioButton.isSelected();
        ProfileGridPresenter.setAllComponentsEnabled(!sequenceFilteringEnabled, highlightValuesJPanel);
        aboveRadioButton.setEnabled(!sequenceFilteringEnabled);
        equalsRadioButton.setEnabled(!sequenceFilteringEnabled);
        belowRadioButton.setEnabled(!sequenceFilteringEnabled);
        ProfileGridPresenter.setAllComponentsEnabled(sequenceFilteringEnabled, highlightSequenceJPanel);
    }

    public void updateSortSequenceLists() {
        GridParametersJPanel gridParametersJPanel = this.mainJFrame.getGridParametersPanel();
        GrepSequenceJComboBox referenceSequenceBlank = gridParametersJPanel.getReferenceSequenceBlank();
        GrepSequenceJComboBox highlightSequenceBlank = this.highlightJFrame.getHighlightSequenceBlank();
        highlightSequenceBlank.removeActionListener(this.highlightJFrame);
        referenceSequenceBlank.removeActionListener(gridParametersJPanel);
        int selectedReferenceSequence = referenceSequenceBlank.getSelectedSequenceIndex();
        int selectedHighlightSequence = highlightSequenceBlank.getSelectedSequenceIndex();
        AnalysisOptions analysisOptions = this.topProfileGrid.getAnalysisOptions();
        List<Integer> sequenceIndicesInMSA = analysisOptions.sequenceIndicesInMSA;
        List<Sequence> sequences = this.multipleSequenceAlignment.getSequences();
        ArrayList<Sequence> includedSequences = new ArrayList<Sequence>();
        for (int i = 0; i < sequenceIndicesInMSA.size(); ++i) {
            includedSequences.add(sequences.get(sequenceIndicesInMSA.get(i)));
        }
        referenceSequenceBlank.setSequences(includedSequences);
        highlightSequenceBlank.setSequences(includedSequences);
        boolean sortSequences = gridParametersJPanel.getSortingEnabled();
        highlightSequenceBlank.setSequenceListSorted(sortSequences);
        referenceSequenceBlank.setSequenceListSorted(sortSequences);
        if (selectedReferenceSequence < referenceSequenceBlank.getItemCount()) {
            referenceSequenceBlank.setSelectedIndex(selectedReferenceSequence);
        }
        if (selectedHighlightSequence < highlightSequenceBlank.getItemCount()) {
            highlightSequenceBlank.setSelectedIndex(selectedHighlightSequence);
        }
        referenceSequenceBlank.addActionListener(gridParametersJPanel);
        highlightSequenceBlank.addActionListener(this.highlightJFrame);
    }

    public void setSelectedAminoAcid() {
        int row = this.profileGridJFrame.getTopProfileGridSelectedRow();
        int col = this.profileGridJFrame.getTopProfileGridSelectedColumn();
        if (row >= 0 && col >= 0) {
            AnalysisOptions analysisOptions = this.topProfileGrid.getAnalysisOptions();
            int startIndex = Integer.parseInt(this.topProfileGrid.getEntireAlignment().getPositionInAlignmentRow()[0].getValue());
            SelectionFilterResults selectionFilterResults = SequenceFilter.selectionFilter(row, col, this.multipleSequenceAlignment, analysisOptions, this.mainJFrame.getGridParametersPanel().getDisplayedResidueIfPresent(), this.alignmentWindow.isVisible(), startIndex);
            JTextArea sequenceListJTextArea = this.cellDescriptionJFrame.getSequenceListJTextArea();
            sequenceListJTextArea.setText(selectionFilterResults.getListOfSequences().toString());
            sequenceListJTextArea.setBackground(this.cellDescriptionJFrame.getBackground());
            StringBuilder alignment = selectionFilterResults.getAlignment();
            StringBuilder sequenceNames = selectionFilterResults.getSequenceNames();
            if (this.alignmentWindow.isVisible()) {
                this.alignmentWindow.updateSequences(alignment.toString());
                this.alignmentWindow.updateNames(sequenceNames.toString());
            }
            if (this.profileGridJFrame.getSelectionModeEnabled()) {
                analysisOptions = this.bottomProfileGrid.getAnalysisOptions();
                analysisOptions.recalculateSorting = true;
                analysisOptions.selectionFilteringEnabled = true;
                this.updateSpecificProfileGrid(this.bottomProfileGrid);
                this.profileGridJFrame.resetBottomProfileGrid(this.bottomProfileGrid);
            }
        }
    }

    public TableModel constructAlignmentOverviewTableModel() {
        int rows;
        AnalysisOptions analysisOptions = this.topProfileGrid.getAnalysisOptions();
        List<Integer> sequenceIndicesInMSA = analysisOptions.sequenceIndicesInMSA;
        List<Sequence> sequences = this.multipleSequenceAlignment.getSequences();
        int seqCount = sequenceIndicesInMSA.size();
        double stepSize = 1.0;
        if (seqCount < 600) {
            rows = seqCount;
        } else {
            rows = 600;
            stepSize = (double)seqCount / 600.0;
        }
        int cols = this.multipleSequenceAlignment.getMinSequenceLength();
        DefaultTableModel defaultTableModel = new DefaultTableModel(rows, cols);
        double nextSeq = 0.0;
        for (int i = 0; i < rows; ++i) {
            int index = (int)nextSeq;
            if (nextSeq == (double)seqCount) {
                index = (int)nextSeq - 1;
            }
            Sequence s = sequences.get(sequenceIndicesInMSA.get(index));
            for (int j = 0; j < cols; ++j) {
                defaultTableModel.setValueAt(s.getAminoAcid(j), i, j);
            }
            nextSeq += stepSize;
        }
        return defaultTableModel;
    }

    public void setSimilarityPlotComputeButtonDone() {
        this.mainJFrame.getSimilarityParametersPanel().setSimilarityComputationButtonDone();
    }

    public boolean areSequencesSorted() {
        return this.mainJFrame.getGridParametersPanel().getSortSequenceListsJCheckBox().isSelected();
    }

    public HighlightJFrame getHighlightJFrame() {
        return this.highlightJFrame;
    }

    public static void setAllComponentsEnabled(boolean enabled, Container container) {
        container.setEnabled(enabled);
        for (Component componenet : container.getComponents()) {
            componenet.setEnabled(enabled);
        }
    }

    public void showFrequencyColorsSelectionJFrame() {
        if (this.freqColor == null) {
            this.freqColor = new FrequencyColorsJFrame(this);
            this.freqColor.setLocation(this.mainJFrame.getX() + this.mainJFrame.getWidth() + 1, this.mainJFrame.getY() + this.mainJFrame.getHeight() / 2);
        }
        this.freqColor.setVisible(true);
    }

    public void showProfileGridOverviewJFrame() {
        if (this.profileGridOverviewJFrame == null) {
            this.profileGridOverviewJFrame = new OverviewJFrame(this, this.profileGridJFrame.getTitle() + " ProfileGrid Overview");
            this.profileGridOverviewJFrame.setLocation(this.profileGridJFrame.getX(), this.profileGridJFrame.getY() + this.profileGridJFrame.getHeight());
        }
        this.profileGridOverviewJFrame.displayProfileGridOverview(this.topProfileGrid);
        this.profileGridOverviewJFrame.setVisible(true);
    }

    public void showAlignmentWindow() {
        this.alignmentWindow.setVisible(true);
        this.setSelectedAminoAcid();
    }

    public void showAlignmentOverviewJFrame() {
        if (this.alignmentOverviewJFrame == null) {
            this.alignmentOverviewJFrame = new OverviewJFrame(this, this.profileGridJFrame.getTitle() + " Alignment Overview");
            this.alignmentOverviewJFrame.setLocation(this.profileGridJFrame.getX(), this.profileGridJFrame.getY() + this.profileGridJFrame.getHeight());
        }
        this.alignmentOverviewJFrame.displayAlignmentOverview(this.topProfileGrid.getAnalysisOptions().columnsPerTier, this.topProfileGrid);
        this.alignmentOverviewJFrame.setVisible(true);
    }

    public void showMetaDataColumnsJFrame() {
        if (this.metaDataColumnsJFrame == null) {
            this.metaDataColumnsJFrame = new MetaDataColumnsJFrame(this);
        }
        this.metaDataColumnsJFrame.showMetaDataFileSelectionDialog();
    }

    public void outputExcelFile() {
        ProfileGrid profileGrid = this.setOutputData();
        profileGrid.outputExcelFile();
    }

    public void outputFASTAFile() {
        ProfileGrid profileGrid = this.setOutputData();
        FASTAFileWriter.writeFASTAFile(profileGrid.getAnalysisOptions().outputFilename, this.multipleSequenceAlignment, profileGrid.getAnalysisOptions());
    }

    public void outputImageFile() {
        ProfileGrid profileGrid = this.setOutputData();
        ImageFileWriter imageWriter = new ImageFileWriter();
        imageWriter.createImage(profileGrid.getAnalysisOptions().outputFilename, profileGrid);
    }

    public void outputPyMOLScript() {
        ProfileGrid profileGrid = this.setOutputData();
        profileGrid.outputPyMOLScript();
    }

    private ProfileGrid setOutputData() {
        int lastColumn;
        int firstColumn;
        String pdbFile;
        ExportJPanel exportJPanel = this.mainJFrame.getExportPanel();
        int selectedProfileGrid = exportJPanel.getSelectedProfileGrid();
        ProfileGrid profileGrid = selectedProfileGrid == 0 ? this.topProfileGrid : this.bottomProfileGrid;
        AnalysisOptions analysisOptions = profileGrid.getAnalysisOptions();
        analysisOptions.pdbFile = pdbFile = exportJPanel.getPDBFile();
        int columnsPerTier = exportJPanel.getColumnsPerTier();
        if (columnsPerTier > 0) {
            analysisOptions.columnsPerTier = columnsPerTier;
        }
        if ((firstColumn = exportJPanel.getFirstColumn()) > 0) {
            analysisOptions.firstColumn = firstColumn;
        }
        if ((lastColumn = exportJPanel.getLastColumn()) > 0) {
            analysisOptions.lastColumn = lastColumn;
        }
        analysisOptions.outputFilename = exportJPanel.getOutputFilename();
        return profileGrid;
    }

    public void updateActiveBins() {
        int i;
        JComboBox numberOfBinsJComboBox = this.freqColor.getNumberOfBinsJComboBox();
        Vector<JTextField> thresholdValueJTextFields = this.freqColor.getThresholdValueJTextFields();
        Vector<JComboBox> colorValuesJComboBoxes = this.freqColor.getColorValuesJComboBoxes();
        for (i = ((Integer)numberOfBinsJComboBox.getSelectedItem()).intValue(); i > 0; --i) {
            thresholdValueJTextFields.get(i - 1).setEnabled(true);
            colorValuesJComboBoxes.get(i - 1).setEnabled(true);
        }
        for (i = ((Integer)numberOfBinsJComboBox.getSelectedItem()).intValue(); i < thresholdValueJTextFields.size(); ++i) {
            thresholdValueJTextFields.get(i).setEnabled(false);
            colorValuesJComboBoxes.get(i).setEnabled(false);
        }
        this.updateTopProfileGrid();
    }

    private ConservationRange getFrequencyColorConservationRanges() {
        if (this.freqColor == null) {
            return ConservationRange.DEFAULT_CONSERVATION_RANGE;
        }
        Vector<JTextField> thresholdValueJTextFields = this.freqColor.getThresholdValueJTextFields();
        Vector<JComboBox> colorValuesJComboBoxes = this.freqColor.getColorValuesJComboBoxes();
        ConservationRange cRange = new ConservationRange();
        for (int i = 0; i < thresholdValueJTextFields.size(); ++i) {
            try {
                JTextField thresholdValueJTextField = thresholdValueJTextFields.get(i);
                if (!thresholdValueJTextField.isEnabled()) continue;
                cRange.addConservationRange(Double.parseDouble(thresholdValueJTextField.getText()), (Colour)colorValuesJComboBoxes.get(i).getSelectedItem());
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return cRange;
    }

    public void showAboutDialog() {
        this.mainJFrame.showAboutDialog();
    }

    public void onRegExFiltersChanged(String sequenceName, String sequence) {
        SequenceFilter filter = new SequenceFilter();
        filter.regexFilter(this.multipleSequenceAlignment, sequenceName, sequence);
        GridParametersJPanel gridParametersJPanel = this.mainJFrame.getGridParametersPanel();
        GrepSequenceJComboBox highlightSequenceBlank = this.highlightJFrame.getHighlightSequenceBlank();
        GrepSequenceJComboBox referenceSequenceBlank = gridParametersJPanel.getReferenceSequenceBlank();
        highlightSequenceBlank.removeActionListener(this.highlightJFrame);
        referenceSequenceBlank.removeActionListener(gridParametersJPanel);
        if (referenceSequenceBlank.getItemCount() > 0) {
            referenceSequenceBlank.setSelectedIndex(0);
        }
        if (referenceSequenceBlank.getItemCount() > 0) {
            highlightSequenceBlank.setSelectedIndex(0);
        }
        highlightSequenceBlank.addActionListener(this.highlightJFrame);
        referenceSequenceBlank.addActionListener(gridParametersJPanel);
        this.topProfileGrid.getAnalysisOptions().recalculateSorting = true;
        this.bottomProfileGrid.getAnalysisOptions().recalculateSorting = true;
        this.updateTopProfileGrid();
    }

    public void onMetaDataFilterChanged(List<String> matchingSequences) {
        SequenceFilter filter = new SequenceFilter();
        filter.nameListFilter(this.multipleSequenceAlignment, matchingSequences);
        this.topProfileGrid.getAnalysisOptions().recalculateSorting = true;
        this.bottomProfileGrid.getAnalysisOptions().recalculateSorting = true;
        this.updateTopProfileGrid();
    }

    public void recalculateSorting() {
        this.topProfileGrid.getAnalysisOptions().recalculateSorting = true;
        this.bottomProfileGrid.getAnalysisOptions().recalculateSorting = true;
        this.updateTopProfileGrid();
    }

    public void computeSimilarityParameters() {
        this.topProfileGrid.getAnalysisOptions().recalculateSimilarityParameters = true;
        this.updateTopProfileGrid();
    }

    public void onFilterchange() {
        this.topProfileGrid.getAnalysisOptions().recalculateSorting = true;
        this.bottomProfileGrid.getAnalysisOptions().recalculateSorting = true;
        this.updateTopProfileGrid();
    }

    @Override
    public void onSimilarityParametersComputed() {
        SimilarityParametersJPanel similarityParametersJPanel = this.mainJFrame.getSimilarityParametersPanel();
        similarityParametersJPanel.enableComputeSimilarityParametersButton();
        this.updateTopProfileGrid();
    }

    public void setDualDisplayMode(int selectedIndex) {
        ExportJPanel exportJPanel = this.mainJFrame.getExportPanel();
        switch (selectedIndex) {
            case 0: {
                this.profileGridJFrame.setDualDisplay(false);
                exportJPanel.setDualDisplayEnabled(false);
                break;
            }
            case 1: {
                this.profileGridJFrame.setDualDisplay(true);
                exportJPanel.setDualDisplayEnabled(true);
                break;
            }
            case 2: {
                this.profileGridJFrame.setDualDisplay(true);
                exportJPanel.setDualDisplayEnabled(true);
            }
        }
        AnalysisOptions analysisOptions = this.bottomProfileGrid.getAnalysisOptions();
        analysisOptions.recalculateSorting = true;
        this.updateSpecificProfileGrid(this.bottomProfileGrid);
        this.profileGridJFrame.resetBottomProfileGrid(this.bottomProfileGrid);
    }

    public void showSelectOutputFileDialog() {
        FileDialog fileDialog = new FileDialog((Frame)this.mainJFrame, "Choose Output File", 1);
        fileDialog.setVisible(true);
        String outputFileName = fileDialog.getDirectory() + fileDialog.getFile();
        if (fileDialog.getFile() != null) {
            ExportJPanel exportJPanel = this.mainJFrame.getExportPanel();
            exportJPanel.getOutputFileBlank().setText(outputFileName);
        }
    }
}

