/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.presenter;

import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import jprofilegrid.calculations.MultipleSequenceAlignment;
import jprofilegrid.calculations.Sequence;
import jprofilegrid.model.AnalysisOptions;
import jprofilegrid.presenter.SelectionFilterResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceFilter {
    public boolean regexFilter(MultipleSequenceAlignment multipleSequenceAlignment, String speciesNameFilter, String sequenceNameFilter) {
        boolean atLeastOneSequencePassedFilter = false;
        Pattern sequenceNameMatcher = Pattern.compile(speciesNameFilter);
        Pattern speciesNameMatcher = Pattern.compile(sequenceNameFilter);
        List<Sequence> sequences = multipleSequenceAlignment.getSequences();
        for (Sequence sequence : sequences) {
            if (sequenceNameMatcher.matcher(sequence.getName()).find() && speciesNameMatcher.matcher(sequence.getSequence()).find()) {
                sequence.setSequenceNamePassedRegexFilter(true);
                atLeastOneSequencePassedFilter = true;
                continue;
            }
            sequence.setSequenceNamePassedRegexFilter(false);
        }
        return atLeastOneSequencePassedFilter;
    }

    public boolean nameListFilter(MultipleSequenceAlignment multipleSequenceAlignment, List<String> matchingSequences) {
        boolean atLeastOneSequencePassedFilter = false;
        List<Sequence> sequences = multipleSequenceAlignment.getSequences();
        for (Sequence sequence : sequences) {
            if (matchingSequences.contains(sequence.getName())) {
                sequence.setSequencePassedMetaDataFilter(true);
                atLeastOneSequencePassedFilter = true;
                continue;
            }
            sequence.setSequencePassedMetaDataFilter(false);
        }
        return atLeastOneSequencePassedFilter;
    }

    public static SelectionFilterResults selectionFilter(int row, int col, MultipleSequenceAlignment multipleSequenceAlignment, AnalysisOptions analysisOptions, boolean displayResidueIfPresent, boolean showAlignment, int startIndex) {
        StringBuffer listOfSequences = new StringBuffer();
        String currentSymbol = analysisOptions.sortedData.getSortedAminoAcidSymbols()[row];
        boolean currentSymbolIsGap = currentSymbol.equalsIgnoreCase(".") || currentSymbol.equalsIgnoreCase("-");
        List<Sequence> sequences = multipleSequenceAlignment.getSequences();
        Vector<Sequence> alignmentSequences = new Vector<Sequence>();
        alignmentSequences.add(analysisOptions.referenceSequence);
        if (analysisOptions.referenceSequence != analysisOptions.highlightSequence) {
            alignmentSequences.add(analysisOptions.highlightSequence);
        }
        for (int i = 0; i < sequences.size(); ++i) {
            boolean comparisonSymbolIsGap;
            Sequence sequence = sequences.get(i);
            String comparisonSymbol = sequence.getAminoAcid(col);
            boolean bl = comparisonSymbolIsGap = comparisonSymbol.equalsIgnoreCase("-") || comparisonSymbol.equalsIgnoreCase(".");
            if (displayResidueIfPresent) {
                if (comparisonSymbol.equalsIgnoreCase(currentSymbol) || currentSymbolIsGap && comparisonSymbolIsGap) {
                    listOfSequences = listOfSequences.append(sequence.getName().concat("\n"));
                    if (showAlignment) {
                        alignmentSequences.add(sequence);
                    }
                    sequence.setSequencePassedSelectionFilter(true);
                    continue;
                }
                sequence.setSequencePassedSelectionFilter(false);
                continue;
            }
            if (!(comparisonSymbol.equalsIgnoreCase(currentSymbol) || currentSymbolIsGap && comparisonSymbolIsGap)) {
                listOfSequences = listOfSequences.append(sequence.getName().concat("\n"));
                if (showAlignment) {
                    alignmentSequences.add(sequence);
                }
                sequence.setSequencePassedSelectionFilter(true);
                continue;
            }
            sequence.setSequencePassedSelectionFilter(false);
        }
        StringBuilder sequenceNames = new StringBuilder("\n");
        StringBuilder alignment = new StringBuilder("");
        if (showAlignment) {
            int i;
            for (int i2 = 0; i2 < alignmentSequences.size(); ++i2) {
                sequenceNames.append(alignmentSequences.get(i2).getName() + "\n");
            }
            int maxSequenceLength = 0;
            for (i = 0; i < alignmentSequences.size(); ++i) {
                if (alignmentSequences.get(i).getActualLength() <= maxSequenceLength) continue;
                maxSequenceLength = i;
            }
            for (i = startIndex; i < alignmentSequences.get(maxSequenceLength).getActualLength(); ++i) {
                if (i % 10 == 0) {
                    alignment.append(i);
                    i += Integer.toString(i).length() - 1;
                    continue;
                }
                alignment.append(" ");
            }
            alignment.append("\n");
            for (i = 0; i < alignmentSequences.size(); ++i) {
                int sequenceCounter;
                if (i == 0) {
                    alignment.append(alignmentSequences.get(0).getSequence() + "\n");
                    continue;
                }
                StringBuffer currentSequenceString = new StringBuffer("");
                for (sequenceCounter = 0; sequenceCounter < alignmentSequences.get(i).getActualLength() && sequenceCounter < alignmentSequences.get(0).getActualLength(); ++sequenceCounter) {
                    if (!alignmentSequences.get(i).getAminoAcid(sequenceCounter).equalsIgnoreCase("-") && alignmentSequences.get(i).getAminoAcid(sequenceCounter).equalsIgnoreCase(alignmentSequences.get(0).getAminoAcid(sequenceCounter))) {
                        currentSequenceString.append(".");
                        continue;
                    }
                    currentSequenceString.append(alignmentSequences.get(i).getAminoAcid(sequenceCounter));
                }
                if (sequenceCounter < alignmentSequences.get(i).getActualLength()) {
                    for (int j = sequenceCounter; j < alignmentSequences.get(i).getActualLength(); ++j) {
                        currentSequenceString.append(alignmentSequences.get(i).getAminoAcid(j));
                    }
                }
                alignment.append(currentSequenceString);
                if (i >= alignmentSequences.size() - 1) continue;
                alignment.append("\n");
            }
        }
        SelectionFilterResults selectionFilterResults = new SelectionFilterResults();
        selectionFilterResults.setAlignmentSequences(alignmentSequences);
        selectionFilterResults.setListOfSequences(listOfSequences);
        selectionFilterResults.setSequenceNames(sequenceNames);
        selectionFilterResults.setAlignment(alignment);
        return selectionFilterResults;
    }
}

