/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.readers;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jprofilegrid.calculations.MultipleSequenceAlignment;
import jprofilegrid.calculations.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class A2MFileReader {
    public static MultipleSequenceAlignment readA2MFile(List<String> data) {
        Hashtable<String, Integer> sequenceIndicesByName = new Hashtable<String, Integer>();
        Vector<Sequence> sequences = new Vector<Sequence>();
        String currentName = "";
        String currentSequence = "";
        String currentLine = "";
        for (int index = 0; index < data.size() && !currentLine.contains(">"); ++index) {
            currentLine = data.get(index);
        }
        for (int j = index - 1; j < data.size(); ++j) {
            int i;
            currentLine = data.get(j);
            if (currentLine.contains(">")) {
                if (!currentSequence.equalsIgnoreCase("")) {
                    String actualName = "";
                    for (i = 0; i < currentName.length(); ++i) {
                        char charValue = currentName.charAt(i);
                        if (charValue == '|') {
                            actualName = actualName + "_";
                            continue;
                        }
                        if (charValue >= '0' && charValue <= '9' || charValue >= 'A' && charValue <= 'Z' || charValue >= 'a' && charValue <= 'z' || charValue == '_') {
                            actualName = actualName + currentName.substring(i, i + 1);
                            continue;
                        }
                        i = currentName.length();
                    }
                    sequences.add(new Sequence(actualName, currentSequence, currentSequence.length(), 0, 1.0));
                    sequenceIndicesByName.put(actualName, sequences.size() - 1);
                }
                currentName = currentLine.replaceFirst(">", "");
                currentSequence = "";
                continue;
            }
            String filteredLine = "";
            for (i = 0; i < currentLine.length(); ++i) {
                if (currentLine.charAt(i) >= 'a' && currentLine.charAt(i) <= 'z' || currentLine.charAt(i) == '.') continue;
                filteredLine = filteredLine + currentLine.charAt(i);
            }
            currentSequence = currentSequence + filteredLine;
        }
        String actualName = "";
        for (int i = 0; i < currentName.length(); ++i) {
            char charValue = currentName.charAt(i);
            if (charValue >= '0' && charValue <= '9' || charValue >= 'A' && charValue <= 'Z' || charValue >= 'a' && charValue <= 'z' || charValue == '_') {
                actualName = actualName + currentName.substring(i, i + 1);
                continue;
            }
            i = currentName.length();
        }
        sequences.add(new Sequence(actualName, currentSequence, currentSequence.length(), 0, 1.0));
        sequenceIndicesByName.put(actualName, sequences.size() - 1);
        return new MultipleSequenceAlignment(null, sequences);
    }
}

