/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.readers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jprofilegrid.JProfileGrid;
import jprofilegrid.calculations.MultipleSequenceAlignment;
import jprofilegrid.readers.A2MFileReader;
import jprofilegrid.readers.FASTAFileReader;
import jprofilegrid.readers.MSFFileReader;
import jprofilegrid.readers.StockholmFileReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSAReaderController {
    public static MultipleSequenceAlignment loadMultipleSequenceAlignment(int msaFileType, int alignmentType, File file) {
        MultipleSequenceAlignment multipleSequenceAlignment = MSAReaderController.readInputFile(msaFileType, file);
        multipleSequenceAlignment.setAlignmentName(file.getName());
        multipleSequenceAlignment.setAlignmentType(alignmentType);
        return multipleSequenceAlignment;
    }

    private static List<String> readInFile(File file) throws IOException {
        ArrayList<String> data = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        while ((line = reader.readLine()) != null) {
            data.add(line);
        }
        reader.close();
        return data;
    }

    public static MultipleSequenceAlignment readInputFile(int msaType, File file) {
        try {
            List<String> data = MSAReaderController.readInFile(file);
            if (msaType == 3) {
                return StockholmFileReader.parseMultipleSequenceAlignment(data);
            }
            if (msaType == 2) {
                return A2MFileReader.readA2MFile(data);
            }
            if (msaType == 1) {
                return FASTAFileReader.readAlignedFasta(data);
            }
            if (msaType == 0) {
                return MSFFileReader.readInMultipleSequenceAlignment(data);
            }
            String filename = file.getName();
            if (filename.contains(".sto")) {
                return StockholmFileReader.parseMultipleSequenceAlignment(data);
            }
            if (filename.contains(".a2m")) {
                return A2MFileReader.readA2MFile(data);
            }
            if (filename.contains(".afa")) {
                return FASTAFileReader.readAlignedFasta(data);
            }
            if (filename.contains(".msf")) {
                return MSFFileReader.readInMultipleSequenceAlignment(data);
            }
        }
        catch (Exception exception) {
            JProfileGrid.onOutOfMemory();
        }
        catch (Error error) {
            JProfileGrid.onOutOfMemory();
        }
        return null;
    }
}

